/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTargetHealthResponse extends ElasticLoadBalancingV2Response implements
        ToCopyableBuilder<DescribeTargetHealthResponse.Builder, DescribeTargetHealthResponse> {
    private static final SdkField<List<TargetHealthDescription>> TARGET_HEALTH_DESCRIPTIONS_FIELD = SdkField
            .<List<TargetHealthDescription>> builder(MarshallingType.LIST)
            .memberName("TargetHealthDescriptions")
            .getter(getter(DescribeTargetHealthResponse::targetHealthDescriptions))
            .setter(setter(Builder::targetHealthDescriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetHealthDescriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TargetHealthDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(TargetHealthDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TARGET_HEALTH_DESCRIPTIONS_FIELD));

    private final List<TargetHealthDescription> targetHealthDescriptions;

    private DescribeTargetHealthResponse(BuilderImpl builder) {
        super(builder);
        this.targetHealthDescriptions = builder.targetHealthDescriptions;
    }

    /**
     * Returns true if the TargetHealthDescriptions property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasTargetHealthDescriptions() {
        return targetHealthDescriptions != null && !(targetHealthDescriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the health of the targets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTargetHealthDescriptions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the health of the targets.
     */
    public List<TargetHealthDescription> targetHealthDescriptions() {
        return targetHealthDescriptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(targetHealthDescriptions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTargetHealthResponse)) {
            return false;
        }
        DescribeTargetHealthResponse other = (DescribeTargetHealthResponse) obj;
        return Objects.equals(targetHealthDescriptions(), other.targetHealthDescriptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeTargetHealthResponse").add("TargetHealthDescriptions", targetHealthDescriptions())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetHealthDescriptions":
            return Optional.ofNullable(clazz.cast(targetHealthDescriptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTargetHealthResponse, T> g) {
        return obj -> g.apply((DescribeTargetHealthResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticLoadBalancingV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTargetHealthResponse> {
        /**
         * <p>
         * Information about the health of the targets.
         * </p>
         * 
         * @param targetHealthDescriptions
         *        Information about the health of the targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetHealthDescriptions(Collection<TargetHealthDescription> targetHealthDescriptions);

        /**
         * <p>
         * Information about the health of the targets.
         * </p>
         * 
         * @param targetHealthDescriptions
         *        Information about the health of the targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetHealthDescriptions(TargetHealthDescription... targetHealthDescriptions);

        /**
         * <p>
         * Information about the health of the targets.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TargetHealthDescription>.Builder} avoiding
         * the need to create one manually via {@link List<TargetHealthDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TargetHealthDescription>.Builder#build()} is called
         * immediately and its result is passed to {@link #targetHealthDescriptions(List<TargetHealthDescription>)}.
         * 
         * @param targetHealthDescriptions
         *        a consumer that will call methods on {@link List<TargetHealthDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetHealthDescriptions(List<TargetHealthDescription>)
         */
        Builder targetHealthDescriptions(Consumer<TargetHealthDescription.Builder>... targetHealthDescriptions);
    }

    static final class BuilderImpl extends ElasticLoadBalancingV2Response.BuilderImpl implements Builder {
        private List<TargetHealthDescription> targetHealthDescriptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTargetHealthResponse model) {
            super(model);
            targetHealthDescriptions(model.targetHealthDescriptions);
        }

        public final Collection<TargetHealthDescription.Builder> getTargetHealthDescriptions() {
            return targetHealthDescriptions != null ? targetHealthDescriptions.stream().map(TargetHealthDescription::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targetHealthDescriptions(Collection<TargetHealthDescription> targetHealthDescriptions) {
            this.targetHealthDescriptions = TargetHealthDescriptionsCopier.copy(targetHealthDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetHealthDescriptions(TargetHealthDescription... targetHealthDescriptions) {
            targetHealthDescriptions(Arrays.asList(targetHealthDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetHealthDescriptions(Consumer<TargetHealthDescription.Builder>... targetHealthDescriptions) {
            targetHealthDescriptions(Stream.of(targetHealthDescriptions)
                    .map(c -> TargetHealthDescription.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargetHealthDescriptions(Collection<TargetHealthDescription.BuilderImpl> targetHealthDescriptions) {
            this.targetHealthDescriptions = TargetHealthDescriptionsCopier.copyFromBuilder(targetHealthDescriptions);
        }

        @Override
        public DescribeTargetHealthResponse build() {
            return new DescribeTargetHealthResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
