/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a forward action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ForwardActionConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ForwardActionConfig.Builder, ForwardActionConfig> {
    private static final SdkField<List<TargetGroupTuple>> TARGET_GROUPS_FIELD = SdkField
            .<List<TargetGroupTuple>> builder(MarshallingType.LIST)
            .memberName("TargetGroups")
            .getter(getter(ForwardActionConfig::targetGroups))
            .setter(setter(Builder::targetGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TargetGroupTuple> builder(MarshallingType.SDK_POJO)
                                            .constructor(TargetGroupTuple::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TargetGroupStickinessConfig> TARGET_GROUP_STICKINESS_CONFIG_FIELD = SdkField
            .<TargetGroupStickinessConfig> builder(MarshallingType.SDK_POJO)
            .memberName("TargetGroupStickinessConfig")
            .getter(getter(ForwardActionConfig::targetGroupStickinessConfig))
            .setter(setter(Builder::targetGroupStickinessConfig))
            .constructor(TargetGroupStickinessConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetGroupStickinessConfig")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_GROUPS_FIELD,
            TARGET_GROUP_STICKINESS_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<TargetGroupTuple> targetGroups;

    private final TargetGroupStickinessConfig targetGroupStickinessConfig;

    private ForwardActionConfig(BuilderImpl builder) {
        this.targetGroups = builder.targetGroups;
        this.targetGroupStickinessConfig = builder.targetGroupStickinessConfig;
    }

    /**
     * Returns true if the TargetGroups property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTargetGroups() {
        return targetGroups != null && !(targetGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more target groups. For Network Load Balancers, you can specify a single target group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTargetGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more target groups. For Network Load Balancers, you can specify a single target group.
     */
    public List<TargetGroupTuple> targetGroups() {
        return targetGroups;
    }

    /**
     * <p>
     * The target group stickiness for the rule.
     * </p>
     * 
     * @return The target group stickiness for the rule.
     */
    public TargetGroupStickinessConfig targetGroupStickinessConfig() {
        return targetGroupStickinessConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetGroups());
        hashCode = 31 * hashCode + Objects.hashCode(targetGroupStickinessConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ForwardActionConfig)) {
            return false;
        }
        ForwardActionConfig other = (ForwardActionConfig) obj;
        return Objects.equals(targetGroups(), other.targetGroups())
                && Objects.equals(targetGroupStickinessConfig(), other.targetGroupStickinessConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ForwardActionConfig").add("TargetGroups", targetGroups())
                .add("TargetGroupStickinessConfig", targetGroupStickinessConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetGroups":
            return Optional.ofNullable(clazz.cast(targetGroups()));
        case "TargetGroupStickinessConfig":
            return Optional.ofNullable(clazz.cast(targetGroupStickinessConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ForwardActionConfig, T> g) {
        return obj -> g.apply((ForwardActionConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ForwardActionConfig> {
        /**
         * <p>
         * One or more target groups. For Network Load Balancers, you can specify a single target group.
         * </p>
         * 
         * @param targetGroups
         *        One or more target groups. For Network Load Balancers, you can specify a single target group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroups(Collection<TargetGroupTuple> targetGroups);

        /**
         * <p>
         * One or more target groups. For Network Load Balancers, you can specify a single target group.
         * </p>
         * 
         * @param targetGroups
         *        One or more target groups. For Network Load Balancers, you can specify a single target group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroups(TargetGroupTuple... targetGroups);

        /**
         * <p>
         * One or more target groups. For Network Load Balancers, you can specify a single target group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TargetGroupTuple>.Builder} avoiding the
         * need to create one manually via {@link List<TargetGroupTuple>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TargetGroupTuple>.Builder#build()} is called immediately and
         * its result is passed to {@link #targetGroups(List<TargetGroupTuple>)}.
         * 
         * @param targetGroups
         *        a consumer that will call methods on {@link List<TargetGroupTuple>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetGroups(List<TargetGroupTuple>)
         */
        Builder targetGroups(Consumer<TargetGroupTuple.Builder>... targetGroups);

        /**
         * <p>
         * The target group stickiness for the rule.
         * </p>
         * 
         * @param targetGroupStickinessConfig
         *        The target group stickiness for the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroupStickinessConfig(TargetGroupStickinessConfig targetGroupStickinessConfig);

        /**
         * <p>
         * The target group stickiness for the rule.
         * </p>
         * This is a convenience that creates an instance of the {@link TargetGroupStickinessConfig.Builder} avoiding
         * the need to create one manually via {@link TargetGroupStickinessConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link TargetGroupStickinessConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #targetGroupStickinessConfig(TargetGroupStickinessConfig)}.
         * 
         * @param targetGroupStickinessConfig
         *        a consumer that will call methods on {@link TargetGroupStickinessConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetGroupStickinessConfig(TargetGroupStickinessConfig)
         */
        default Builder targetGroupStickinessConfig(Consumer<TargetGroupStickinessConfig.Builder> targetGroupStickinessConfig) {
            return targetGroupStickinessConfig(TargetGroupStickinessConfig.builder().applyMutation(targetGroupStickinessConfig)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<TargetGroupTuple> targetGroups = DefaultSdkAutoConstructList.getInstance();

        private TargetGroupStickinessConfig targetGroupStickinessConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ForwardActionConfig model) {
            targetGroups(model.targetGroups);
            targetGroupStickinessConfig(model.targetGroupStickinessConfig);
        }

        public final Collection<TargetGroupTuple.Builder> getTargetGroups() {
            return targetGroups != null ? targetGroups.stream().map(TargetGroupTuple::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder targetGroups(Collection<TargetGroupTuple> targetGroups) {
            this.targetGroups = TargetGroupListCopier.copy(targetGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroups(TargetGroupTuple... targetGroups) {
            targetGroups(Arrays.asList(targetGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroups(Consumer<TargetGroupTuple.Builder>... targetGroups) {
            targetGroups(Stream.of(targetGroups).map(c -> TargetGroupTuple.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTargetGroups(Collection<TargetGroupTuple.BuilderImpl> targetGroups) {
            this.targetGroups = TargetGroupListCopier.copyFromBuilder(targetGroups);
        }

        public final TargetGroupStickinessConfig.Builder getTargetGroupStickinessConfig() {
            return targetGroupStickinessConfig != null ? targetGroupStickinessConfig.toBuilder() : null;
        }

        @Override
        public final Builder targetGroupStickinessConfig(TargetGroupStickinessConfig targetGroupStickinessConfig) {
            this.targetGroupStickinessConfig = targetGroupStickinessConfig;
            return this;
        }

        public final void setTargetGroupStickinessConfig(TargetGroupStickinessConfig.BuilderImpl targetGroupStickinessConfig) {
            this.targetGroupStickinessConfig = targetGroupStickinessConfig != null ? targetGroupStickinessConfig.build() : null;
        }

        @Override
        public ForwardActionConfig build() {
            return new ForwardActionConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
