/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the state of the load balancer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoadBalancerState implements SdkPojo, Serializable,
        ToCopyableBuilder<LoadBalancerState.Builder, LoadBalancerState> {
    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Code")
            .getter(getter(LoadBalancerState::codeAsString)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Reason")
            .getter(getter(LoadBalancerState::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String code;

    private final String reason;

    private LoadBalancerState(BuilderImpl builder) {
        this.code = builder.code;
        this.reason = builder.reason;
    }

    /**
     * <p>
     * The state code. The initial state of the load balancer is <code>provisioning</code>. After the load balancer is
     * fully set up and ready to route traffic, its state is <code>active</code>. If the load balancer could not be set
     * up, its state is <code>failed</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link LoadBalancerStateEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codeAsString}.
     * </p>
     * 
     * @return The state code. The initial state of the load balancer is <code>provisioning</code>. After the load
     *         balancer is fully set up and ready to route traffic, its state is <code>active</code>. If the load
     *         balancer could not be set up, its state is <code>failed</code>.
     * @see LoadBalancerStateEnum
     */
    public LoadBalancerStateEnum code() {
        return LoadBalancerStateEnum.fromValue(code);
    }

    /**
     * <p>
     * The state code. The initial state of the load balancer is <code>provisioning</code>. After the load balancer is
     * fully set up and ready to route traffic, its state is <code>active</code>. If the load balancer could not be set
     * up, its state is <code>failed</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link LoadBalancerStateEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codeAsString}.
     * </p>
     * 
     * @return The state code. The initial state of the load balancer is <code>provisioning</code>. After the load
     *         balancer is fully set up and ready to route traffic, its state is <code>active</code>. If the load
     *         balancer could not be set up, its state is <code>failed</code>.
     * @see LoadBalancerStateEnum
     */
    public String codeAsString() {
        return code;
    }

    /**
     * <p>
     * A description of the state.
     * </p>
     * 
     * @return A description of the state.
     */
    public String reason() {
        return reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(codeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancerState)) {
            return false;
        }
        LoadBalancerState other = (LoadBalancerState) obj;
        return Objects.equals(codeAsString(), other.codeAsString()) && Objects.equals(reason(), other.reason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LoadBalancerState").add("Code", codeAsString()).add("Reason", reason()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Code":
            return Optional.ofNullable(clazz.cast(codeAsString()));
        case "Reason":
            return Optional.ofNullable(clazz.cast(reason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoadBalancerState, T> g) {
        return obj -> g.apply((LoadBalancerState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoadBalancerState> {
        /**
         * <p>
         * The state code. The initial state of the load balancer is <code>provisioning</code>. After the load balancer
         * is fully set up and ready to route traffic, its state is <code>active</code>. If the load balancer could not
         * be set up, its state is <code>failed</code>.
         * </p>
         * 
         * @param code
         *        The state code. The initial state of the load balancer is <code>provisioning</code>. After the load
         *        balancer is fully set up and ready to route traffic, its state is <code>active</code>. If the load
         *        balancer could not be set up, its state is <code>failed</code>.
         * @see LoadBalancerStateEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoadBalancerStateEnum
         */
        Builder code(String code);

        /**
         * <p>
         * The state code. The initial state of the load balancer is <code>provisioning</code>. After the load balancer
         * is fully set up and ready to route traffic, its state is <code>active</code>. If the load balancer could not
         * be set up, its state is <code>failed</code>.
         * </p>
         * 
         * @param code
         *        The state code. The initial state of the load balancer is <code>provisioning</code>. After the load
         *        balancer is fully set up and ready to route traffic, its state is <code>active</code>. If the load
         *        balancer could not be set up, its state is <code>failed</code>.
         * @see LoadBalancerStateEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoadBalancerStateEnum
         */
        Builder code(LoadBalancerStateEnum code);

        /**
         * <p>
         * A description of the state.
         * </p>
         * 
         * @param reason
         *        A description of the state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancerState model) {
            code(model.code);
            reason(model.reason);
        }

        public final String getCode() {
            return code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(LoadBalancerStateEnum code) {
            this.code(code == null ? null : code.toString());
            return this;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        public final String getReason() {
            return reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public LoadBalancerState build() {
            return new LoadBalancerState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
