/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyTargetGroupAttributesResponse extends ElasticLoadBalancingV2Response implements
        ToCopyableBuilder<ModifyTargetGroupAttributesResponse.Builder, ModifyTargetGroupAttributesResponse> {
    private static final SdkField<List<TargetGroupAttribute>> ATTRIBUTES_FIELD = SdkField
            .<List<TargetGroupAttribute>> builder(MarshallingType.LIST)
            .memberName("Attributes")
            .getter(getter(ModifyTargetGroupAttributesResponse::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TargetGroupAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(TargetGroupAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD));

    private final List<TargetGroupAttribute> attributes;

    private ModifyTargetGroupAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.attributes = builder.attributes;
    }

    /**
     * Returns true if the Attributes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the attributes.
     */
    public List<TargetGroupAttribute> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyTargetGroupAttributesResponse)) {
            return false;
        }
        ModifyTargetGroupAttributesResponse other = (ModifyTargetGroupAttributesResponse) obj;
        return Objects.equals(attributes(), other.attributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModifyTargetGroupAttributesResponse").add("Attributes", attributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyTargetGroupAttributesResponse, T> g) {
        return obj -> g.apply((ModifyTargetGroupAttributesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticLoadBalancingV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyTargetGroupAttributesResponse> {
        /**
         * <p>
         * Information about the attributes.
         * </p>
         * 
         * @param attributes
         *        Information about the attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Collection<TargetGroupAttribute> attributes);

        /**
         * <p>
         * Information about the attributes.
         * </p>
         * 
         * @param attributes
         *        Information about the attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(TargetGroupAttribute... attributes);

        /**
         * <p>
         * Information about the attributes.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TargetGroupAttribute>.Builder} avoiding the
         * need to create one manually via {@link List<TargetGroupAttribute>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TargetGroupAttribute>.Builder#build()} is called immediately
         * and its result is passed to {@link #attributes(List<TargetGroupAttribute>)}.
         * 
         * @param attributes
         *        a consumer that will call methods on {@link List<TargetGroupAttribute>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(List<TargetGroupAttribute>)
         */
        Builder attributes(Consumer<TargetGroupAttribute.Builder>... attributes);
    }

    static final class BuilderImpl extends ElasticLoadBalancingV2Response.BuilderImpl implements Builder {
        private List<TargetGroupAttribute> attributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyTargetGroupAttributesResponse model) {
            super(model);
            attributes(model.attributes);
        }

        public final Collection<TargetGroupAttribute.Builder> getAttributes() {
            return attributes != null ? attributes.stream().map(TargetGroupAttribute::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder attributes(Collection<TargetGroupAttribute> attributes) {
            this.attributes = TargetGroupAttributesCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(TargetGroupAttribute... attributes) {
            attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<TargetGroupAttribute.Builder>... attributes) {
            attributes(Stream.of(attributes).map(c -> TargetGroupAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAttributes(Collection<TargetGroupAttribute.BuilderImpl> attributes) {
            this.attributes = TargetGroupAttributesCopier.copyFromBuilder(attributes);
        }

        @Override
        public ModifyTargetGroupAttributesResponse build() {
            return new ModifyTargetGroupAttributesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
