/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a path pattern condition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PathPatternConditionConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<PathPatternConditionConfig.Builder, PathPatternConditionConfig> {
    private static final SdkField<List<String>> VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Values")
            .getter(getter(PathPatternConditionConfig::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> values;

    private PathPatternConditionConfig(BuilderImpl builder) {
        this.values = builder.values;
    }

    /**
     * Returns true if the Values property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more path patterns to compare against the request URL. The maximum size of each string is 128 characters.
     * The comparison is case sensitive. The following wildcard characters are supported: * (matches 0 or more
     * characters) and ? (matches exactly 1 character).
     * </p>
     * <p>
     * If you specify multiple strings, the condition is satisfied if one of them matches the request URL. The path
     * pattern is compared only to the path of the URL, not to its query string. To compare against the query string,
     * use <a>QueryStringConditionConfig</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more path patterns to compare against the request URL. The maximum size of each string is 128
     *         characters. The comparison is case sensitive. The following wildcard characters are supported: * (matches
     *         0 or more characters) and ? (matches exactly 1 character).</p>
     *         <p>
     *         If you specify multiple strings, the condition is satisfied if one of them matches the request URL. The
     *         path pattern is compared only to the path of the URL, not to its query string. To compare against the
     *         query string, use <a>QueryStringConditionConfig</a>.
     */
    public List<String> values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(values());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PathPatternConditionConfig)) {
            return false;
        }
        PathPatternConditionConfig other = (PathPatternConditionConfig) obj;
        return Objects.equals(values(), other.values());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PathPatternConditionConfig").add("Values", values()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PathPatternConditionConfig, T> g) {
        return obj -> g.apply((PathPatternConditionConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PathPatternConditionConfig> {
        /**
         * <p>
         * One or more path patterns to compare against the request URL. The maximum size of each string is 128
         * characters. The comparison is case sensitive. The following wildcard characters are supported: * (matches 0
         * or more characters) and ? (matches exactly 1 character).
         * </p>
         * <p>
         * If you specify multiple strings, the condition is satisfied if one of them matches the request URL. The path
         * pattern is compared only to the path of the URL, not to its query string. To compare against the query
         * string, use <a>QueryStringConditionConfig</a>.
         * </p>
         * 
         * @param values
         *        One or more path patterns to compare against the request URL. The maximum size of each string is 128
         *        characters. The comparison is case sensitive. The following wildcard characters are supported: *
         *        (matches 0 or more characters) and ? (matches exactly 1 character).</p>
         *        <p>
         *        If you specify multiple strings, the condition is satisfied if one of them matches the request URL.
         *        The path pattern is compared only to the path of the URL, not to its query string. To compare against
         *        the query string, use <a>QueryStringConditionConfig</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * One or more path patterns to compare against the request URL. The maximum size of each string is 128
         * characters. The comparison is case sensitive. The following wildcard characters are supported: * (matches 0
         * or more characters) and ? (matches exactly 1 character).
         * </p>
         * <p>
         * If you specify multiple strings, the condition is satisfied if one of them matches the request URL. The path
         * pattern is compared only to the path of the URL, not to its query string. To compare against the query
         * string, use <a>QueryStringConditionConfig</a>.
         * </p>
         * 
         * @param values
         *        One or more path patterns to compare against the request URL. The maximum size of each string is 128
         *        characters. The comparison is case sensitive. The following wildcard characters are supported: *
         *        (matches 0 or more characters) and ? (matches exactly 1 character).</p>
         *        <p>
         *        If you specify multiple strings, the condition is satisfied if one of them matches the request URL.
         *        The path pattern is compared only to the path of the URL, not to its query string. To compare against
         *        the query string, use <a>QueryStringConditionConfig</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);
    }

    static final class BuilderImpl implements Builder {
        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PathPatternConditionConfig model) {
            values(model.values);
        }

        public final Collection<String> getValues() {
            return values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = ListOfStringCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = ListOfStringCopier.copy(values);
        }

        @Override
        public PathPatternConditionConfig build() {
            return new PathPatternConditionConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
