/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the current health of a target.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetHealth implements SdkPojo, Serializable, ToCopyableBuilder<TargetHealth.Builder, TargetHealth> {
    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(TargetHealth::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Reason")
            .getter(getter(TargetHealth::reasonAsString)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(TargetHealth::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD, REASON_FIELD,
            DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String state;

    private final String reason;

    private final String description;

    private TargetHealth(BuilderImpl builder) {
        this.state = builder.state;
        this.reason = builder.reason;
        this.description = builder.description;
    }

    /**
     * <p>
     * The state of the target.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link TargetHealthStateEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the target.
     * @see TargetHealthStateEnum
     */
    public TargetHealthStateEnum state() {
        return TargetHealthStateEnum.fromValue(state);
    }

    /**
     * <p>
     * The state of the target.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link TargetHealthStateEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the target.
     * @see TargetHealthStateEnum
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The reason code.
     * </p>
     * <p>
     * If the target state is <code>healthy</code>, a reason code is not provided.
     * </p>
     * <p>
     * If the target state is <code>initial</code>, the reason code can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Elb.RegistrationInProgress</code> - The target is in the process of being registered with the load
     * balancer.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Elb.InitialHealthChecking</code> - The load balancer is still sending the target the minimum number of
     * health checks required to determine its health status.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the target state is <code>unhealthy</code>, the reason code can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Target.ResponseCodeMismatch</code> - The health checks did not return an expected HTTP code. Applies only
     * to Application Load Balancers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Target.Timeout</code> - The health check requests timed out. Applies only to Application Load Balancers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Target.FailedHealthChecks</code> - The load balancer received an error while establishing a connection to
     * the target or the target response was malformed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Elb.InternalError</code> - The health checks failed due to an internal error. Applies only to Application
     * Load Balancers.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the target state is <code>unused</code>, the reason code can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Target.NotRegistered</code> - The target is not registered with the target group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Target.NotInUse</code> - The target group is not used by any load balancer or the target is in an
     * Availability Zone that is not enabled for its load balancer.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Target.InvalidState</code> - The target is in the stopped or terminated state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Target.IpUnusable</code> - The target IP address is reserved for use by a load balancer.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the target state is <code>draining</code>, the reason code can be the following value:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Target.DeregistrationInProgress</code> - The target is in the process of being deregistered and the
     * deregistration delay period has not expired.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the target state is <code>unavailable</code>, the reason code can be the following value:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Target.HealthCheckDisabled</code> - Health checks are disabled for the target group. Applies only to
     * Application Load Balancers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Elb.InternalError</code> - Target health is unavailable due to an internal error. Applies only to Network
     * Load Balancers.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link TargetHealthReasonEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #reasonAsString}.
     * </p>
     * 
     * @return The reason code.</p>
     *         <p>
     *         If the target state is <code>healthy</code>, a reason code is not provided.
     *         </p>
     *         <p>
     *         If the target state is <code>initial</code>, the reason code can be one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Elb.RegistrationInProgress</code> - The target is in the process of being registered with the load
     *         balancer.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Elb.InitialHealthChecking</code> - The load balancer is still sending the target the minimum number
     *         of health checks required to determine its health status.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If the target state is <code>unhealthy</code>, the reason code can be one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Target.ResponseCodeMismatch</code> - The health checks did not return an expected HTTP code.
     *         Applies only to Application Load Balancers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Target.Timeout</code> - The health check requests timed out. Applies only to Application Load
     *         Balancers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Target.FailedHealthChecks</code> - The load balancer received an error while establishing a
     *         connection to the target or the target response was malformed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Elb.InternalError</code> - The health checks failed due to an internal error. Applies only to
     *         Application Load Balancers.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If the target state is <code>unused</code>, the reason code can be one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Target.NotRegistered</code> - The target is not registered with the target group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Target.NotInUse</code> - The target group is not used by any load balancer or the target is in an
     *         Availability Zone that is not enabled for its load balancer.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Target.InvalidState</code> - The target is in the stopped or terminated state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Target.IpUnusable</code> - The target IP address is reserved for use by a load balancer.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If the target state is <code>draining</code>, the reason code can be the following value:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Target.DeregistrationInProgress</code> - The target is in the process of being deregistered and the
     *         deregistration delay period has not expired.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If the target state is <code>unavailable</code>, the reason code can be the following value:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Target.HealthCheckDisabled</code> - Health checks are disabled for the target group. Applies only
     *         to Application Load Balancers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Elb.InternalError</code> - Target health is unavailable due to an internal error. Applies only to
     *         Network Load Balancers.
     *         </p>
     *         </li>
     * @see TargetHealthReasonEnum
     */
    public TargetHealthReasonEnum reason() {
        return TargetHealthReasonEnum.fromValue(reason);
    }

    /**
     * <p>
     * The reason code.
     * </p>
     * <p>
     * If the target state is <code>healthy</code>, a reason code is not provided.
     * </p>
     * <p>
     * If the target state is <code>initial</code>, the reason code can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Elb.RegistrationInProgress</code> - The target is in the process of being registered with the load
     * balancer.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Elb.InitialHealthChecking</code> - The load balancer is still sending the target the minimum number of
     * health checks required to determine its health status.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the target state is <code>unhealthy</code>, the reason code can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Target.ResponseCodeMismatch</code> - The health checks did not return an expected HTTP code. Applies only
     * to Application Load Balancers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Target.Timeout</code> - The health check requests timed out. Applies only to Application Load Balancers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Target.FailedHealthChecks</code> - The load balancer received an error while establishing a connection to
     * the target or the target response was malformed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Elb.InternalError</code> - The health checks failed due to an internal error. Applies only to Application
     * Load Balancers.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the target state is <code>unused</code>, the reason code can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Target.NotRegistered</code> - The target is not registered with the target group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Target.NotInUse</code> - The target group is not used by any load balancer or the target is in an
     * Availability Zone that is not enabled for its load balancer.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Target.InvalidState</code> - The target is in the stopped or terminated state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Target.IpUnusable</code> - The target IP address is reserved for use by a load balancer.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the target state is <code>draining</code>, the reason code can be the following value:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Target.DeregistrationInProgress</code> - The target is in the process of being deregistered and the
     * deregistration delay period has not expired.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the target state is <code>unavailable</code>, the reason code can be the following value:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Target.HealthCheckDisabled</code> - Health checks are disabled for the target group. Applies only to
     * Application Load Balancers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Elb.InternalError</code> - Target health is unavailable due to an internal error. Applies only to Network
     * Load Balancers.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link TargetHealthReasonEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #reasonAsString}.
     * </p>
     * 
     * @return The reason code.</p>
     *         <p>
     *         If the target state is <code>healthy</code>, a reason code is not provided.
     *         </p>
     *         <p>
     *         If the target state is <code>initial</code>, the reason code can be one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Elb.RegistrationInProgress</code> - The target is in the process of being registered with the load
     *         balancer.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Elb.InitialHealthChecking</code> - The load balancer is still sending the target the minimum number
     *         of health checks required to determine its health status.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If the target state is <code>unhealthy</code>, the reason code can be one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Target.ResponseCodeMismatch</code> - The health checks did not return an expected HTTP code.
     *         Applies only to Application Load Balancers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Target.Timeout</code> - The health check requests timed out. Applies only to Application Load
     *         Balancers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Target.FailedHealthChecks</code> - The load balancer received an error while establishing a
     *         connection to the target or the target response was malformed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Elb.InternalError</code> - The health checks failed due to an internal error. Applies only to
     *         Application Load Balancers.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If the target state is <code>unused</code>, the reason code can be one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Target.NotRegistered</code> - The target is not registered with the target group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Target.NotInUse</code> - The target group is not used by any load balancer or the target is in an
     *         Availability Zone that is not enabled for its load balancer.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Target.InvalidState</code> - The target is in the stopped or terminated state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Target.IpUnusable</code> - The target IP address is reserved for use by a load balancer.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If the target state is <code>draining</code>, the reason code can be the following value:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Target.DeregistrationInProgress</code> - The target is in the process of being deregistered and the
     *         deregistration delay period has not expired.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If the target state is <code>unavailable</code>, the reason code can be the following value:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Target.HealthCheckDisabled</code> - Health checks are disabled for the target group. Applies only
     *         to Application Load Balancers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Elb.InternalError</code> - Target health is unavailable due to an internal error. Applies only to
     *         Network Load Balancers.
     *         </p>
     *         </li>
     * @see TargetHealthReasonEnum
     */
    public String reasonAsString() {
        return reason;
    }

    /**
     * <p>
     * A description of the target health that provides additional details. If the state is <code>healthy</code>, a
     * description is not provided.
     * </p>
     * 
     * @return A description of the target health that provides additional details. If the state is <code>healthy</code>
     *         , a description is not provided.
     */
    public String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(reasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetHealth)) {
            return false;
        }
        TargetHealth other = (TargetHealth) obj;
        return Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(reasonAsString(), other.reasonAsString())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TargetHealth").add("State", stateAsString()).add("Reason", reasonAsString())
                .add("Description", description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Reason":
            return Optional.ofNullable(clazz.cast(reasonAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetHealth, T> g) {
        return obj -> g.apply((TargetHealth) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetHealth> {
        /**
         * <p>
         * The state of the target.
         * </p>
         * 
         * @param state
         *        The state of the target.
         * @see TargetHealthStateEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetHealthStateEnum
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the target.
         * </p>
         * 
         * @param state
         *        The state of the target.
         * @see TargetHealthStateEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetHealthStateEnum
         */
        Builder state(TargetHealthStateEnum state);

        /**
         * <p>
         * The reason code.
         * </p>
         * <p>
         * If the target state is <code>healthy</code>, a reason code is not provided.
         * </p>
         * <p>
         * If the target state is <code>initial</code>, the reason code can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Elb.RegistrationInProgress</code> - The target is in the process of being registered with the load
         * balancer.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Elb.InitialHealthChecking</code> - The load balancer is still sending the target the minimum number of
         * health checks required to determine its health status.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If the target state is <code>unhealthy</code>, the reason code can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Target.ResponseCodeMismatch</code> - The health checks did not return an expected HTTP code. Applies
         * only to Application Load Balancers.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Target.Timeout</code> - The health check requests timed out. Applies only to Application Load
         * Balancers.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Target.FailedHealthChecks</code> - The load balancer received an error while establishing a connection
         * to the target or the target response was malformed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Elb.InternalError</code> - The health checks failed due to an internal error. Applies only to
         * Application Load Balancers.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If the target state is <code>unused</code>, the reason code can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Target.NotRegistered</code> - The target is not registered with the target group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Target.NotInUse</code> - The target group is not used by any load balancer or the target is in an
         * Availability Zone that is not enabled for its load balancer.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Target.InvalidState</code> - The target is in the stopped or terminated state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Target.IpUnusable</code> - The target IP address is reserved for use by a load balancer.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If the target state is <code>draining</code>, the reason code can be the following value:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Target.DeregistrationInProgress</code> - The target is in the process of being deregistered and the
         * deregistration delay period has not expired.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If the target state is <code>unavailable</code>, the reason code can be the following value:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Target.HealthCheckDisabled</code> - Health checks are disabled for the target group. Applies only to
         * Application Load Balancers.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Elb.InternalError</code> - Target health is unavailable due to an internal error. Applies only to
         * Network Load Balancers.
         * </p>
         * </li>
         * </ul>
         * 
         * @param reason
         *        The reason code.</p>
         *        <p>
         *        If the target state is <code>healthy</code>, a reason code is not provided.
         *        </p>
         *        <p>
         *        If the target state is <code>initial</code>, the reason code can be one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Elb.RegistrationInProgress</code> - The target is in the process of being registered with the
         *        load balancer.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Elb.InitialHealthChecking</code> - The load balancer is still sending the target the minimum
         *        number of health checks required to determine its health status.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If the target state is <code>unhealthy</code>, the reason code can be one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Target.ResponseCodeMismatch</code> - The health checks did not return an expected HTTP code.
         *        Applies only to Application Load Balancers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Target.Timeout</code> - The health check requests timed out. Applies only to Application Load
         *        Balancers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Target.FailedHealthChecks</code> - The load balancer received an error while establishing a
         *        connection to the target or the target response was malformed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Elb.InternalError</code> - The health checks failed due to an internal error. Applies only to
         *        Application Load Balancers.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If the target state is <code>unused</code>, the reason code can be one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Target.NotRegistered</code> - The target is not registered with the target group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Target.NotInUse</code> - The target group is not used by any load balancer or the target is in
         *        an Availability Zone that is not enabled for its load balancer.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Target.InvalidState</code> - The target is in the stopped or terminated state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Target.IpUnusable</code> - The target IP address is reserved for use by a load balancer.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If the target state is <code>draining</code>, the reason code can be the following value:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Target.DeregistrationInProgress</code> - The target is in the process of being deregistered and
         *        the deregistration delay period has not expired.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If the target state is <code>unavailable</code>, the reason code can be the following value:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Target.HealthCheckDisabled</code> - Health checks are disabled for the target group. Applies
         *        only to Application Load Balancers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Elb.InternalError</code> - Target health is unavailable due to an internal error. Applies only
         *        to Network Load Balancers.
         *        </p>
         *        </li>
         * @see TargetHealthReasonEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetHealthReasonEnum
         */
        Builder reason(String reason);

        /**
         * <p>
         * The reason code.
         * </p>
         * <p>
         * If the target state is <code>healthy</code>, a reason code is not provided.
         * </p>
         * <p>
         * If the target state is <code>initial</code>, the reason code can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Elb.RegistrationInProgress</code> - The target is in the process of being registered with the load
         * balancer.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Elb.InitialHealthChecking</code> - The load balancer is still sending the target the minimum number of
         * health checks required to determine its health status.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If the target state is <code>unhealthy</code>, the reason code can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Target.ResponseCodeMismatch</code> - The health checks did not return an expected HTTP code. Applies
         * only to Application Load Balancers.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Target.Timeout</code> - The health check requests timed out. Applies only to Application Load
         * Balancers.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Target.FailedHealthChecks</code> - The load balancer received an error while establishing a connection
         * to the target or the target response was malformed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Elb.InternalError</code> - The health checks failed due to an internal error. Applies only to
         * Application Load Balancers.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If the target state is <code>unused</code>, the reason code can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Target.NotRegistered</code> - The target is not registered with the target group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Target.NotInUse</code> - The target group is not used by any load balancer or the target is in an
         * Availability Zone that is not enabled for its load balancer.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Target.InvalidState</code> - The target is in the stopped or terminated state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Target.IpUnusable</code> - The target IP address is reserved for use by a load balancer.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If the target state is <code>draining</code>, the reason code can be the following value:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Target.DeregistrationInProgress</code> - The target is in the process of being deregistered and the
         * deregistration delay period has not expired.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If the target state is <code>unavailable</code>, the reason code can be the following value:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Target.HealthCheckDisabled</code> - Health checks are disabled for the target group. Applies only to
         * Application Load Balancers.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Elb.InternalError</code> - Target health is unavailable due to an internal error. Applies only to
         * Network Load Balancers.
         * </p>
         * </li>
         * </ul>
         * 
         * @param reason
         *        The reason code.</p>
         *        <p>
         *        If the target state is <code>healthy</code>, a reason code is not provided.
         *        </p>
         *        <p>
         *        If the target state is <code>initial</code>, the reason code can be one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Elb.RegistrationInProgress</code> - The target is in the process of being registered with the
         *        load balancer.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Elb.InitialHealthChecking</code> - The load balancer is still sending the target the minimum
         *        number of health checks required to determine its health status.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If the target state is <code>unhealthy</code>, the reason code can be one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Target.ResponseCodeMismatch</code> - The health checks did not return an expected HTTP code.
         *        Applies only to Application Load Balancers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Target.Timeout</code> - The health check requests timed out. Applies only to Application Load
         *        Balancers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Target.FailedHealthChecks</code> - The load balancer received an error while establishing a
         *        connection to the target or the target response was malformed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Elb.InternalError</code> - The health checks failed due to an internal error. Applies only to
         *        Application Load Balancers.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If the target state is <code>unused</code>, the reason code can be one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Target.NotRegistered</code> - The target is not registered with the target group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Target.NotInUse</code> - The target group is not used by any load balancer or the target is in
         *        an Availability Zone that is not enabled for its load balancer.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Target.InvalidState</code> - The target is in the stopped or terminated state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Target.IpUnusable</code> - The target IP address is reserved for use by a load balancer.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If the target state is <code>draining</code>, the reason code can be the following value:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Target.DeregistrationInProgress</code> - The target is in the process of being deregistered and
         *        the deregistration delay period has not expired.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If the target state is <code>unavailable</code>, the reason code can be the following value:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Target.HealthCheckDisabled</code> - Health checks are disabled for the target group. Applies
         *        only to Application Load Balancers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Elb.InternalError</code> - Target health is unavailable due to an internal error. Applies only
         *        to Network Load Balancers.
         *        </p>
         *        </li>
         * @see TargetHealthReasonEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetHealthReasonEnum
         */
        Builder reason(TargetHealthReasonEnum reason);

        /**
         * <p>
         * A description of the target health that provides additional details. If the state is <code>healthy</code>, a
         * description is not provided.
         * </p>
         * 
         * @param description
         *        A description of the target health that provides additional details. If the state is
         *        <code>healthy</code>, a description is not provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String state;

        private String reason;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetHealth model) {
            state(model.state);
            reason(model.reason);
            description(model.description);
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(TargetHealthStateEnum state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getReason() {
            return reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(TargetHealthReasonEnum reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public TargetHealth build() {
            return new TargetHealth(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
