/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum EventScopeCode {
    PUBLIC("PUBLIC"),
    ACCOUNT_SPECIFIC("ACCOUNT_SPECIFIC"),
    NONE("NONE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private EventScopeCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EventScopeCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(EventScopeCode.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EventScopeCode> knownValues() {
        return Stream.of(EventScopeCode.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

