/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector.model.AgentHealth;
import software.amazon.awssdk.services.inspector.model.AgentHealthCode;
import software.amazon.awssdk.services.inspector.model.TelemetryMetadata;
import software.amazon.awssdk.services.inspector.model.TelemetryMetadataListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssessmentRunAgent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssessmentRunAgent> {
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentId").getter(AssessmentRunAgent.getter(AssessmentRunAgent::agentId)).setter(AssessmentRunAgent.setter(Builder::agentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentId").build()}).build();
    private static final SdkField<String> ASSESSMENT_RUN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assessmentRunArn").getter(AssessmentRunAgent.getter(AssessmentRunAgent::assessmentRunArn)).setter(AssessmentRunAgent.setter(Builder::assessmentRunArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentRunArn").build()}).build();
    private static final SdkField<String> AGENT_HEALTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentHealth").getter(AssessmentRunAgent.getter(AssessmentRunAgent::agentHealthAsString)).setter(AssessmentRunAgent.setter(Builder::agentHealth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentHealth").build()}).build();
    private static final SdkField<String> AGENT_HEALTH_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentHealthCode").getter(AssessmentRunAgent.getter(AssessmentRunAgent::agentHealthCodeAsString)).setter(AssessmentRunAgent.setter(Builder::agentHealthCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentHealthCode").build()}).build();
    private static final SdkField<String> AGENT_HEALTH_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentHealthDetails").getter(AssessmentRunAgent.getter(AssessmentRunAgent::agentHealthDetails)).setter(AssessmentRunAgent.setter(Builder::agentHealthDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentHealthDetails").build()}).build();
    private static final SdkField<String> AUTO_SCALING_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("autoScalingGroup").getter(AssessmentRunAgent.getter(AssessmentRunAgent::autoScalingGroup)).setter(AssessmentRunAgent.setter(Builder::autoScalingGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingGroup").build()}).build();
    private static final SdkField<List<TelemetryMetadata>> TELEMETRY_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("telemetryMetadata").getter(AssessmentRunAgent.getter(AssessmentRunAgent::telemetryMetadata)).setter(AssessmentRunAgent.setter(Builder::telemetryMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("telemetryMetadata").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TelemetryMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ID_FIELD, ASSESSMENT_RUN_ARN_FIELD, AGENT_HEALTH_FIELD, AGENT_HEALTH_CODE_FIELD, AGENT_HEALTH_DETAILS_FIELD, AUTO_SCALING_GROUP_FIELD, TELEMETRY_METADATA_FIELD));
    private static final long serialVersionUID = 1L;
    private final String agentId;
    private final String assessmentRunArn;
    private final String agentHealth;
    private final String agentHealthCode;
    private final String agentHealthDetails;
    private final String autoScalingGroup;
    private final List<TelemetryMetadata> telemetryMetadata;

    private AssessmentRunAgent(BuilderImpl builder) {
        this.agentId = builder.agentId;
        this.assessmentRunArn = builder.assessmentRunArn;
        this.agentHealth = builder.agentHealth;
        this.agentHealthCode = builder.agentHealthCode;
        this.agentHealthDetails = builder.agentHealthDetails;
        this.autoScalingGroup = builder.autoScalingGroup;
        this.telemetryMetadata = builder.telemetryMetadata;
    }

    public String agentId() {
        return this.agentId;
    }

    public String assessmentRunArn() {
        return this.assessmentRunArn;
    }

    public AgentHealth agentHealth() {
        return AgentHealth.fromValue(this.agentHealth);
    }

    public String agentHealthAsString() {
        return this.agentHealth;
    }

    public AgentHealthCode agentHealthCode() {
        return AgentHealthCode.fromValue(this.agentHealthCode);
    }

    public String agentHealthCodeAsString() {
        return this.agentHealthCode;
    }

    public String agentHealthDetails() {
        return this.agentHealthDetails;
    }

    public String autoScalingGroup() {
        return this.autoScalingGroup;
    }

    public boolean hasTelemetryMetadata() {
        return this.telemetryMetadata != null && !(this.telemetryMetadata instanceof SdkAutoConstructList);
    }

    public List<TelemetryMetadata> telemetryMetadata() {
        return this.telemetryMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.agentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentRunArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentHealthAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentHealthCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentHealthDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.telemetryMetadata());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssessmentRunAgent)) {
            return false;
        }
        AssessmentRunAgent other = (AssessmentRunAgent)obj;
        return Objects.equals(this.agentId(), other.agentId()) && Objects.equals(this.assessmentRunArn(), other.assessmentRunArn()) && Objects.equals(this.agentHealthAsString(), other.agentHealthAsString()) && Objects.equals(this.agentHealthCodeAsString(), other.agentHealthCodeAsString()) && Objects.equals(this.agentHealthDetails(), other.agentHealthDetails()) && Objects.equals(this.autoScalingGroup(), other.autoScalingGroup()) && Objects.equals(this.telemetryMetadata(), other.telemetryMetadata());
    }

    public String toString() {
        return ToString.builder((String)"AssessmentRunAgent").add("AgentId", (Object)this.agentId()).add("AssessmentRunArn", (Object)this.assessmentRunArn()).add("AgentHealth", (Object)this.agentHealthAsString()).add("AgentHealthCode", (Object)this.agentHealthCodeAsString()).add("AgentHealthDetails", (Object)this.agentHealthDetails()).add("AutoScalingGroup", (Object)this.autoScalingGroup()).add("TelemetryMetadata", this.telemetryMetadata()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agentId": {
                return Optional.ofNullable(clazz.cast(this.agentId()));
            }
            case "assessmentRunArn": {
                return Optional.ofNullable(clazz.cast(this.assessmentRunArn()));
            }
            case "agentHealth": {
                return Optional.ofNullable(clazz.cast(this.agentHealthAsString()));
            }
            case "agentHealthCode": {
                return Optional.ofNullable(clazz.cast(this.agentHealthCodeAsString()));
            }
            case "agentHealthDetails": {
                return Optional.ofNullable(clazz.cast(this.agentHealthDetails()));
            }
            case "autoScalingGroup": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroup()));
            }
            case "telemetryMetadata": {
                return Optional.ofNullable(clazz.cast(this.telemetryMetadata()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssessmentRunAgent, T> g) {
        return obj -> g.apply((AssessmentRunAgent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String agentId;
        private String assessmentRunArn;
        private String agentHealth;
        private String agentHealthCode;
        private String agentHealthDetails;
        private String autoScalingGroup;
        private List<TelemetryMetadata> telemetryMetadata = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssessmentRunAgent model) {
            this.agentId(model.agentId);
            this.assessmentRunArn(model.assessmentRunArn);
            this.agentHealth(model.agentHealth);
            this.agentHealthCode(model.agentHealthCode);
            this.agentHealthDetails(model.agentHealthDetails);
            this.autoScalingGroup(model.autoScalingGroup);
            this.telemetryMetadata(model.telemetryMetadata);
        }

        public final String getAgentId() {
            return this.agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        public final String getAssessmentRunArn() {
            return this.assessmentRunArn;
        }

        @Override
        public final Builder assessmentRunArn(String assessmentRunArn) {
            this.assessmentRunArn = assessmentRunArn;
            return this;
        }

        public final void setAssessmentRunArn(String assessmentRunArn) {
            this.assessmentRunArn = assessmentRunArn;
        }

        public final String getAgentHealth() {
            return this.agentHealth;
        }

        @Override
        public final Builder agentHealth(String agentHealth) {
            this.agentHealth = agentHealth;
            return this;
        }

        @Override
        public final Builder agentHealth(AgentHealth agentHealth) {
            this.agentHealth(agentHealth == null ? null : agentHealth.toString());
            return this;
        }

        public final void setAgentHealth(String agentHealth) {
            this.agentHealth = agentHealth;
        }

        public final String getAgentHealthCode() {
            return this.agentHealthCode;
        }

        @Override
        public final Builder agentHealthCode(String agentHealthCode) {
            this.agentHealthCode = agentHealthCode;
            return this;
        }

        @Override
        public final Builder agentHealthCode(AgentHealthCode agentHealthCode) {
            this.agentHealthCode(agentHealthCode == null ? null : agentHealthCode.toString());
            return this;
        }

        public final void setAgentHealthCode(String agentHealthCode) {
            this.agentHealthCode = agentHealthCode;
        }

        public final String getAgentHealthDetails() {
            return this.agentHealthDetails;
        }

        @Override
        public final Builder agentHealthDetails(String agentHealthDetails) {
            this.agentHealthDetails = agentHealthDetails;
            return this;
        }

        public final void setAgentHealthDetails(String agentHealthDetails) {
            this.agentHealthDetails = agentHealthDetails;
        }

        public final String getAutoScalingGroup() {
            return this.autoScalingGroup;
        }

        @Override
        public final Builder autoScalingGroup(String autoScalingGroup) {
            this.autoScalingGroup = autoScalingGroup;
            return this;
        }

        public final void setAutoScalingGroup(String autoScalingGroup) {
            this.autoScalingGroup = autoScalingGroup;
        }

        public final Collection<TelemetryMetadata.Builder> getTelemetryMetadata() {
            return this.telemetryMetadata != null ? (Collection)this.telemetryMetadata.stream().map(TelemetryMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder telemetryMetadata(Collection<TelemetryMetadata> telemetryMetadata) {
            this.telemetryMetadata = TelemetryMetadataListCopier.copy(telemetryMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder telemetryMetadata(TelemetryMetadata ... telemetryMetadata) {
            this.telemetryMetadata(Arrays.asList(telemetryMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder telemetryMetadata(Consumer<TelemetryMetadata.Builder> ... telemetryMetadata) {
            this.telemetryMetadata(Stream.of(telemetryMetadata).map(c -> (TelemetryMetadata)((TelemetryMetadata.Builder)TelemetryMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTelemetryMetadata(Collection<TelemetryMetadata.BuilderImpl> telemetryMetadata) {
            this.telemetryMetadata = TelemetryMetadataListCopier.copyFromBuilder(telemetryMetadata);
        }

        public AssessmentRunAgent build() {
            return new AssessmentRunAgent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssessmentRunAgent> {
        public Builder agentId(String var1);

        public Builder assessmentRunArn(String var1);

        public Builder agentHealth(String var1);

        public Builder agentHealth(AgentHealth var1);

        public Builder agentHealthCode(String var1);

        public Builder agentHealthCode(AgentHealthCode var1);

        public Builder agentHealthDetails(String var1);

        public Builder autoScalingGroup(String var1);

        public Builder telemetryMetadata(Collection<TelemetryMetadata> var1);

        public Builder telemetryMetadata(TelemetryMetadata ... var1);

        public Builder telemetryMetadata(Consumer<TelemetryMetadata.Builder> ... var1);
    }
}

