/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector.model.AssessmentRunInProgressArnListCopier;
import software.amazon.awssdk.services.inspector.model.InspectorException;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssessmentRunInProgressException
extends InspectorException
implements ToCopyableBuilder<Builder, AssessmentRunInProgressException> {
    private static final SdkField<List<String>> ASSESSMENT_RUN_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assessmentRunArns").getter(AssessmentRunInProgressException.getter(AssessmentRunInProgressException::assessmentRunArns)).setter(AssessmentRunInProgressException.setter(Builder::assessmentRunArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentRunArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ASSESSMENT_RUN_ARNS_TRUNCATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("assessmentRunArnsTruncated").getter(AssessmentRunInProgressException.getter(AssessmentRunInProgressException::assessmentRunArnsTruncated)).setter(AssessmentRunInProgressException.setter(Builder::assessmentRunArnsTruncated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentRunArnsTruncated").build()}).build();
    private static final SdkField<Boolean> CAN_RETRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("canRetry").getter(AssessmentRunInProgressException.getter(AssessmentRunInProgressException::canRetry)).setter(AssessmentRunInProgressException.setter(Builder::canRetry)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canRetry").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_RUN_ARNS_FIELD, ASSESSMENT_RUN_ARNS_TRUNCATED_FIELD, CAN_RETRY_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> assessmentRunArns;
    private final Boolean assessmentRunArnsTruncated;
    private final Boolean canRetry;

    private AssessmentRunInProgressException(BuilderImpl builder) {
        super(builder);
        this.assessmentRunArns = builder.assessmentRunArns;
        this.assessmentRunArnsTruncated = builder.assessmentRunArnsTruncated;
        this.canRetry = builder.canRetry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public boolean hasAssessmentRunArns() {
        return this.assessmentRunArns != null && !(this.assessmentRunArns instanceof SdkAutoConstructList);
    }

    public List<String> assessmentRunArns() {
        return this.assessmentRunArns;
    }

    public Boolean assessmentRunArnsTruncated() {
        return this.assessmentRunArnsTruncated;
    }

    public Boolean canRetry() {
        return this.canRetry;
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssessmentRunInProgressException, T> g) {
        return obj -> g.apply((AssessmentRunInProgressException)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InspectorException.BuilderImpl
    implements Builder {
        private List<String> assessmentRunArns = DefaultSdkAutoConstructList.getInstance();
        private Boolean assessmentRunArnsTruncated;
        private Boolean canRetry;

        private BuilderImpl() {
        }

        private BuilderImpl(AssessmentRunInProgressException model) {
            super(model);
            this.assessmentRunArns(model.assessmentRunArns);
            this.assessmentRunArnsTruncated(model.assessmentRunArnsTruncated);
            this.canRetry(model.canRetry);
        }

        public final Collection<String> getAssessmentRunArns() {
            return this.assessmentRunArns;
        }

        @Override
        public final Builder assessmentRunArns(Collection<String> assessmentRunArns) {
            this.assessmentRunArns = AssessmentRunInProgressArnListCopier.copy(assessmentRunArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentRunArns(String ... assessmentRunArns) {
            this.assessmentRunArns(Arrays.asList(assessmentRunArns));
            return this;
        }

        public final void setAssessmentRunArns(Collection<String> assessmentRunArns) {
            this.assessmentRunArns = AssessmentRunInProgressArnListCopier.copy(assessmentRunArns);
        }

        public final Boolean getAssessmentRunArnsTruncated() {
            return this.assessmentRunArnsTruncated;
        }

        @Override
        public final Builder assessmentRunArnsTruncated(Boolean assessmentRunArnsTruncated) {
            this.assessmentRunArnsTruncated = assessmentRunArnsTruncated;
            return this;
        }

        public final void setAssessmentRunArnsTruncated(Boolean assessmentRunArnsTruncated) {
            this.assessmentRunArnsTruncated = assessmentRunArnsTruncated;
        }

        public final Boolean getCanRetry() {
            return this.canRetry;
        }

        @Override
        public final Builder canRetry(Boolean canRetry) {
            this.canRetry = canRetry;
            return this;
        }

        public final void setCanRetry(Boolean canRetry) {
            this.canRetry = canRetry;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public AssessmentRunInProgressException build() {
            return new AssessmentRunInProgressException(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssessmentRunInProgressException>,
    InspectorException.Builder {
        public Builder assessmentRunArns(Collection<String> var1);

        public Builder assessmentRunArns(String ... var1);

        public Builder assessmentRunArnsTruncated(Boolean var1);

        public Builder canRetry(Boolean var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);
    }
}

