/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector.model.AssessmentTemplateRulesPackageArnListCopier;
import software.amazon.awssdk.services.inspector.model.Attribute;
import software.amazon.awssdk.services.inspector.model.InspectorRequest;
import software.amazon.awssdk.services.inspector.model.UserAttributeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAssessmentTemplateRequest
extends InspectorRequest
implements ToCopyableBuilder<Builder, CreateAssessmentTemplateRequest> {
    private static final SdkField<String> ASSESSMENT_TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assessmentTargetArn").getter(CreateAssessmentTemplateRequest.getter(CreateAssessmentTemplateRequest::assessmentTargetArn)).setter(CreateAssessmentTemplateRequest.setter(Builder::assessmentTargetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentTargetArn").build()}).build();
    private static final SdkField<String> ASSESSMENT_TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assessmentTemplateName").getter(CreateAssessmentTemplateRequest.getter(CreateAssessmentTemplateRequest::assessmentTemplateName)).setter(CreateAssessmentTemplateRequest.setter(Builder::assessmentTemplateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentTemplateName").build()}).build();
    private static final SdkField<Integer> DURATION_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("durationInSeconds").getter(CreateAssessmentTemplateRequest.getter(CreateAssessmentTemplateRequest::durationInSeconds)).setter(CreateAssessmentTemplateRequest.setter(Builder::durationInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durationInSeconds").build()}).build();
    private static final SdkField<List<String>> RULES_PACKAGE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("rulesPackageArns").getter(CreateAssessmentTemplateRequest.getter(CreateAssessmentTemplateRequest::rulesPackageArns)).setter(CreateAssessmentTemplateRequest.setter(Builder::rulesPackageArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rulesPackageArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Attribute>> USER_ATTRIBUTES_FOR_FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("userAttributesForFindings").getter(CreateAssessmentTemplateRequest.getter(CreateAssessmentTemplateRequest::userAttributesForFindings)).setter(CreateAssessmentTemplateRequest.setter(Builder::userAttributesForFindings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAttributesForFindings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Attribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_TARGET_ARN_FIELD, ASSESSMENT_TEMPLATE_NAME_FIELD, DURATION_IN_SECONDS_FIELD, RULES_PACKAGE_ARNS_FIELD, USER_ATTRIBUTES_FOR_FINDINGS_FIELD));
    private final String assessmentTargetArn;
    private final String assessmentTemplateName;
    private final Integer durationInSeconds;
    private final List<String> rulesPackageArns;
    private final List<Attribute> userAttributesForFindings;

    private CreateAssessmentTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.assessmentTargetArn = builder.assessmentTargetArn;
        this.assessmentTemplateName = builder.assessmentTemplateName;
        this.durationInSeconds = builder.durationInSeconds;
        this.rulesPackageArns = builder.rulesPackageArns;
        this.userAttributesForFindings = builder.userAttributesForFindings;
    }

    public String assessmentTargetArn() {
        return this.assessmentTargetArn;
    }

    public String assessmentTemplateName() {
        return this.assessmentTemplateName;
    }

    public Integer durationInSeconds() {
        return this.durationInSeconds;
    }

    public boolean hasRulesPackageArns() {
        return this.rulesPackageArns != null && !(this.rulesPackageArns instanceof SdkAutoConstructList);
    }

    public List<String> rulesPackageArns() {
        return this.rulesPackageArns;
    }

    public boolean hasUserAttributesForFindings() {
        return this.userAttributesForFindings != null && !(this.userAttributesForFindings instanceof SdkAutoConstructList);
    }

    public List<Attribute> userAttributesForFindings() {
        return this.userAttributesForFindings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentTargetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.rulesPackageArns());
        hashCode = 31 * hashCode + Objects.hashCode(this.userAttributesForFindings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssessmentTemplateRequest)) {
            return false;
        }
        CreateAssessmentTemplateRequest other = (CreateAssessmentTemplateRequest)((Object)obj);
        return Objects.equals(this.assessmentTargetArn(), other.assessmentTargetArn()) && Objects.equals(this.assessmentTemplateName(), other.assessmentTemplateName()) && Objects.equals(this.durationInSeconds(), other.durationInSeconds()) && Objects.equals(this.rulesPackageArns(), other.rulesPackageArns()) && Objects.equals(this.userAttributesForFindings(), other.userAttributesForFindings());
    }

    public String toString() {
        return ToString.builder((String)"CreateAssessmentTemplateRequest").add("AssessmentTargetArn", (Object)this.assessmentTargetArn()).add("AssessmentTemplateName", (Object)this.assessmentTemplateName()).add("DurationInSeconds", (Object)this.durationInSeconds()).add("RulesPackageArns", this.rulesPackageArns()).add("UserAttributesForFindings", this.userAttributesForFindings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assessmentTargetArn": {
                return Optional.ofNullable(clazz.cast(this.assessmentTargetArn()));
            }
            case "assessmentTemplateName": {
                return Optional.ofNullable(clazz.cast(this.assessmentTemplateName()));
            }
            case "durationInSeconds": {
                return Optional.ofNullable(clazz.cast(this.durationInSeconds()));
            }
            case "rulesPackageArns": {
                return Optional.ofNullable(clazz.cast(this.rulesPackageArns()));
            }
            case "userAttributesForFindings": {
                return Optional.ofNullable(clazz.cast(this.userAttributesForFindings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAssessmentTemplateRequest, T> g) {
        return obj -> g.apply((CreateAssessmentTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InspectorRequest.BuilderImpl
    implements Builder {
        private String assessmentTargetArn;
        private String assessmentTemplateName;
        private Integer durationInSeconds;
        private List<String> rulesPackageArns = DefaultSdkAutoConstructList.getInstance();
        private List<Attribute> userAttributesForFindings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAssessmentTemplateRequest model) {
            super(model);
            this.assessmentTargetArn(model.assessmentTargetArn);
            this.assessmentTemplateName(model.assessmentTemplateName);
            this.durationInSeconds(model.durationInSeconds);
            this.rulesPackageArns(model.rulesPackageArns);
            this.userAttributesForFindings(model.userAttributesForFindings);
        }

        public final String getAssessmentTargetArn() {
            return this.assessmentTargetArn;
        }

        @Override
        public final Builder assessmentTargetArn(String assessmentTargetArn) {
            this.assessmentTargetArn = assessmentTargetArn;
            return this;
        }

        public final void setAssessmentTargetArn(String assessmentTargetArn) {
            this.assessmentTargetArn = assessmentTargetArn;
        }

        public final String getAssessmentTemplateName() {
            return this.assessmentTemplateName;
        }

        @Override
        public final Builder assessmentTemplateName(String assessmentTemplateName) {
            this.assessmentTemplateName = assessmentTemplateName;
            return this;
        }

        public final void setAssessmentTemplateName(String assessmentTemplateName) {
            this.assessmentTemplateName = assessmentTemplateName;
        }

        public final Integer getDurationInSeconds() {
            return this.durationInSeconds;
        }

        @Override
        public final Builder durationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
            return this;
        }

        public final void setDurationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
        }

        public final Collection<String> getRulesPackageArns() {
            return this.rulesPackageArns;
        }

        @Override
        public final Builder rulesPackageArns(Collection<String> rulesPackageArns) {
            this.rulesPackageArns = AssessmentTemplateRulesPackageArnListCopier.copy(rulesPackageArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rulesPackageArns(String ... rulesPackageArns) {
            this.rulesPackageArns(Arrays.asList(rulesPackageArns));
            return this;
        }

        public final void setRulesPackageArns(Collection<String> rulesPackageArns) {
            this.rulesPackageArns = AssessmentTemplateRulesPackageArnListCopier.copy(rulesPackageArns);
        }

        public final Collection<Attribute.Builder> getUserAttributesForFindings() {
            return this.userAttributesForFindings != null ? (Collection)this.userAttributesForFindings.stream().map(Attribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder userAttributesForFindings(Collection<Attribute> userAttributesForFindings) {
            this.userAttributesForFindings = UserAttributeListCopier.copy(userAttributesForFindings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAttributesForFindings(Attribute ... userAttributesForFindings) {
            this.userAttributesForFindings(Arrays.asList(userAttributesForFindings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAttributesForFindings(Consumer<Attribute.Builder> ... userAttributesForFindings) {
            this.userAttributesForFindings(Stream.of(userAttributesForFindings).map(c -> (Attribute)((Attribute.Builder)Attribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUserAttributesForFindings(Collection<Attribute.BuilderImpl> userAttributesForFindings) {
            this.userAttributesForFindings = UserAttributeListCopier.copyFromBuilder(userAttributesForFindings);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAssessmentTemplateRequest build() {
            return new CreateAssessmentTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends InspectorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAssessmentTemplateRequest> {
        public Builder assessmentTargetArn(String var1);

        public Builder assessmentTemplateName(String var1);

        public Builder durationInSeconds(Integer var1);

        public Builder rulesPackageArns(Collection<String> var1);

        public Builder rulesPackageArns(String ... var1);

        public Builder userAttributesForFindings(Collection<Attribute> var1);

        public Builder userAttributesForFindings(Attribute ... var1);

        public Builder userAttributesForFindings(Consumer<Attribute.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

