/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector.model.BatchDescribeArnListCopier;
import software.amazon.awssdk.services.inspector.model.InspectorRequest;
import software.amazon.awssdk.services.inspector.model.Locale;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFindingsRequest
extends InspectorRequest
implements ToCopyableBuilder<Builder, DescribeFindingsRequest> {
    private static final SdkField<List<String>> FINDING_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("findingArns").getter(DescribeFindingsRequest.getter(DescribeFindingsRequest::findingArns)).setter(DescribeFindingsRequest.setter(Builder::findingArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LOCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("locale").getter(DescribeFindingsRequest.getter(DescribeFindingsRequest::localeAsString)).setter(DescribeFindingsRequest.setter(Builder::locale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locale").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDING_ARNS_FIELD, LOCALE_FIELD));
    private final List<String> findingArns;
    private final String locale;

    private DescribeFindingsRequest(BuilderImpl builder) {
        super(builder);
        this.findingArns = builder.findingArns;
        this.locale = builder.locale;
    }

    public boolean hasFindingArns() {
        return this.findingArns != null && !(this.findingArns instanceof SdkAutoConstructList);
    }

    public List<String> findingArns() {
        return this.findingArns;
    }

    public Locale locale() {
        return Locale.fromValue(this.locale);
    }

    public String localeAsString() {
        return this.locale;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.findingArns());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFindingsRequest)) {
            return false;
        }
        DescribeFindingsRequest other = (DescribeFindingsRequest)((Object)obj);
        return Objects.equals(this.findingArns(), other.findingArns()) && Objects.equals(this.localeAsString(), other.localeAsString());
    }

    public String toString() {
        return ToString.builder((String)"DescribeFindingsRequest").add("FindingArns", this.findingArns()).add("Locale", (Object)this.localeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "findingArns": {
                return Optional.ofNullable(clazz.cast(this.findingArns()));
            }
            case "locale": {
                return Optional.ofNullable(clazz.cast(this.localeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFindingsRequest, T> g) {
        return obj -> g.apply((DescribeFindingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InspectorRequest.BuilderImpl
    implements Builder {
        private List<String> findingArns = DefaultSdkAutoConstructList.getInstance();
        private String locale;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFindingsRequest model) {
            super(model);
            this.findingArns(model.findingArns);
            this.locale(model.locale);
        }

        public final Collection<String> getFindingArns() {
            return this.findingArns;
        }

        @Override
        public final Builder findingArns(Collection<String> findingArns) {
            this.findingArns = BatchDescribeArnListCopier.copy(findingArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingArns(String ... findingArns) {
            this.findingArns(Arrays.asList(findingArns));
            return this;
        }

        public final void setFindingArns(Collection<String> findingArns) {
            this.findingArns = BatchDescribeArnListCopier.copy(findingArns);
        }

        public final String getLocale() {
            return this.locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        public final Builder locale(Locale locale) {
            this.locale(locale == null ? null : locale.toString());
            return this;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeFindingsRequest build() {
            return new DescribeFindingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends InspectorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFindingsRequest> {
        public Builder findingArns(Collection<String> var1);

        public Builder findingArns(String ... var1);

        public Builder locale(String var1);

        public Builder locale(Locale var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

