/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.inspector.model.FailedItemDetails;
import software.amazon.awssdk.services.inspector.model.FailedItemsCopier;
import software.amazon.awssdk.services.inspector.model.InspectorResponse;
import software.amazon.awssdk.services.inspector.model.ResourceGroup;
import software.amazon.awssdk.services.inspector.model.ResourceGroupListCopier;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeResourceGroupsResponse
extends InspectorResponse
implements ToCopyableBuilder<Builder, DescribeResourceGroupsResponse> {
    private static final SdkField<List<ResourceGroup>> RESOURCE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceGroups").getter(DescribeResourceGroupsResponse.getter(DescribeResourceGroupsResponse::resourceGroups)).setter(DescribeResourceGroupsResponse.setter(Builder::resourceGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, FailedItemDetails>> FAILED_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("failedItems").getter(DescribeResourceGroupsResponse.getter(DescribeResourceGroupsResponse::failedItems)).setter(DescribeResourceGroupsResponse.setter(Builder::failedItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedItems").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FailedItemDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_GROUPS_FIELD, FAILED_ITEMS_FIELD));
    private final List<ResourceGroup> resourceGroups;
    private final Map<String, FailedItemDetails> failedItems;

    private DescribeResourceGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.resourceGroups = builder.resourceGroups;
        this.failedItems = builder.failedItems;
    }

    public boolean hasResourceGroups() {
        return this.resourceGroups != null && !(this.resourceGroups instanceof SdkAutoConstructList);
    }

    public List<ResourceGroup> resourceGroups() {
        return this.resourceGroups;
    }

    public boolean hasFailedItems() {
        return this.failedItems != null && !(this.failedItems instanceof SdkAutoConstructMap);
    }

    public Map<String, FailedItemDetails> failedItems() {
        return this.failedItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.failedItems());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeResourceGroupsResponse)) {
            return false;
        }
        DescribeResourceGroupsResponse other = (DescribeResourceGroupsResponse)((Object)obj);
        return Objects.equals(this.resourceGroups(), other.resourceGroups()) && Objects.equals(this.failedItems(), other.failedItems());
    }

    public String toString() {
        return ToString.builder((String)"DescribeResourceGroupsResponse").add("ResourceGroups", this.resourceGroups()).add("FailedItems", this.failedItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceGroups": {
                return Optional.ofNullable(clazz.cast(this.resourceGroups()));
            }
            case "failedItems": {
                return Optional.ofNullable(clazz.cast(this.failedItems()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeResourceGroupsResponse, T> g) {
        return obj -> g.apply((DescribeResourceGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InspectorResponse.BuilderImpl
    implements Builder {
        private List<ResourceGroup> resourceGroups = DefaultSdkAutoConstructList.getInstance();
        private Map<String, FailedItemDetails> failedItems = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeResourceGroupsResponse model) {
            super(model);
            this.resourceGroups(model.resourceGroups);
            this.failedItems(model.failedItems);
        }

        public final Collection<ResourceGroup.Builder> getResourceGroups() {
            return this.resourceGroups != null ? (Collection)this.resourceGroups.stream().map(ResourceGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceGroups(Collection<ResourceGroup> resourceGroups) {
            this.resourceGroups = ResourceGroupListCopier.copy(resourceGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceGroups(ResourceGroup ... resourceGroups) {
            this.resourceGroups(Arrays.asList(resourceGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceGroups(Consumer<ResourceGroup.Builder> ... resourceGroups) {
            this.resourceGroups(Stream.of(resourceGroups).map(c -> (ResourceGroup)((ResourceGroup.Builder)ResourceGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceGroups(Collection<ResourceGroup.BuilderImpl> resourceGroups) {
            this.resourceGroups = ResourceGroupListCopier.copyFromBuilder(resourceGroups);
        }

        public final Map<String, FailedItemDetails.Builder> getFailedItems() {
            return this.failedItems != null ? CollectionUtils.mapValues(this.failedItems, FailedItemDetails::toBuilder) : null;
        }

        @Override
        public final Builder failedItems(Map<String, FailedItemDetails> failedItems) {
            this.failedItems = FailedItemsCopier.copy(failedItems);
            return this;
        }

        public final void setFailedItems(Map<String, FailedItemDetails.BuilderImpl> failedItems) {
            this.failedItems = FailedItemsCopier.copyFromBuilder(failedItems);
        }

        @Override
        public DescribeResourceGroupsResponse build() {
            return new DescribeResourceGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends InspectorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeResourceGroupsResponse> {
        public Builder resourceGroups(Collection<ResourceGroup> var1);

        public Builder resourceGroups(ResourceGroup ... var1);

        public Builder resourceGroups(Consumer<ResourceGroup.Builder> ... var1);

        public Builder failedItems(Map<String, FailedItemDetails> var1);
    }
}

