/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.model.JobExecutionSummaryForJob;
import software.amazon.awssdk.services.iot.model.ListJobExecutionsForJobRequest;
import software.amazon.awssdk.services.iot.model.ListJobExecutionsForJobResponse;

public class ListJobExecutionsForJobIterable
implements SdkIterable<ListJobExecutionsForJobResponse> {
    private final IotClient client;
    private final ListJobExecutionsForJobRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListJobExecutionsForJobIterable(IotClient client, ListJobExecutionsForJobRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListJobExecutionsForJobResponseFetcher();
    }

    public Iterator<ListJobExecutionsForJobResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<JobExecutionSummaryForJob> executionSummaries() {
        Function<ListJobExecutionsForJobResponse, Iterator> getIterator = response -> {
            if (response != null && response.executionSummaries() != null) {
                return response.executionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListJobExecutionsForJobResponseFetcher
    implements SyncPageFetcher<ListJobExecutionsForJobResponse> {
        private ListJobExecutionsForJobResponseFetcher() {
        }

        public boolean hasNextPage(ListJobExecutionsForJobResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListJobExecutionsForJobResponse nextPage(ListJobExecutionsForJobResponse previousPage) {
            if (previousPage == null) {
                return ListJobExecutionsForJobIterable.this.client.listJobExecutionsForJob(ListJobExecutionsForJobIterable.this.firstRequest);
            }
            return ListJobExecutionsForJobIterable.this.client.listJobExecutionsForJob((ListJobExecutionsForJobRequest)((Object)ListJobExecutionsForJobIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

