/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot1clickprojects.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iot1clickprojects.model.DeviceCallbackOverrideMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeviceTemplate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeviceTemplate> {
    private static final SdkField<String> DEVICE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deviceType").getter(DeviceTemplate.getter(DeviceTemplate::deviceType)).setter(DeviceTemplate.setter(Builder::deviceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceType").build()}).build();
    private static final SdkField<Map<String, String>> CALLBACK_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("callbackOverrides").getter(DeviceTemplate.getter(DeviceTemplate::callbackOverrides)).setter(DeviceTemplate.setter(Builder::callbackOverrides)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("callbackOverrides").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_TYPE_FIELD, CALLBACK_OVERRIDES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String deviceType;
    private final Map<String, String> callbackOverrides;

    private DeviceTemplate(BuilderImpl builder) {
        this.deviceType = builder.deviceType;
        this.callbackOverrides = builder.callbackOverrides;
    }

    public String deviceType() {
        return this.deviceType;
    }

    public boolean hasCallbackOverrides() {
        return this.callbackOverrides != null && !(this.callbackOverrides instanceof SdkAutoConstructMap);
    }

    public Map<String, String> callbackOverrides() {
        return this.callbackOverrides;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.callbackOverrides());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceTemplate)) {
            return false;
        }
        DeviceTemplate other = (DeviceTemplate)obj;
        return Objects.equals(this.deviceType(), other.deviceType()) && Objects.equals(this.callbackOverrides(), other.callbackOverrides());
    }

    public String toString() {
        return ToString.builder((String)"DeviceTemplate").add("DeviceType", (Object)this.deviceType()).add("CallbackOverrides", this.callbackOverrides()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deviceType": {
                return Optional.ofNullable(clazz.cast(this.deviceType()));
            }
            case "callbackOverrides": {
                return Optional.ofNullable(clazz.cast(this.callbackOverrides()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeviceTemplate, T> g) {
        return obj -> g.apply((DeviceTemplate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deviceType;
        private Map<String, String> callbackOverrides = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceTemplate model) {
            this.deviceType(model.deviceType);
            this.callbackOverrides(model.callbackOverrides);
        }

        public final String getDeviceType() {
            return this.deviceType;
        }

        @Override
        public final Builder deviceType(String deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public final void setDeviceType(String deviceType) {
            this.deviceType = deviceType;
        }

        public final Map<String, String> getCallbackOverrides() {
            return this.callbackOverrides;
        }

        @Override
        public final Builder callbackOverrides(Map<String, String> callbackOverrides) {
            this.callbackOverrides = DeviceCallbackOverrideMapCopier.copy(callbackOverrides);
            return this;
        }

        public final void setCallbackOverrides(Map<String, String> callbackOverrides) {
            this.callbackOverrides = DeviceCallbackOverrideMapCopier.copy(callbackOverrides);
        }

        public DeviceTemplate build() {
            return new DeviceTemplate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeviceTemplate> {
        public Builder deviceType(String var1);

        public Builder callbackOverrides(Map<String, String> var1);
    }
}

