/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.aws.greengrass.model;

import com.google.gson.annotations.Expose;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.aws.greengrass.model.MessageContext;
import software.amazon.awssdk.eventstreamrpc.EventStreamRPCServiceModel;
import software.amazon.awssdk.eventstreamrpc.model.EventStreamJsonMessage;

public class BinaryMessage
implements EventStreamJsonMessage {
    public static final String APPLICATION_MODEL_TYPE = "aws.greengrass#BinaryMessage";
    public static final BinaryMessage VOID = new BinaryMessage(){

        @Override
        public boolean isVoid() {
            return true;
        }
    };
    @Expose(serialize=true, deserialize=true)
    private Optional<byte[]> message = Optional.empty();
    @Expose(serialize=true, deserialize=true)
    private Optional<MessageContext> context = Optional.empty();

    public byte[] getMessage() {
        if (this.message.isPresent()) {
            return this.message.get();
        }
        return null;
    }

    public void setMessage(byte[] message) {
        this.message = Optional.ofNullable(message);
    }

    public BinaryMessage withMessage(byte[] message) {
        this.setMessage(message);
        return this;
    }

    public MessageContext getContext() {
        if (this.context.isPresent()) {
            return this.context.get();
        }
        return null;
    }

    public void setContext(MessageContext context) {
        this.context = Optional.ofNullable(context);
    }

    public BinaryMessage withContext(MessageContext context) {
        this.setContext(context);
        return this;
    }

    @Override
    public String getApplicationModelType() {
        return APPLICATION_MODEL_TYPE;
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (!(rhs instanceof BinaryMessage)) {
            return false;
        }
        if (this == rhs) {
            return true;
        }
        BinaryMessage other = (BinaryMessage)rhs;
        boolean isEquals = true;
        isEquals = isEquals && EventStreamRPCServiceModel.blobTypeEquals(this.message, other.message);
        isEquals = isEquals && this.context.equals(other.context);
        return isEquals;
    }

    public int hashCode() {
        return Objects.hash(this.message, this.context);
    }
}

