/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.aws.greengrass.model;

import com.google.gson.annotations.Expose;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.aws.greengrass.model.CertificateType;
import software.amazon.awssdk.eventstreamrpc.model.EventStreamJsonMessage;

public class CertificateOptions
implements EventStreamJsonMessage {
    public static final String APPLICATION_MODEL_TYPE = "aws.greengrass#CertificateOptions";
    public static final CertificateOptions VOID = new CertificateOptions(){

        @Override
        public boolean isVoid() {
            return true;
        }
    };
    @Expose(serialize=true, deserialize=true)
    private Optional<String> certificateType = Optional.empty();

    public CertificateType getCertificateType() {
        if (this.certificateType.isPresent()) {
            return CertificateType.get(this.certificateType.get());
        }
        return null;
    }

    public String getCertificateTypeAsString() {
        if (this.certificateType.isPresent()) {
            return this.certificateType.get();
        }
        return null;
    }

    public void setCertificateType(String certificateType) {
        this.certificateType = Optional.ofNullable(certificateType);
    }

    public CertificateOptions withCertificateType(String certificateType) {
        this.setCertificateType(certificateType);
        return this;
    }

    public void setCertificateType(CertificateType certificateType) {
        this.certificateType = Optional.ofNullable(certificateType.getValue());
    }

    public CertificateOptions withCertificateType(CertificateType certificateType) {
        this.setCertificateType(certificateType);
        return this;
    }

    @Override
    public String getApplicationModelType() {
        return APPLICATION_MODEL_TYPE;
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (!(rhs instanceof CertificateOptions)) {
            return false;
        }
        if (this == rhs) {
            return true;
        }
        CertificateOptions other = (CertificateOptions)rhs;
        boolean isEquals = true;
        isEquals = isEquals && this.certificateType.equals(other.certificateType);
        return isEquals;
    }

    public int hashCode() {
        return Objects.hash(this.certificateType);
    }
}

