/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.aws.greengrass.model;

import com.google.gson.annotations.Expose;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import software.amazon.awssdk.eventstreamrpc.model.EventStreamJsonMessage;

public class ClientDeviceCredential
implements EventStreamJsonMessage {
    public static final String APPLICATION_MODEL_TYPE = "aws.greengrass#ClientDeviceCredential";
    private transient UnionMember setUnionMember;
    @Expose(serialize=true, deserialize=true)
    private Optional<String> clientDeviceCertificate = Optional.empty();

    public String getClientDeviceCertificate() {
        if (this.clientDeviceCertificate.isPresent() && this.setUnionMember == UnionMember.CLIENT_DEVICE_CERTIFICATE) {
            return this.clientDeviceCertificate.get();
        }
        return null;
    }

    public void setClientDeviceCertificate(String clientDeviceCertificate) {
        if (this.setUnionMember != null) {
            this.setUnionMember.nullify(this);
        }
        this.clientDeviceCertificate = Optional.of(clientDeviceCertificate);
        this.setUnionMember = UnionMember.CLIENT_DEVICE_CERTIFICATE;
    }

    public ClientDeviceCredential withClientDeviceCertificate(String clientDeviceCertificate) {
        this.setClientDeviceCertificate(clientDeviceCertificate);
        return this;
    }

    public UnionMember getSetUnionMember() {
        return this.setUnionMember;
    }

    @Override
    public String getApplicationModelType() {
        return APPLICATION_MODEL_TYPE;
    }

    public void selfDesignateSetUnionMember() {
        int setCount = 0;
        UnionMember[] members = UnionMember.values();
        for (int memberIdx = 0; memberIdx < UnionMember.values().length; ++memberIdx) {
            if (!members[memberIdx].isPresent(this)) continue;
            ++setCount;
            this.setUnionMember = members[memberIdx];
        }
        if (setCount > 1) {
            throw new IllegalArgumentException("More than one union member set for type: " + this.getApplicationModelType());
        }
    }

    @Override
    public void postFromJson() {
        this.selfDesignateSetUnionMember();
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (!(rhs instanceof ClientDeviceCredential)) {
            return false;
        }
        if (this == rhs) {
            return true;
        }
        ClientDeviceCredential other = (ClientDeviceCredential)rhs;
        boolean isEquals = true;
        isEquals = isEquals && this.clientDeviceCertificate.equals(other.clientDeviceCertificate);
        isEquals = isEquals && this.setUnionMember.equals((Object)other.setUnionMember);
        return isEquals;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientDeviceCertificate, this.setUnionMember});
    }

    public static enum UnionMember {
        CLIENT_DEVICE_CERTIFICATE("CLIENT_DEVICE_CERTIFICATE", obj -> ClientDeviceCredential.access$002(obj, Optional.empty()), obj -> ((ClientDeviceCredential)obj).clientDeviceCertificate != null && ((ClientDeviceCredential)obj).clientDeviceCertificate.isPresent());

        private String fieldName;
        private Consumer<ClientDeviceCredential> nullifier;
        private Predicate<ClientDeviceCredential> isPresent;

        private UnionMember(String fieldName, Consumer<ClientDeviceCredential> nullifier, Predicate<ClientDeviceCredential> isPresent) {
            this.fieldName = fieldName;
            this.nullifier = nullifier;
            this.isPresent = isPresent;
        }

        void nullify(ClientDeviceCredential obj) {
            this.nullifier.accept(obj);
        }

        boolean isPresent(ClientDeviceCredential obj) {
            return this.isPresent.test(obj);
        }
    }
}

