/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.aws.greengrass.model;

import com.google.gson.annotations.Expose;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.aws.greengrass.model.LifecycleState;
import software.amazon.awssdk.eventstreamrpc.model.EventStreamJsonMessage;

public class ComponentDetails
implements EventStreamJsonMessage {
    public static final String APPLICATION_MODEL_TYPE = "aws.greengrass#ComponentDetails";
    public static final ComponentDetails VOID = new ComponentDetails(){

        @Override
        public boolean isVoid() {
            return true;
        }
    };
    @Expose(serialize=true, deserialize=true)
    private Optional<String> componentName = Optional.empty();
    @Expose(serialize=true, deserialize=true)
    private Optional<String> version = Optional.empty();
    @Expose(serialize=true, deserialize=true)
    private Optional<String> state = Optional.empty();
    @Expose(serialize=true, deserialize=true)
    private Optional<Map<String, Object>> configuration = Optional.empty();

    public String getComponentName() {
        if (this.componentName.isPresent()) {
            return this.componentName.get();
        }
        return null;
    }

    public void setComponentName(String componentName) {
        this.componentName = Optional.ofNullable(componentName);
    }

    public ComponentDetails withComponentName(String componentName) {
        this.setComponentName(componentName);
        return this;
    }

    public String getVersion() {
        if (this.version.isPresent()) {
            return this.version.get();
        }
        return null;
    }

    public void setVersion(String version) {
        this.version = Optional.ofNullable(version);
    }

    public ComponentDetails withVersion(String version) {
        this.setVersion(version);
        return this;
    }

    public LifecycleState getState() {
        if (this.state.isPresent()) {
            return LifecycleState.get(this.state.get());
        }
        return null;
    }

    public String getStateAsString() {
        if (this.state.isPresent()) {
            return this.state.get();
        }
        return null;
    }

    public void setState(String state) {
        this.state = Optional.ofNullable(state);
    }

    public ComponentDetails withState(String state) {
        this.setState(state);
        return this;
    }

    public void setState(LifecycleState state) {
        this.state = Optional.ofNullable(state.getValue());
    }

    public ComponentDetails withState(LifecycleState state) {
        this.setState(state);
        return this;
    }

    public Map<String, Object> getConfiguration() {
        if (this.configuration.isPresent()) {
            return this.configuration.get();
        }
        return null;
    }

    public void setConfiguration(Map<String, Object> configuration) {
        this.configuration = Optional.ofNullable(configuration);
    }

    public ComponentDetails withConfiguration(Map<String, Object> configuration) {
        this.setConfiguration(configuration);
        return this;
    }

    @Override
    public String getApplicationModelType() {
        return APPLICATION_MODEL_TYPE;
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (!(rhs instanceof ComponentDetails)) {
            return false;
        }
        if (this == rhs) {
            return true;
        }
        ComponentDetails other = (ComponentDetails)rhs;
        boolean isEquals = true;
        isEquals = isEquals && this.componentName.equals(other.componentName);
        isEquals = isEquals && this.version.equals(other.version);
        isEquals = isEquals && this.state.equals(other.state);
        isEquals = isEquals && this.configuration.equals(other.configuration);
        return isEquals;
    }

    public int hashCode() {
        return Objects.hash(this.componentName, this.version, this.state, this.configuration);
    }
}

