/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.aws.greengrass.model;

import com.google.gson.annotations.Expose;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.aws.greengrass.model.ConfigurationValidityStatus;
import software.amazon.awssdk.eventstreamrpc.model.EventStreamJsonMessage;

public class ConfigurationValidityReport
implements EventStreamJsonMessage {
    public static final String APPLICATION_MODEL_TYPE = "aws.greengrass#ConfigurationValidityReport";
    public static final ConfigurationValidityReport VOID = new ConfigurationValidityReport(){

        @Override
        public boolean isVoid() {
            return true;
        }
    };
    @Expose(serialize=true, deserialize=true)
    private Optional<String> status = Optional.empty();
    @Expose(serialize=true, deserialize=true)
    private Optional<String> deploymentId = Optional.empty();
    @Expose(serialize=true, deserialize=true)
    private Optional<String> message = Optional.empty();

    public ConfigurationValidityStatus getStatus() {
        if (this.status.isPresent()) {
            return ConfigurationValidityStatus.get(this.status.get());
        }
        return null;
    }

    public String getStatusAsString() {
        if (this.status.isPresent()) {
            return this.status.get();
        }
        return null;
    }

    public void setStatus(String status) {
        this.status = Optional.ofNullable(status);
    }

    public ConfigurationValidityReport withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public void setStatus(ConfigurationValidityStatus status) {
        this.status = Optional.ofNullable(status.getValue());
    }

    public ConfigurationValidityReport withStatus(ConfigurationValidityStatus status) {
        this.setStatus(status);
        return this;
    }

    public String getDeploymentId() {
        if (this.deploymentId.isPresent()) {
            return this.deploymentId.get();
        }
        return null;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = Optional.ofNullable(deploymentId);
    }

    public ConfigurationValidityReport withDeploymentId(String deploymentId) {
        this.setDeploymentId(deploymentId);
        return this;
    }

    public String getMessage() {
        if (this.message.isPresent()) {
            return this.message.get();
        }
        return null;
    }

    public void setMessage(String message) {
        this.message = Optional.ofNullable(message);
    }

    public ConfigurationValidityReport withMessage(String message) {
        this.setMessage(message);
        return this;
    }

    @Override
    public String getApplicationModelType() {
        return APPLICATION_MODEL_TYPE;
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (!(rhs instanceof ConfigurationValidityReport)) {
            return false;
        }
        if (this == rhs) {
            return true;
        }
        ConfigurationValidityReport other = (ConfigurationValidityReport)rhs;
        boolean isEquals = true;
        isEquals = isEquals && this.status.equals(other.status);
        isEquals = isEquals && this.deploymentId.equals(other.deploymentId);
        isEquals = isEquals && this.message.equals(other.message);
        return isEquals;
    }

    public int hashCode() {
        return Objects.hash(this.status, this.deploymentId, this.message);
    }
}

