/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.aws.greengrass.model;

import com.google.gson.annotations.Expose;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import software.amazon.awssdk.aws.greengrass.model.MQTTMessage;
import software.amazon.awssdk.eventstreamrpc.model.EventStreamJsonMessage;

public class IoTCoreMessage
implements EventStreamJsonMessage {
    public static final String APPLICATION_MODEL_TYPE = "aws.greengrass#IoTCoreMessage";
    private transient UnionMember setUnionMember;
    @Expose(serialize=true, deserialize=true)
    private Optional<MQTTMessage> message = Optional.empty();

    public MQTTMessage getMessage() {
        if (this.message.isPresent() && this.setUnionMember == UnionMember.MESSAGE) {
            return this.message.get();
        }
        return null;
    }

    public void setMessage(MQTTMessage message) {
        if (this.setUnionMember != null) {
            this.setUnionMember.nullify(this);
        }
        this.message = Optional.of(message);
        this.setUnionMember = UnionMember.MESSAGE;
    }

    public IoTCoreMessage withMessage(MQTTMessage message) {
        this.setMessage(message);
        return this;
    }

    public UnionMember getSetUnionMember() {
        return this.setUnionMember;
    }

    @Override
    public String getApplicationModelType() {
        return APPLICATION_MODEL_TYPE;
    }

    public void selfDesignateSetUnionMember() {
        int setCount = 0;
        UnionMember[] members = UnionMember.values();
        for (int memberIdx = 0; memberIdx < UnionMember.values().length; ++memberIdx) {
            if (!members[memberIdx].isPresent(this)) continue;
            ++setCount;
            this.setUnionMember = members[memberIdx];
        }
        if (setCount > 1) {
            throw new IllegalArgumentException("More than one union member set for type: " + this.getApplicationModelType());
        }
    }

    @Override
    public void postFromJson() {
        this.selfDesignateSetUnionMember();
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (!(rhs instanceof IoTCoreMessage)) {
            return false;
        }
        if (this == rhs) {
            return true;
        }
        IoTCoreMessage other = (IoTCoreMessage)rhs;
        boolean isEquals = true;
        isEquals = isEquals && this.message.equals(other.message);
        isEquals = isEquals && this.setUnionMember.equals((Object)other.setUnionMember);
        return isEquals;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.message, this.setUnionMember});
    }

    public static enum UnionMember {
        MESSAGE("MESSAGE", obj -> IoTCoreMessage.access$002(obj, Optional.empty()), obj -> ((IoTCoreMessage)obj).message != null && ((IoTCoreMessage)obj).message.isPresent());

        private String fieldName;
        private Consumer<IoTCoreMessage> nullifier;
        private Predicate<IoTCoreMessage> isPresent;

        private UnionMember(String fieldName, Consumer<IoTCoreMessage> nullifier, Predicate<IoTCoreMessage> isPresent) {
            this.fieldName = fieldName;
            this.nullifier = nullifier;
            this.isPresent = isPresent;
        }

        void nullify(IoTCoreMessage obj) {
            this.nullifier.accept(obj);
        }

        boolean isPresent(IoTCoreMessage obj) {
            return this.isPresent.test(obj);
        }
    }
}

