/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.aws.greengrass.model;

import com.google.gson.annotations.Expose;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.aws.greengrass.model.PayloadFormat;
import software.amazon.awssdk.aws.greengrass.model.UserProperty;
import software.amazon.awssdk.eventstreamrpc.EventStreamRPCServiceModel;
import software.amazon.awssdk.eventstreamrpc.model.EventStreamJsonMessage;

public class MQTTMessage
implements EventStreamJsonMessage {
    public static final String APPLICATION_MODEL_TYPE = "aws.greengrass#MQTTMessage";
    public static final MQTTMessage VOID = new MQTTMessage(){

        @Override
        public boolean isVoid() {
            return true;
        }
    };
    @Expose(serialize=true, deserialize=true)
    private Optional<String> topicName = Optional.empty();
    @Expose(serialize=true, deserialize=true)
    private Optional<byte[]> payload = Optional.empty();
    @Expose(serialize=true, deserialize=true)
    private Optional<Boolean> retain = Optional.empty();
    @Expose(serialize=true, deserialize=true)
    private Optional<List<UserProperty>> userProperties = Optional.empty();
    @Expose(serialize=true, deserialize=true)
    private Optional<Long> messageExpiryIntervalSeconds = Optional.empty();
    @Expose(serialize=true, deserialize=true)
    private Optional<byte[]> correlationData = Optional.empty();
    @Expose(serialize=true, deserialize=true)
    private Optional<String> responseTopic = Optional.empty();
    @Expose(serialize=true, deserialize=true)
    private Optional<String> payloadFormat = Optional.empty();
    @Expose(serialize=true, deserialize=true)
    private Optional<String> contentType = Optional.empty();

    public String getTopicName() {
        if (this.topicName.isPresent()) {
            return this.topicName.get();
        }
        return null;
    }

    public void setTopicName(String topicName) {
        this.topicName = Optional.ofNullable(topicName);
    }

    public MQTTMessage withTopicName(String topicName) {
        this.setTopicName(topicName);
        return this;
    }

    public byte[] getPayload() {
        if (this.payload.isPresent()) {
            return this.payload.get();
        }
        return null;
    }

    public void setPayload(byte[] payload) {
        this.payload = Optional.ofNullable(payload);
    }

    public MQTTMessage withPayload(byte[] payload) {
        this.setPayload(payload);
        return this;
    }

    public Boolean isRetain() {
        if (this.retain.isPresent()) {
            return this.retain.get();
        }
        return null;
    }

    public void setRetain(Boolean retain) {
        this.retain = Optional.ofNullable(retain);
    }

    public MQTTMessage withRetain(Boolean retain) {
        this.setRetain(retain);
        return this;
    }

    public List<UserProperty> getUserProperties() {
        if (this.userProperties.isPresent()) {
            return this.userProperties.get();
        }
        return null;
    }

    public void setUserProperties(List<UserProperty> userProperties) {
        this.userProperties = Optional.ofNullable(userProperties);
    }

    public MQTTMessage withUserProperties(List<UserProperty> userProperties) {
        this.setUserProperties(userProperties);
        return this;
    }

    public Long getMessageExpiryIntervalSeconds() {
        if (this.messageExpiryIntervalSeconds.isPresent()) {
            return this.messageExpiryIntervalSeconds.get();
        }
        return null;
    }

    public void setMessageExpiryIntervalSeconds(Long messageExpiryIntervalSeconds) {
        this.messageExpiryIntervalSeconds = Optional.ofNullable(messageExpiryIntervalSeconds);
    }

    public MQTTMessage withMessageExpiryIntervalSeconds(Long messageExpiryIntervalSeconds) {
        this.setMessageExpiryIntervalSeconds(messageExpiryIntervalSeconds);
        return this;
    }

    public byte[] getCorrelationData() {
        if (this.correlationData.isPresent()) {
            return this.correlationData.get();
        }
        return null;
    }

    public void setCorrelationData(byte[] correlationData) {
        this.correlationData = Optional.ofNullable(correlationData);
    }

    public MQTTMessage withCorrelationData(byte[] correlationData) {
        this.setCorrelationData(correlationData);
        return this;
    }

    public String getResponseTopic() {
        if (this.responseTopic.isPresent()) {
            return this.responseTopic.get();
        }
        return null;
    }

    public void setResponseTopic(String responseTopic) {
        this.responseTopic = Optional.ofNullable(responseTopic);
    }

    public MQTTMessage withResponseTopic(String responseTopic) {
        this.setResponseTopic(responseTopic);
        return this;
    }

    public PayloadFormat getPayloadFormat() {
        if (this.payloadFormat.isPresent()) {
            return PayloadFormat.get(this.payloadFormat.get());
        }
        return null;
    }

    public String getPayloadFormatAsString() {
        if (this.payloadFormat.isPresent()) {
            return this.payloadFormat.get();
        }
        return null;
    }

    public void setPayloadFormat(String payloadFormat) {
        this.payloadFormat = Optional.ofNullable(payloadFormat);
    }

    public MQTTMessage withPayloadFormat(String payloadFormat) {
        this.setPayloadFormat(payloadFormat);
        return this;
    }

    public void setPayloadFormat(PayloadFormat payloadFormat) {
        this.payloadFormat = Optional.ofNullable(payloadFormat.getValue());
    }

    public MQTTMessage withPayloadFormat(PayloadFormat payloadFormat) {
        this.setPayloadFormat(payloadFormat);
        return this;
    }

    public String getContentType() {
        if (this.contentType.isPresent()) {
            return this.contentType.get();
        }
        return null;
    }

    public void setContentType(String contentType) {
        this.contentType = Optional.ofNullable(contentType);
    }

    public MQTTMessage withContentType(String contentType) {
        this.setContentType(contentType);
        return this;
    }

    @Override
    public String getApplicationModelType() {
        return APPLICATION_MODEL_TYPE;
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (!(rhs instanceof MQTTMessage)) {
            return false;
        }
        if (this == rhs) {
            return true;
        }
        MQTTMessage other = (MQTTMessage)rhs;
        boolean isEquals = true;
        isEquals = isEquals && this.topicName.equals(other.topicName);
        isEquals = isEquals && EventStreamRPCServiceModel.blobTypeEquals(this.payload, other.payload);
        isEquals = isEquals && this.retain.equals(other.retain);
        isEquals = isEquals && this.userProperties.equals(other.userProperties);
        isEquals = isEquals && this.messageExpiryIntervalSeconds.equals(other.messageExpiryIntervalSeconds);
        isEquals = isEquals && EventStreamRPCServiceModel.blobTypeEquals(this.correlationData, other.correlationData);
        isEquals = isEquals && this.responseTopic.equals(other.responseTopic);
        isEquals = isEquals && this.payloadFormat.equals(other.payloadFormat);
        isEquals = isEquals && this.contentType.equals(other.contentType);
        return isEquals;
    }

    public int hashCode() {
        return Objects.hash(this.topicName, this.payload, this.retain, this.userProperties, this.messageExpiryIntervalSeconds, this.correlationData, this.responseTopic, this.payloadFormat, this.contentType);
    }
}

