/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.aws.greengrass.model;

import com.google.gson.annotations.Expose;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import software.amazon.awssdk.eventstreamrpc.EventStreamRPCServiceModel;
import software.amazon.awssdk.eventstreamrpc.model.EventStreamJsonMessage;

public class SecretValue
implements EventStreamJsonMessage {
    public static final String APPLICATION_MODEL_TYPE = "aws.greengrass#SecretValue";
    private transient UnionMember setUnionMember;
    @Expose(serialize=true, deserialize=true)
    private Optional<String> secretString = Optional.empty();
    @Expose(serialize=true, deserialize=true)
    private Optional<byte[]> secretBinary = Optional.empty();

    public String getSecretString() {
        if (this.secretString.isPresent() && this.setUnionMember == UnionMember.SECRET_STRING) {
            return this.secretString.get();
        }
        return null;
    }

    public void setSecretString(String secretString) {
        if (this.setUnionMember != null) {
            this.setUnionMember.nullify(this);
        }
        this.secretString = Optional.of(secretString);
        this.setUnionMember = UnionMember.SECRET_STRING;
    }

    public SecretValue withSecretString(String secretString) {
        this.setSecretString(secretString);
        return this;
    }

    public byte[] getSecretBinary() {
        if (this.secretBinary.isPresent() && this.setUnionMember == UnionMember.SECRET_BINARY) {
            return this.secretBinary.get();
        }
        return null;
    }

    public void setSecretBinary(byte[] secretBinary) {
        if (this.setUnionMember != null) {
            this.setUnionMember.nullify(this);
        }
        this.secretBinary = Optional.of(secretBinary);
        this.setUnionMember = UnionMember.SECRET_BINARY;
    }

    public SecretValue withSecretBinary(byte[] secretBinary) {
        this.setSecretBinary(secretBinary);
        return this;
    }

    public UnionMember getSetUnionMember() {
        return this.setUnionMember;
    }

    @Override
    public String getApplicationModelType() {
        return APPLICATION_MODEL_TYPE;
    }

    public void selfDesignateSetUnionMember() {
        int setCount = 0;
        UnionMember[] members = UnionMember.values();
        for (int memberIdx = 0; memberIdx < UnionMember.values().length; ++memberIdx) {
            if (!members[memberIdx].isPresent(this)) continue;
            ++setCount;
            this.setUnionMember = members[memberIdx];
        }
        if (setCount > 1) {
            throw new IllegalArgumentException("More than one union member set for type: " + this.getApplicationModelType());
        }
    }

    @Override
    public void postFromJson() {
        this.selfDesignateSetUnionMember();
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (!(rhs instanceof SecretValue)) {
            return false;
        }
        if (this == rhs) {
            return true;
        }
        SecretValue other = (SecretValue)rhs;
        boolean isEquals = true;
        isEquals = isEquals && this.secretString.equals(other.secretString);
        isEquals = isEquals && EventStreamRPCServiceModel.blobTypeEquals(this.secretBinary, other.secretBinary);
        isEquals = isEquals && this.setUnionMember.equals((Object)other.setUnionMember);
        return isEquals;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.secretString, this.secretBinary, this.setUnionMember});
    }

    public static enum UnionMember {
        SECRET_STRING("SECRET_STRING", obj -> SecretValue.access$102(obj, Optional.empty()), obj -> ((SecretValue)obj).secretString != null && ((SecretValue)obj).secretString.isPresent()),
        SECRET_BINARY("SECRET_BINARY", obj -> SecretValue.access$002(obj, Optional.empty()), obj -> ((SecretValue)obj).secretBinary != null && ((SecretValue)obj).secretBinary.isPresent());

        private String fieldName;
        private Consumer<SecretValue> nullifier;
        private Predicate<SecretValue> isPresent;

        private UnionMember(String fieldName, Consumer<SecretValue> nullifier, Predicate<SecretValue> isPresent) {
            this.fieldName = fieldName;
            this.nullifier = nullifier;
            this.isPresent = isPresent;
        }

        void nullify(SecretValue obj) {
            this.nullifier.accept(obj);
        }

        boolean isPresent(SecretValue obj) {
            return this.isPresent.test(obj);
        }
    }
}

