/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.aws.greengrass.model;

import com.google.gson.annotations.Expose;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.aws.greengrass.model.ReceiveMode;
import software.amazon.awssdk.eventstreamrpc.model.EventStreamJsonMessage;

public class SubscribeToTopicRequest
implements EventStreamJsonMessage {
    public static final String APPLICATION_MODEL_TYPE = "aws.greengrass#SubscribeToTopicRequest";
    public static final SubscribeToTopicRequest VOID = new SubscribeToTopicRequest(){

        @Override
        public boolean isVoid() {
            return true;
        }
    };
    @Expose(serialize=true, deserialize=true)
    private Optional<String> topic = Optional.empty();
    @Expose(serialize=true, deserialize=true)
    private Optional<String> receiveMode = Optional.empty();

    public String getTopic() {
        if (this.topic.isPresent()) {
            return this.topic.get();
        }
        return null;
    }

    public void setTopic(String topic) {
        this.topic = Optional.ofNullable(topic);
    }

    public SubscribeToTopicRequest withTopic(String topic) {
        this.setTopic(topic);
        return this;
    }

    public ReceiveMode getReceiveMode() {
        if (this.receiveMode.isPresent()) {
            return ReceiveMode.get(this.receiveMode.get());
        }
        return null;
    }

    public String getReceiveModeAsString() {
        if (this.receiveMode.isPresent()) {
            return this.receiveMode.get();
        }
        return null;
    }

    public void setReceiveMode(String receiveMode) {
        this.receiveMode = Optional.ofNullable(receiveMode);
    }

    public SubscribeToTopicRequest withReceiveMode(String receiveMode) {
        this.setReceiveMode(receiveMode);
        return this;
    }

    public void setReceiveMode(ReceiveMode receiveMode) {
        this.receiveMode = Optional.ofNullable(receiveMode.getValue());
    }

    public SubscribeToTopicRequest withReceiveMode(ReceiveMode receiveMode) {
        this.setReceiveMode(receiveMode);
        return this;
    }

    @Override
    public String getApplicationModelType() {
        return APPLICATION_MODEL_TYPE;
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (!(rhs instanceof SubscribeToTopicRequest)) {
            return false;
        }
        if (this == rhs) {
            return true;
        }
        SubscribeToTopicRequest other = (SubscribeToTopicRequest)rhs;
        boolean isEquals = true;
        isEquals = isEquals && this.topic.equals(other.topic);
        isEquals = isEquals && this.receiveMode.equals(other.receiveMode);
        return isEquals;
    }

    public int hashCode() {
        return Objects.hash(this.topic, this.receiveMode);
    }
}

