/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.aws.greengrass.model;

import com.google.gson.annotations.Expose;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import software.amazon.awssdk.aws.greengrass.model.BinaryMessage;
import software.amazon.awssdk.aws.greengrass.model.JsonMessage;
import software.amazon.awssdk.eventstreamrpc.model.EventStreamJsonMessage;

public class SubscriptionResponseMessage
implements EventStreamJsonMessage {
    public static final String APPLICATION_MODEL_TYPE = "aws.greengrass#SubscriptionResponseMessage";
    private transient UnionMember setUnionMember;
    @Expose(serialize=true, deserialize=true)
    private Optional<JsonMessage> jsonMessage = Optional.empty();
    @Expose(serialize=true, deserialize=true)
    private Optional<BinaryMessage> binaryMessage = Optional.empty();

    public JsonMessage getJsonMessage() {
        if (this.jsonMessage.isPresent() && this.setUnionMember == UnionMember.JSON_MESSAGE) {
            return this.jsonMessage.get();
        }
        return null;
    }

    public void setJsonMessage(JsonMessage jsonMessage) {
        if (this.setUnionMember != null) {
            this.setUnionMember.nullify(this);
        }
        this.jsonMessage = Optional.of(jsonMessage);
        this.setUnionMember = UnionMember.JSON_MESSAGE;
    }

    public SubscriptionResponseMessage withJsonMessage(JsonMessage jsonMessage) {
        this.setJsonMessage(jsonMessage);
        return this;
    }

    public BinaryMessage getBinaryMessage() {
        if (this.binaryMessage.isPresent() && this.setUnionMember == UnionMember.BINARY_MESSAGE) {
            return this.binaryMessage.get();
        }
        return null;
    }

    public void setBinaryMessage(BinaryMessage binaryMessage) {
        if (this.setUnionMember != null) {
            this.setUnionMember.nullify(this);
        }
        this.binaryMessage = Optional.of(binaryMessage);
        this.setUnionMember = UnionMember.BINARY_MESSAGE;
    }

    public SubscriptionResponseMessage withBinaryMessage(BinaryMessage binaryMessage) {
        this.setBinaryMessage(binaryMessage);
        return this;
    }

    public UnionMember getSetUnionMember() {
        return this.setUnionMember;
    }

    @Override
    public String getApplicationModelType() {
        return APPLICATION_MODEL_TYPE;
    }

    public void selfDesignateSetUnionMember() {
        int setCount = 0;
        UnionMember[] members = UnionMember.values();
        for (int memberIdx = 0; memberIdx < UnionMember.values().length; ++memberIdx) {
            if (!members[memberIdx].isPresent(this)) continue;
            ++setCount;
            this.setUnionMember = members[memberIdx];
        }
        if (setCount > 1) {
            throw new IllegalArgumentException("More than one union member set for type: " + this.getApplicationModelType());
        }
    }

    @Override
    public void postFromJson() {
        this.selfDesignateSetUnionMember();
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (!(rhs instanceof SubscriptionResponseMessage)) {
            return false;
        }
        if (this == rhs) {
            return true;
        }
        SubscriptionResponseMessage other = (SubscriptionResponseMessage)rhs;
        boolean isEquals = true;
        isEquals = isEquals && this.jsonMessage.equals(other.jsonMessage);
        isEquals = isEquals && this.binaryMessage.equals(other.binaryMessage);
        isEquals = isEquals && this.setUnionMember.equals((Object)other.setUnionMember);
        return isEquals;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.jsonMessage, this.binaryMessage, this.setUnionMember});
    }

    public static enum UnionMember {
        JSON_MESSAGE("JSON_MESSAGE", obj -> SubscriptionResponseMessage.access$102(obj, Optional.empty()), obj -> ((SubscriptionResponseMessage)obj).jsonMessage != null && ((SubscriptionResponseMessage)obj).jsonMessage.isPresent()),
        BINARY_MESSAGE("BINARY_MESSAGE", obj -> SubscriptionResponseMessage.access$002(obj, Optional.empty()), obj -> ((SubscriptionResponseMessage)obj).binaryMessage != null && ((SubscriptionResponseMessage)obj).binaryMessage.isPresent());

        private String fieldName;
        private Consumer<SubscriptionResponseMessage> nullifier;
        private Predicate<SubscriptionResponseMessage> isPresent;

        private UnionMember(String fieldName, Consumer<SubscriptionResponseMessage> nullifier, Predicate<SubscriptionResponseMessage> isPresent) {
            this.fieldName = fieldName;
            this.nullifier = nullifier;
            this.isPresent = isPresent;
        }

        void nullify(SubscriptionResponseMessage obj) {
            this.nullifier.accept(obj);
        }

        boolean isPresent(SubscriptionResponseMessage obj) {
            return this.isPresent.test(obj);
        }
    }
}

