/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.aws.greengrass.model;

import com.google.gson.annotations.Expose;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.aws.greengrass.model.ReportedLifecycleState;
import software.amazon.awssdk.eventstreamrpc.model.EventStreamJsonMessage;

public class UpdateStateRequest
implements EventStreamJsonMessage {
    public static final String APPLICATION_MODEL_TYPE = "aws.greengrass#UpdateStateRequest";
    public static final UpdateStateRequest VOID = new UpdateStateRequest(){

        @Override
        public boolean isVoid() {
            return true;
        }
    };
    @Expose(serialize=true, deserialize=true)
    private Optional<String> state = Optional.empty();

    public ReportedLifecycleState getState() {
        if (this.state.isPresent()) {
            return ReportedLifecycleState.get(this.state.get());
        }
        return null;
    }

    public String getStateAsString() {
        if (this.state.isPresent()) {
            return this.state.get();
        }
        return null;
    }

    public void setState(String state) {
        this.state = Optional.ofNullable(state);
    }

    public UpdateStateRequest withState(String state) {
        this.setState(state);
        return this;
    }

    public void setState(ReportedLifecycleState state) {
        this.state = Optional.ofNullable(state.getValue());
    }

    public UpdateStateRequest withState(ReportedLifecycleState state) {
        this.setState(state);
        return this;
    }

    @Override
    public String getApplicationModelType() {
        return APPLICATION_MODEL_TYPE;
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (!(rhs instanceof UpdateStateRequest)) {
            return false;
        }
        if (this == rhs) {
            return true;
        }
        UpdateStateRequest other = (UpdateStateRequest)rhs;
        boolean isEquals = true;
        isEquals = isEquals && this.state.equals(other.state);
        return isEquals;
    }

    public int hashCode() {
        return Objects.hash(this.state);
    }
}

