/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.eventstreamrpc;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.crt.utils.StringUtils;
import software.amazon.awssdk.eventstreamrpc.DeserializationException;
import software.amazon.awssdk.eventstreamrpc.OperationModelContext;
import software.amazon.awssdk.eventstreamrpc.SerializationException;
import software.amazon.awssdk.eventstreamrpc.UnmappedDataException;
import software.amazon.awssdk.eventstreamrpc.model.AccessDeniedException;
import software.amazon.awssdk.eventstreamrpc.model.EventStreamJsonMessage;
import software.amazon.awssdk.eventstreamrpc.model.UnsupportedOperationException;
import software.amazon.awssdk.eventstreamrpc.model.ValidationException;

public abstract class EventStreamRPCServiceModel {
    private static final Gson GSON;
    static final String VERSION_HEADER = ":version";
    public static final String CONTENT_TYPE_HEADER = ":content-type";
    public static final String CONTENT_TYPE_APPLICATION_TEXT = "text/plain";
    public static final String CONTENT_TYPE_APPLICATION_JSON = "application/json";
    public static final String SERVICE_MODEL_TYPE_HEADER = "service-model-type";
    private static final Map<String, Class<? extends EventStreamJsonMessage>> FRAMEWORK_APPLICATION_MODEL_TYPES;

    public static boolean blobTypeEquals(Optional<byte[]> lhs, Optional<byte[]> rhs) {
        if (lhs.equals(rhs)) {
            return true;
        }
        if (!lhs.isPresent() || !rhs.isPresent()) {
            return false;
        }
        return Arrays.equals(lhs.get(), rhs.get());
    }

    public abstract String getServiceName();

    public final Optional<Class<? extends EventStreamJsonMessage>> getApplicationModelClass(String applicationModelType) {
        Class<? extends EventStreamJsonMessage> clazz = FRAMEWORK_APPLICATION_MODEL_TYPES.get(applicationModelType);
        if (clazz != null) {
            return Optional.of(clazz);
        }
        return this.getServiceClassType(applicationModelType);
    }

    public abstract Collection<String> getAllOperations();

    protected abstract Optional<Class<? extends EventStreamJsonMessage>> getServiceClassType(String var1);

    public abstract OperationModelContext getOperationModelContext(String var1);

    public byte[] toJson(EventStreamJsonMessage message) {
        try {
            byte[] json = message.toPayload(this.getGson());
            String stringJson = new String(json, StandardCharsets.UTF_8);
            if (null == stringJson || "null".equals(stringJson) || stringJson.isEmpty()) {
                return "{}".getBytes(StandardCharsets.UTF_8);
            }
            return json;
        }
        catch (Exception e) {
            throw new SerializationException(message, (Throwable)e);
        }
    }

    public String toJsonString(EventStreamJsonMessage message) {
        return new String(this.toJson(message), StandardCharsets.UTF_8);
    }

    protected Gson getGson() {
        return GSON;
    }

    public static Gson getStaticGson() {
        return GSON;
    }

    public EventStreamJsonMessage fromJson(String applicationModelType, byte[] payload) {
        Optional<Class<? extends EventStreamJsonMessage>> clazz = this.getApplicationModelClass(applicationModelType);
        if (!clazz.isPresent()) {
            throw new UnmappedDataException(applicationModelType);
        }
        return this.fromJson(clazz.get(), payload);
    }

    public <T extends EventStreamJsonMessage> T fromJson(Class<T> clazz, byte[] payload) {
        try {
            return (T)((EventStreamJsonMessage)this.getGson().fromJson(new String(payload, StandardCharsets.UTF_8), clazz));
        }
        catch (Exception e) {
            throw new DeserializationException(payload, (Throwable)e);
        }
    }

    static {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapterFactory((TypeAdapterFactory)new ForceNullsForMapTypeAdapterFactory());
        builder.registerTypeAdapterFactory(OptionalTypeAdapter.FACTORY);
        builder.registerTypeAdapterFactory(EventStreamPostFromJsonTypeAdapter.FACTORY);
        builder.registerTypeAdapter(byte[].class, (Object)new Base64BlobSerializerDeserializer());
        builder.registerTypeAdapter(Instant.class, (Object)new InstantSerializerDeserializer());
        builder.excludeFieldsWithoutExposeAnnotation();
        GSON = builder.create();
        FRAMEWORK_APPLICATION_MODEL_TYPES = new HashMap<String, Class<? extends EventStreamJsonMessage>>();
        FRAMEWORK_APPLICATION_MODEL_TYPES.put("aws#AccessDenied", AccessDeniedException.class);
        FRAMEWORK_APPLICATION_MODEL_TYPES.put("aws#UnsupportedOperation", UnsupportedOperationException.class);
        FRAMEWORK_APPLICATION_MODEL_TYPES.put("aws#ValidationException", ValidationException.class);
    }

    private static class ForceNullsForMapTypeAdapterFactory
    implements TypeAdapterFactory {
        private ForceNullsForMapTypeAdapterFactory() {
        }

        public final <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (Map.class.isAssignableFrom(type.getRawType())) {
                TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
                return this.createCustomTypeAdapter(delegate);
            }
            return null;
        }

        private <T> TypeAdapter<T> createCustomTypeAdapter(final TypeAdapter<T> delegate) {
            return new TypeAdapter<T>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void write(JsonWriter out, T value) throws IOException {
                    boolean serializeNulls = out.getSerializeNulls();
                    try {
                        out.setSerializeNulls(true);
                        delegate.write(out, value);
                    }
                    finally {
                        out.setSerializeNulls(serializeNulls);
                    }
                }

                public T read(JsonReader in) throws IOException {
                    return delegate.read(in);
                }
            };
        }
    }

    private static class OptionalTypeAdapter<E>
    extends TypeAdapter<Optional<E>> {
        public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
                Class rawType = type.getRawType();
                if (rawType != Optional.class) {
                    return null;
                }
                ParameterizedType parameterizedType = (ParameterizedType)type.getType();
                Type actualType = parameterizedType.getActualTypeArguments()[0];
                TypeAdapter adapter = gson.getAdapter(TypeToken.get((Type)actualType));
                return new OptionalTypeAdapter(adapter);
            }
        };
        private final TypeAdapter<E> adapter;

        public OptionalTypeAdapter(TypeAdapter<E> adapter) {
            this.adapter = adapter;
        }

        public void write(JsonWriter out, Optional<E> value) throws IOException {
            if (value.isPresent()) {
                this.adapter.write(out, value.get());
            } else if (value != null) {
                out.nullValue();
            }
        }

        public Optional<E> read(JsonReader in) throws IOException {
            return Optional.ofNullable(this.adapter.read(in));
        }
    }

    private static class EventStreamPostFromJsonTypeAdapter<E extends EventStreamJsonMessage>
    extends TypeAdapter<E> {
        public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
                if (EventStreamJsonMessage.class.isAssignableFrom(type.getRawType())) {
                    TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
                    return new EventStreamPostFromJsonTypeAdapter(delegate);
                }
                return null;
            }
        };
        private final TypeAdapter<E> adapter;

        public EventStreamPostFromJsonTypeAdapter(TypeAdapter<E> adapter) {
            this.adapter = adapter;
        }

        public void write(JsonWriter out, E value) throws IOException {
            this.adapter.write(out, value);
        }

        public E read(JsonReader in) throws IOException {
            EventStreamJsonMessage obj = (EventStreamJsonMessage)this.adapter.read(in);
            if (obj != null) {
                obj.postFromJson();
            }
            return (E)obj;
        }
    }

    private static class Base64BlobSerializerDeserializer
    implements JsonSerializer<byte[]>,
    JsonDeserializer<byte[]> {
        private Base64BlobSerializerDeserializer() {
        }

        public byte[] deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return StringUtils.base64Decode((byte[])json.getAsString().getBytes());
        }

        public JsonElement serialize(byte[] src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(new String(StringUtils.base64Encode((byte[])src)));
        }
    }

    private static class InstantSerializerDeserializer
    implements JsonSerializer<Instant>,
    JsonDeserializer<Instant> {
        private InstantSerializerDeserializer() {
        }

        public Instant deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            double fSecondsEpoch = json.getAsDouble();
            long secondsEpoch = (long)fSecondsEpoch;
            long nanoEpoch = (long)((fSecondsEpoch - (double)secondsEpoch) * 1.0E9);
            return Instant.ofEpochSecond(secondsEpoch, nanoEpoch);
        }

        public JsonElement serialize(Instant src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive((Number)((double)src.getEpochSecond() + (double)src.getNano() / 1.0E9));
        }
    }
}

