/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.eventstreamrpc;

import java.util.Optional;
import software.amazon.awssdk.eventstreamrpc.EventStreamRPCServiceModel;
import software.amazon.awssdk.eventstreamrpc.model.EventStreamJsonMessage;

public interface OperationModelContext<RequestType extends EventStreamJsonMessage, ResponseType extends EventStreamJsonMessage, StreamingRequestType extends EventStreamJsonMessage, StreamingResponseType extends EventStreamJsonMessage> {
    public EventStreamRPCServiceModel getServiceModel();

    public String getOperationName();

    public Class<RequestType> getRequestTypeClass();

    public String getRequestApplicationModelType();

    public Class<ResponseType> getResponseTypeClass();

    public String getResponseApplicationModelType();

    public Optional<Class<StreamingRequestType>> getStreamingRequestTypeClass();

    public Optional<String> getStreamingRequestApplicationModelType();

    public Optional<Class<StreamingResponseType>> getStreamingResponseTypeClass();

    public Optional<String> getStreamingResponseApplicationModelType();

    default public boolean isStreamingOperation() {
        return this.getStreamingRequestTypeClass().isPresent() || this.getStreamingResponseTypeClass().isPresent();
    }
}

