/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.eventstreamrpc;

import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import software.amazon.awssdk.crt.eventstream.ClientConnectionContinuation;
import software.amazon.awssdk.crt.eventstream.Header;
import software.amazon.awssdk.crt.eventstream.MessageFlags;
import software.amazon.awssdk.crt.eventstream.MessageType;
import software.amazon.awssdk.eventstreamrpc.OperationModelContext;
import software.amazon.awssdk.eventstreamrpc.StreamResponse;
import software.amazon.awssdk.eventstreamrpc.model.EventStreamJsonMessage;

public class OperationResponse<ResponseType extends EventStreamJsonMessage, StreamRequestType extends EventStreamJsonMessage>
implements StreamResponse<ResponseType, StreamRequestType>,
AutoCloseable {
    private static final Logger LOGGER = Logger.getLogger(OperationResponse.class.getName());
    private final OperationModelContext operationModelContext;
    private final ClientConnectionContinuation continuation;
    private final CompletableFuture<ResponseType> responseFuture;
    private final CompletableFuture<Void> requestFlushFuture;
    private final AtomicBoolean isClosed;

    public OperationResponse(OperationModelContext<ResponseType, ?, StreamRequestType, ?> operationModelContext, ClientConnectionContinuation continuation, CompletableFuture<ResponseType> responseFuture, CompletableFuture<Void> requestFlushFuture) {
        this.operationModelContext = operationModelContext;
        this.continuation = continuation;
        this.responseFuture = responseFuture;
        this.requestFlushFuture = requestFlushFuture;
        this.isClosed = new AtomicBoolean(continuation != null && !continuation.isNull());
    }

    @Override
    public final CompletableFuture<Void> getRequestFlushFuture() {
        return this.requestFlushFuture;
    }

    @Override
    public CompletableFuture<ResponseType> getResponse() {
        return this.requestFlushFuture.thenCompose(v -> this.responseFuture);
    }

    @Override
    public CompletableFuture<Void> sendStreamEvent(StreamRequestType streamEvent) {
        try {
            LinkedList<Header> headers = new LinkedList<Header>();
            headers.add(Header.createHeader((String)"service-model-type", (String)this.operationModelContext.getStreamingRequestApplicationModelType().get()));
            headers.add(Header.createHeader((String)":content-type", (String)"application/json"));
            byte[] payload = this.operationModelContext.getServiceModel().toJson((EventStreamJsonMessage)streamEvent);
            return this.continuation.sendMessage(headers, payload, MessageType.ApplicationMessage, 0).whenComplete((res, ex) -> {
                if (ex != null) {
                    LOGGER.warning(String.format("%s caught %s while sending message the event stream: %s", this.operationModelContext.getOperationName(), ex.getClass().getName(), ex.getMessage()));
                    this.closeStream();
                }
            });
        }
        catch (Exception e) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            future.completeExceptionally(e);
            return future;
        }
    }

    @Override
    public CompletableFuture<Void> closeStream() {
        if (this.continuation != null && !this.continuation.isNull()) {
            return this.continuation.sendMessage(null, null, MessageType.ApplicationMessage, MessageFlags.TerminateStream.getByteValue()).whenComplete((res, ex) -> {
                LOGGER.info(this.operationModelContext.getOperationName() + " operation stream closed");
                this.continuation.close();
                if (ex != null) {
                    LOGGER.warning(String.format("%s threw %s while closing the event stream: %s", this.operationModelContext.getOperationName(), ex.getClass().getName(), ex.getMessage()));
                }
            });
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public boolean isClosed() {
        return this.isClosed.get();
    }

    @Override
    public void close() throws Exception {
        if (this.isClosed.compareAndSet(false, true)) {
            this.closeStream();
        }
    }
}

