/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.eventstreamrpc.model;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import software.amazon.awssdk.eventstreamrpc.model.EventStreamJsonMessage;

public abstract class EventStreamOperationError
extends RuntimeException
implements EventStreamJsonMessage {
    @SerializedName(value="_service")
    @Expose(serialize=true, deserialize=true)
    private final String _service;
    @SerializedName(value="_message")
    @Expose(serialize=true, deserialize=true)
    private final String _message;
    @SerializedName(value="_errorCode")
    @Expose(serialize=true, deserialize=true)
    private final String _errorCode;

    public EventStreamOperationError(String serviceName, String errorCode, String message) {
        super(String.format("%s[%s]: %s", errorCode, serviceName, message));
        this._service = serviceName;
        this._errorCode = errorCode;
        this._message = message;
    }

    public String getService() {
        return this._service;
    }

    @Override
    public String getMessage() {
        return this._message;
    }

    public String getErrorCode() {
        return this._errorCode;
    }
}

