/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.iot;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import software.amazon.awssdk.crt.CRT;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.auth.credentials.CredentialsProvider;
import software.amazon.awssdk.crt.auth.credentials.DefaultChainCredentialsProvider;
import software.amazon.awssdk.crt.auth.signing.AwsSigningConfig;
import software.amazon.awssdk.crt.http.HttpProxyOptions;
import software.amazon.awssdk.crt.io.ClientBootstrap;
import software.amazon.awssdk.crt.io.ExponentialBackoffRetryOptions;
import software.amazon.awssdk.crt.io.SocketOptions;
import software.amazon.awssdk.crt.io.TlsContext;
import software.amazon.awssdk.crt.io.TlsContextCustomKeyOperationOptions;
import software.amazon.awssdk.crt.io.TlsContextOptions;
import software.amazon.awssdk.crt.io.TlsContextPkcs11Options;
import software.amazon.awssdk.crt.mqtt.MqttConnectionConfig;
import software.amazon.awssdk.crt.mqtt5.Mqtt5Client;
import software.amazon.awssdk.crt.mqtt5.Mqtt5ClientOptions;
import software.amazon.awssdk.crt.mqtt5.Mqtt5WebsocketHandshakeTransformArgs;
import software.amazon.awssdk.crt.mqtt5.TopicAliasingOptions;
import software.amazon.awssdk.crt.mqtt5.packets.ConnectPacket;
import software.amazon.awssdk.crt.utils.PackageInfo;
import software.amazon.awssdk.iot.AwsMqtt5Sigv4HandshakeTransformer;

public class AwsIotMqtt5ClientBuilder
extends CrtResource {
    private static Long DEFAULT_WEBSOCKET_MQTT_PORT = 443L;
    private static Long DEFAULT_DIRECT_MQTT_PORT = 8883L;
    private static Long DEFAULT_KEEP_ALIVE = 1200L;
    private Mqtt5ClientOptions.Mqtt5ClientOptionsBuilder config;
    private ConnectPacket.ConnectPacketBuilder configConnect;
    private TlsContextOptions configTls;
    private MqttConnectCustomAuthConfig configCustomAuth;

    private AwsIotMqtt5ClientBuilder(String hostName, Long port, TlsContextOptions tlsContext) {
        this.config = new Mqtt5ClientOptions.Mqtt5ClientOptionsBuilder(hostName, port);
        this.configTls = tlsContext;
        this.configConnect = new ConnectPacket.ConnectPacketBuilder();
        this.configConnect.withKeepAliveIntervalSeconds(DEFAULT_KEEP_ALIVE);
        this.config.withExtendedValidationAndFlowControlOptions(Mqtt5ClientOptions.ExtendedValidationAndFlowControlOptions.AWS_IOT_CORE_DEFAULTS);
        this.addReferenceTo((CrtResource)this.configTls);
    }

    protected boolean canReleaseReferencesImmediately() {
        return true;
    }

    protected void releaseNativeHandle() {
    }

    public static AwsIotMqtt5ClientBuilder newDirectMqttBuilderWithMtlsFromPath(String hostName, String certificatePath, String privateKeyPath) {
        TlsContextOptions options = TlsContextOptions.createWithMtlsFromPath((String)certificatePath, (String)privateKeyPath);
        AwsIotMqtt5ClientBuilder builder = new AwsIotMqtt5ClientBuilder(hostName, DEFAULT_DIRECT_MQTT_PORT, options);
        options.close();
        if (TlsContextOptions.isAlpnSupported()) {
            builder.configTls.withAlpnList("x-amzn-mqtt-ca");
        }
        return builder;
    }

    public static AwsIotMqtt5ClientBuilder newDirectMqttBuilderWithMtlsFromMemory(String hostName, String certificate, String privateKey) {
        TlsContextOptions options = TlsContextOptions.createWithMtls((String)certificate, (String)privateKey);
        AwsIotMqtt5ClientBuilder builder = new AwsIotMqtt5ClientBuilder(hostName, DEFAULT_DIRECT_MQTT_PORT, options);
        options.close();
        if (TlsContextOptions.isAlpnSupported()) {
            builder.configTls.withAlpnList("x-amzn-mqtt-ca");
        }
        return builder;
    }

    public static AwsIotMqtt5ClientBuilder newDirectMqttBuilderWithMtlsFromPkcs11(String hostName, TlsContextPkcs11Options pkcs11Options) {
        TlsContextOptions options = TlsContextOptions.createWithMtlsPkcs11((TlsContextPkcs11Options)pkcs11Options);
        AwsIotMqtt5ClientBuilder builder = new AwsIotMqtt5ClientBuilder(hostName, DEFAULT_DIRECT_MQTT_PORT, options);
        options.close();
        if (TlsContextOptions.isAlpnSupported()) {
            builder.configTls.withAlpnList("x-amzn-mqtt-ca");
        }
        return builder;
    }

    public static AwsIotMqtt5ClientBuilder newDirectMtlsCustomKeyOperationsBuilder(String hostName, TlsContextCustomKeyOperationOptions operationOptions) {
        TlsContextOptions options = TlsContextOptions.createWithMtlsCustomKeyOperations((TlsContextCustomKeyOperationOptions)operationOptions);
        AwsIotMqtt5ClientBuilder builder = new AwsIotMqtt5ClientBuilder(hostName, DEFAULT_DIRECT_MQTT_PORT, options);
        options.close();
        if (TlsContextOptions.isAlpnSupported()) {
            builder.configTls.withAlpnList("x-amzn-mqtt-ca");
        }
        return builder;
    }

    public static AwsIotMqtt5ClientBuilder newDirectMqttBuilderWithMtlsFromWindowsCertStorePath(String hostName, String certificatePath) {
        TlsContextOptions options = TlsContextOptions.createWithMtlsWindowsCertStorePath((String)certificatePath);
        AwsIotMqtt5ClientBuilder builder = new AwsIotMqtt5ClientBuilder(hostName, DEFAULT_DIRECT_MQTT_PORT, options);
        options.close();
        if (TlsContextOptions.isAlpnSupported()) {
            builder.configTls.withAlpnList("x-amzn-mqtt-ca");
        }
        return builder;
    }

    public static AwsIotMqtt5ClientBuilder newDirectMqttBuilderWithCustomAuth(String hostName, MqttConnectCustomAuthConfig customAuthConfig) {
        TlsContextOptions options = TlsContextOptions.createDefaultClient();
        options.alpnList.clear();
        options.alpnList.add("mqtt");
        AwsIotMqtt5ClientBuilder builder = new AwsIotMqtt5ClientBuilder(hostName, DEFAULT_WEBSOCKET_MQTT_PORT, options);
        builder.configCustomAuth = customAuthConfig;
        options.close();
        return builder;
    }

    @Deprecated
    public static AwsIotMqtt5ClientBuilder newDirectMqttBuilderWithMtlsFromPkcs11(String hostName, String pkcs12Path, String pkcs12Password) {
        return AwsIotMqtt5ClientBuilder.newDirectMqttBuilderWithMtlsFromPkcs12(hostName, pkcs12Path, pkcs12Password);
    }

    public static AwsIotMqtt5ClientBuilder newDirectMqttBuilderWithMtlsFromPkcs12(String hostName, String pkcs12Path, String pkcs12Password) {
        TlsContextOptions options = TlsContextOptions.createWithMtlsPkcs12((String)pkcs12Path, (String)pkcs12Password);
        AwsIotMqtt5ClientBuilder builder = new AwsIotMqtt5ClientBuilder(hostName, DEFAULT_DIRECT_MQTT_PORT, options);
        options.close();
        if (TlsContextOptions.isAlpnSupported()) {
            builder.configTls.withAlpnList("x-amzn-mqtt-ca");
        }
        return builder;
    }

    public static AwsIotMqtt5ClientBuilder newWebsocketMqttBuilderWithSigv4Auth(String hostName, WebsocketSigv4Config config) {
        TlsContextOptions options = TlsContextOptions.createDefaultClient();
        options.alpnList.clear();
        AwsIotMqtt5ClientBuilder builder = new AwsIotMqtt5ClientBuilder(hostName, DEFAULT_WEBSOCKET_MQTT_PORT, options);
        options.close();
        CredentialsProvider provider = null;
        if (config != null) {
            provider = config.credentialsProvider;
        }
        try (AwsSigningConfig signingConfig = new AwsSigningConfig();){
            signingConfig.setAlgorithm(AwsSigningConfig.AwsSigningAlgorithm.SIGV4);
            signingConfig.setSignatureType(AwsSigningConfig.AwsSignatureType.HTTP_REQUEST_VIA_QUERY_PARAMS);
            if (provider != null) {
                signingConfig.setCredentialsProvider(provider);
            } else {
                DefaultChainCredentialsProvider.DefaultChainCredentialsProviderBuilder providerBuilder = new DefaultChainCredentialsProvider.DefaultChainCredentialsProviderBuilder();
                providerBuilder.withClientBootstrap(ClientBootstrap.getOrCreateStaticDefault());
                try (DefaultChainCredentialsProvider defaultProvider = providerBuilder.build();){
                    signingConfig.setCredentialsProvider((CredentialsProvider)defaultProvider);
                }
            }
            if (config != null) {
                if (config.region != null) {
                    signingConfig.setRegion(config.region);
                } else {
                    signingConfig.setRegion(AwsIotMqtt5ClientBuilder.extractRegionFromEndpoint(hostName));
                }
            } else {
                signingConfig.setRegion(AwsIotMqtt5ClientBuilder.extractRegionFromEndpoint(hostName));
            }
            signingConfig.setService("iotdevicegateway");
            signingConfig.setOmitSessionToken(true);
            options.addReferenceTo((CrtResource)signingConfig);
            try (AwsMqtt5Sigv4HandshakeTransformer transformer = new AwsMqtt5Sigv4HandshakeTransformer(signingConfig);){
                builder.config.withWebsocketHandshakeTransform((Consumer)transformer);
                options.addReferenceTo((CrtResource)transformer);
            }
        }
        catch (Exception ex) {
            System.out.println("Error - exception occurred while making Websocket Sigv4 builder: " + ex.toString());
            ex.printStackTrace();
            return null;
        }
        return builder;
    }

    public static AwsIotMqtt5ClientBuilder newWebsocketMqttBuilderWithCustomAuth(String hostName, MqttConnectCustomAuthConfig customAuthConfig) {
        TlsContextOptions options = TlsContextOptions.createDefaultClient();
        AwsIotMqtt5ClientBuilder builder = new AwsIotMqtt5ClientBuilder(hostName, DEFAULT_WEBSOCKET_MQTT_PORT, options);
        builder.configCustomAuth = customAuthConfig;
        options.close();
        Consumer<Mqtt5WebsocketHandshakeTransformArgs> websocketTransform = new Consumer<Mqtt5WebsocketHandshakeTransformArgs>(){

            @Override
            public void accept(Mqtt5WebsocketHandshakeTransformArgs t) {
                t.complete(t.getHttpRequest());
            }
        };
        builder.config.withWebsocketHandshakeTransform((Consumer)websocketTransform);
        return builder;
    }

    public static AwsIotMqtt5ClientBuilder newDirectMqttBuilderWithJavaKeystore(String hostName, KeyStore keyStore, String certificateAlias, String certificatePassword) {
        TlsContextOptions options = TlsContextOptions.createWithMtlsJavaKeystore((KeyStore)keyStore, (String)certificateAlias, (String)certificatePassword);
        AwsIotMqtt5ClientBuilder builder = new AwsIotMqtt5ClientBuilder(hostName, DEFAULT_DIRECT_MQTT_PORT, options);
        options.close();
        if (TlsContextOptions.isAlpnSupported()) {
            builder.configTls.withAlpnList("x-amzn-mqtt-ca");
        }
        return builder;
    }

    public static AwsIotMqtt5ClientBuilder newMqttBuilder(String hostName) {
        TlsContextOptions options = TlsContextOptions.createDefaultClient();
        AwsIotMqtt5ClientBuilder builder = new AwsIotMqtt5ClientBuilder(hostName, DEFAULT_DIRECT_MQTT_PORT, options);
        options.close();
        if (TlsContextOptions.isAlpnSupported()) {
            builder.configTls.withAlpnList("x-amzn-mqtt-ca");
        }
        return builder;
    }

    public static AwsIotMqtt5ClientBuilder newMqttBuilderFromMqtt311ConnectionConfig(MqttConnectionConfig mqtt311Config, TlsContextOptions tlsOptions) throws Exception {
        if (mqtt311Config.getEndpoint() == null) {
            throw new Exception("MQTT311 to MQTT5 builder requires MQTT311 to have a endpoint set");
        }
        if (tlsOptions == null) {
            throw new Exception("MQTT311 to MQTT5 builder requires MQTT311 to TLS options passed");
        }
        AwsIotMqtt5ClientBuilder builder = new AwsIotMqtt5ClientBuilder(mqtt311Config.getEndpoint(), Long.valueOf(mqtt311Config.getPort()), tlsOptions);
        if (tlsOptions.isAlpnSupported()) {
            builder.configTls.withAlpnList("x-amzn-mqtt-ca");
        }
        if (mqtt311Config.getUseWebsockets()) {
            throw new Exception("MQTT311 to MQTT5 builder does not support MQTT311 websockets");
        }
        if (mqtt311Config.getWillMessage() != null) {
            throw new Exception("MQTT311 to MQTT5 builder does not support MQTT311 Will messages");
        }
        ConnectPacket.ConnectPacketBuilder connectPacket = new ConnectPacket.ConnectPacketBuilder();
        if (mqtt311Config.getClientId() != null) {
            connectPacket.withClientId(mqtt311Config.getClientId());
        }
        connectPacket.withKeepAliveIntervalSeconds(Long.valueOf(mqtt311Config.getKeepAliveSecs()));
        if (mqtt311Config.getUsername() != null) {
            connectPacket.withUsername(mqtt311Config.getUsername());
        }
        if (mqtt311Config.getPassword() != null) {
            connectPacket.withPassword(mqtt311Config.getPassword().getBytes());
        }
        builder.withConnectProperties(connectPacket);
        builder.withHttpProxyOptions(mqtt311Config.getHttpProxyOptions());
        builder.withMaxReconnectDelayMs(mqtt311Config.getMaxReconnectTimeoutSecs() * 1000L);
        builder.withMinReconnectDelayMs(mqtt311Config.getMinReconnectTimeoutSecs() * 1000L);
        builder.withPingTimeoutMs(Long.valueOf(mqtt311Config.getPingTimeoutMs()));
        builder.withAckTimeoutSeconds((long)mqtt311Config.getProtocolOperationTimeoutMs() * 1000L);
        builder.withSocketOptions(mqtt311Config.getSocketOptions());
        return builder;
    }

    public AwsIotMqtt5ClientBuilder withCertificateAuthorityFromPath(String caDirPath, String caFilePath) {
        this.configTls.overrideDefaultTrustStoreFromPath(caDirPath, caFilePath);
        return this;
    }

    public AwsIotMqtt5ClientBuilder withCertificateAuthority(String caRoot) {
        this.configTls.overrideDefaultTrustStore(caRoot);
        return this;
    }

    public AwsIotMqtt5ClientBuilder withPort(Long port) {
        this.config.withPort(port);
        return this;
    }

    public AwsIotMqtt5ClientBuilder withConnectProperties(ConnectPacket.ConnectPacketBuilder connectPacket) {
        this.configConnect = connectPacket;
        return this;
    }

    public AwsIotMqtt5ClientBuilder withSessionBehavior(Mqtt5ClientOptions.ClientSessionBehavior sessionBehavior) {
        this.config.withSessionBehavior(sessionBehavior);
        return this;
    }

    public AwsIotMqtt5ClientBuilder withRetryJitterMode(ExponentialBackoffRetryOptions.JitterMode jitterMode) {
        this.config.withRetryJitterMode(jitterMode);
        return this;
    }

    public AwsIotMqtt5ClientBuilder withMinReconnectDelayMs(Long minReconnectDelayMs) {
        this.config.withMinReconnectDelayMs(minReconnectDelayMs);
        return this;
    }

    public AwsIotMqtt5ClientBuilder withMaxReconnectDelayMs(Long maxReconnectDelayMs) {
        this.config.withMaxReconnectDelayMs(maxReconnectDelayMs);
        return this;
    }

    public AwsIotMqtt5ClientBuilder withMinConnectedTimeToResetReconnectDelayMs(Long minConnectedTimeToResetReconnectDelayMs) {
        this.config.withMinConnectedTimeToResetReconnectDelayMs(minConnectedTimeToResetReconnectDelayMs);
        return this;
    }

    public AwsIotMqtt5ClientBuilder withConnackTimeoutMs(Long connackTimeoutMs) {
        this.config.withConnackTimeoutMs(connackTimeoutMs);
        return this;
    }

    public AwsIotMqtt5ClientBuilder withOfflineQueueBehavior(Mqtt5ClientOptions.ClientOfflineQueueBehavior offlineQueueBehavior) {
        this.config.withOfflineQueueBehavior(offlineQueueBehavior);
        return this;
    }

    public AwsIotMqtt5ClientBuilder withPingTimeoutMs(Long pingTimeoutMs) {
        this.config.withPingTimeoutMs(pingTimeoutMs);
        return this;
    }

    public AwsIotMqtt5ClientBuilder withAckTimeoutSeconds(Long ackTimeoutSeconds) {
        this.config.withAckTimeoutSeconds(ackTimeoutSeconds);
        return this;
    }

    public AwsIotMqtt5ClientBuilder withSocketOptions(SocketOptions socketOptions) {
        this.config.withSocketOptions(socketOptions);
        return this;
    }

    public AwsIotMqtt5ClientBuilder withHttpProxyOptions(HttpProxyOptions httpProxyOptions) {
        this.config.withHttpProxyOptions(httpProxyOptions);
        return this;
    }

    public AwsIotMqtt5ClientBuilder withExtendedValidationAndFlowControlOptions(Mqtt5ClientOptions.ExtendedValidationAndFlowControlOptions extendedValidationAndFlowControlOptions) {
        this.config.withExtendedValidationAndFlowControlOptions(extendedValidationAndFlowControlOptions);
        return this;
    }

    public AwsIotMqtt5ClientBuilder withLifeCycleEvents(Mqtt5ClientOptions.LifecycleEvents lifecycleEvents) {
        this.config.withLifecycleEvents(lifecycleEvents);
        return this;
    }

    public AwsIotMqtt5ClientBuilder withPublishEvents(Mqtt5ClientOptions.PublishEvents publishEvents) {
        this.config.withPublishEvents(publishEvents);
        return this;
    }

    public AwsIotMqtt5ClientBuilder withTopicAliasingOptions(TopicAliasingOptions options) {
        this.config.withTopicAliasingOptions(options);
        return this;
    }

    public Mqtt5Client build() {
        if (this.configTls == null) {
            this.configTls = TlsContextOptions.createDefaultClient();
            this.addReferenceTo((CrtResource)this.configTls);
            this.configTls.close();
        }
        TlsContext tlsContext = new TlsContext(this.configTls);
        this.config.withTlsContext(tlsContext);
        this.addReferenceTo((CrtResource)tlsContext);
        tlsContext.close();
        try {
            this.configConnect.withUsername(this.buildMqtt5FinalUsername(this.configCustomAuth));
            if (this.configCustomAuth != null && this.configCustomAuth.password != null) {
                this.configConnect.withPassword(this.configCustomAuth.password);
            }
        }
        catch (Exception ex) {
            System.out.println("Error - exception occurred while building MQTT5 client options builder: " + ex.toString());
            ex.printStackTrace();
            return null;
        }
        this.config.withConnectOptions(this.configConnect.build());
        Mqtt5Client returnClient = new Mqtt5Client(this.config.build());
        returnClient.addReferenceTo((CrtResource)this.configTls);
        return returnClient;
    }

    public static String extractRegionFromEndpoint(String endpoint) throws Exception {
        Pattern regexPattern = Pattern.compile("^[\\w\\-]+\\.[\\w\\-]+\\.([\\w+\\-]+)\\.");
        Matcher regexMatcher = regexPattern.matcher(endpoint);
        try {
            String result;
            if (regexMatcher.find() && (result = regexMatcher.group(1)) != null) {
                return result;
            }
        }
        catch (Exception ex) {
            throw new Exception("AWS region could not be extracted from endpoint. Use 'region' property on WebsocketConfig to set manually.");
        }
        throw new Exception("AWS region could not be extracted from endpoint. Use 'region' property on WebsocketConfig to set manually.");
    }

    private void addToUsernameParam(List<String> paramList, String paramName, String paramValue) {
        if (paramValue != null) {
            paramList.add(paramName);
            paramList.add(paramValue);
        }
    }

    private String formUsernameFromParam(List<String> paramList) throws Exception {
        boolean firstAddition = true;
        boolean useAmp = false;
        String result = "";
        if (paramList.size() == 0) {
            return result;
        }
        if (paramList.size() % 2 != 0) {
            throw new Exception("Username parameters are not an even number!");
        }
        for (int i = 0; i < paramList.size(); ++i) {
            String key = paramList.get(i);
            String value = paramList.get(i + 1);
            if (firstAddition) {
                firstAddition = false;
            } else if (!useAmp) {
                result = result + "?";
                useAmp = true;
            } else {
                result = result + "&";
            }
            if (key != null && value != null) {
                result = result + key + "=" + value;
            } else if (value != null) {
                result = result + value;
            }
            ++i;
        }
        return result;
    }

    private String buildMqtt5FinalUsername(MqttConnectCustomAuthConfig config) throws Exception {
        ArrayList<String> paramList = new ArrayList<String>();
        if (config != null) {
            String username;
            boolean usingSigning = false;
            if (config.tokenValue != null || config.tokenKeyName != null || config.tokenSignature != null) {
                if (config.tokenValue == null || config.tokenKeyName == null || config.tokenSignature == null) {
                    throw new Exception("Token-based custom authentication requires all token-related properties to be set");
                }
                usingSigning = true;
            }
            if ((username = config.username) != null) {
                if (username.contains("?")) {
                    String[] questionSplit = username.split("?");
                    if (questionSplit.length > 1) {
                        throw new Exception("Custom auth username property value is invalid");
                    }
                    this.addToUsernameParam(paramList, null, questionSplit[0]);
                    if (questionSplit[1].contains("&")) {
                        String[] ampSplit = questionSplit[1].split("&");
                        for (int i = 0; i < ampSplit.length; ++i) {
                            String[] keyValueSplit = ampSplit[i].split("=");
                            if (keyValueSplit.length != 1) continue;
                            this.addToUsernameParam(paramList, keyValueSplit[0], keyValueSplit[1]);
                        }
                    } else {
                        String[] keyValueSplit = questionSplit[1].split("=");
                        if (keyValueSplit.length == 1) {
                            this.addToUsernameParam(paramList, keyValueSplit[0], keyValueSplit[1]);
                        }
                    }
                } else {
                    this.addToUsernameParam(paramList, null, username);
                }
            }
            this.addToUsernameParam(paramList, "x-amz-customauthorizer-name", config.authorizerName);
            if (usingSigning) {
                this.addToUsernameParam(paramList, config.tokenKeyName, config.tokenValue);
                String encodedSignature = config.tokenSignature;
                if (!encodedSignature.contains("%")) {
                    encodedSignature = URLEncoder.encode(encodedSignature, StandardCharsets.UTF_8.toString());
                }
                this.addToUsernameParam(paramList, "x-amz-customauthorizer-signature", encodedSignature);
            }
        }
        if (CRT.getOSIdentifier() == "android") {
            this.addToUsernameParam(paramList, "SDK", "AndroidV2");
        } else {
            this.addToUsernameParam(paramList, "SDK", "JavaV2");
        }
        this.addToUsernameParam(paramList, "Version", new PackageInfo().version.toString());
        return this.formUsernameFromParam(paramList);
    }

    public static final class MqttConnectCustomAuthConfig {
        public String authorizerName;
        public String username;
        public byte[] password;
        public String tokenKeyName;
        public String tokenValue;
        public String tokenSignature;
    }

    public static final class WebsocketSigv4Config {
        public CredentialsProvider credentialsProvider;
        public String region;
    }
}

