/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.iot;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.auth.signing.AwsSigner;
import software.amazon.awssdk.crt.auth.signing.AwsSigningConfig;
import software.amazon.awssdk.crt.http.HttpRequest;
import software.amazon.awssdk.crt.mqtt5.Mqtt5WebsocketHandshakeTransformArgs;

public class AwsMqtt5Sigv4HandshakeTransformer
extends CrtResource
implements Consumer<Mqtt5WebsocketHandshakeTransformArgs> {
    AwsSigningConfig signingConfig;

    public AwsMqtt5Sigv4HandshakeTransformer(AwsSigningConfig signingConfig) {
        this.addReferenceTo((CrtResource)signingConfig);
        this.signingConfig = signingConfig;
    }

    protected void releaseNativeHandle() {
    }

    protected boolean canReleaseReferencesImmediately() {
        return true;
    }

    @Override
    public void accept(Mqtt5WebsocketHandshakeTransformArgs handshakeArgs) {
        try (AwsSigningConfig config = this.signingConfig.clone();){
            config.setTime(System.currentTimeMillis());
            CompletableFuture signingFuture = AwsSigner.signRequest((HttpRequest)handshakeArgs.getHttpRequest(), (AwsSigningConfig)config);
            signingFuture.whenComplete((request, error) -> {
                if (error != null) {
                    handshakeArgs.completeExceptionally(error);
                } else {
                    handshakeArgs.complete(request);
                }
            });
        }
    }
}

