/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.iot;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import software.amazon.awssdk.iot.iotshadow.model.ShadowState;

public class ShadowStateFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        Class rawType = type.getRawType();
        if (rawType != ShadowState.class) {
            return null;
        }
        final TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
        return new TypeAdapter<T>(){

            public void write(JsonWriter out, T shadowValue) throws IOException {
                ShadowState shadow = (ShadowState)shadowValue;
                if (shadow.desiredIsNullable || shadow.reportedIsNullable) {
                    out.setSerializeNulls(true);
                    if (shadow.desired == null && !shadow.desiredIsNullable) {
                        shadow.desired = new HashMap();
                    }
                    if (shadow.reported == null && !shadow.reportedIsNullable) {
                        shadow.reported = new HashMap();
                    }
                    delegate.write(out, shadowValue);
                    out.setSerializeNulls(false);
                } else {
                    delegate.write(out, shadowValue);
                }
            }

            public T read(JsonReader in) throws IOException {
                Object returnType = delegate.read(in);
                return returnType;
            }
        };
    }
}

