/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.iot;

import java.util.function.Consumer;
import software.amazon.awssdk.crt.iot.SubscriptionStatusEvent;
import software.amazon.awssdk.iot.V2DeserializationFailureEvent;

public class V2ClientStreamOptions<T> {
    private Consumer<T> streamEventHandler;
    private Consumer<SubscriptionStatusEvent> subscriptionEventHandler;
    private Consumer<V2DeserializationFailureEvent> deserializationFailureHandler;

    private V2ClientStreamOptions() {
    }

    private V2ClientStreamOptions(V2ClientStreamOptions<T> options) {
        this.streamEventHandler = options.streamEventHandler != null ? options.streamEventHandler : event -> {};
        this.subscriptionEventHandler = options.subscriptionEventHandler != null ? options.subscriptionEventHandler : event -> {};
        this.deserializationFailureHandler = options.deserializationFailureHandler != null ? options.deserializationFailureHandler : failure -> {};
    }

    public static <T> V2ClientStreamOptionsBuilder<T> builder() {
        return new V2ClientStreamOptionsBuilder();
    }

    public Consumer<T> streamEventHandler() {
        return this.streamEventHandler;
    }

    public Consumer<SubscriptionStatusEvent> subscriptionEventHandler() {
        return this.subscriptionEventHandler;
    }

    public Consumer<V2DeserializationFailureEvent> deserializationFailureHandler() {
        return this.deserializationFailureHandler;
    }

    public static class V2ClientStreamOptionsBuilder<T> {
        private V2ClientStreamOptions<T> options = new V2ClientStreamOptions();

        private V2ClientStreamOptionsBuilder() {
        }

        public V2ClientStreamOptionsBuilder<T> withStreamEventHandler(Consumer<T> streamEventHandler) {
            ((V2ClientStreamOptions)this.options).streamEventHandler = streamEventHandler;
            return this;
        }

        public V2ClientStreamOptionsBuilder<T> withDeserializationFailureHandler(Consumer<V2DeserializationFailureEvent> deserializationFailureHandler) {
            ((V2ClientStreamOptions)this.options).deserializationFailureHandler = deserializationFailureHandler;
            return this;
        }

        public V2ClientStreamOptionsBuilder<T> withSubscriptionEventHandler(Consumer<SubscriptionStatusEvent> subscriptionEventHandler) {
            ((V2ClientStreamOptions)this.options).subscriptionEventHandler = subscriptionEventHandler;
            return this;
        }

        public V2ClientStreamOptions<T> build() {
            return new V2ClientStreamOptions(this.options);
        }
    }
}

