/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.iot.discovery;

import java.util.concurrent.ExecutorService;
import software.amazon.awssdk.crt.http.HttpProxyOptions;
import software.amazon.awssdk.crt.io.ClientBootstrap;
import software.amazon.awssdk.crt.io.SocketOptions;
import software.amazon.awssdk.crt.io.TlsContext;
import software.amazon.awssdk.crt.io.TlsContextOptions;

public class DiscoveryClientConfig
implements AutoCloseable {
    private final ClientBootstrap bootstrap;
    private final TlsContext tlsContext;
    private final SocketOptions socketOptions;
    private final String region;
    private final int maxConnections;
    private final HttpProxyOptions proxyOptions;
    private final String ggServerName;
    private ExecutorService discoveryExecutor;

    public DiscoveryClientConfig(ClientBootstrap bootstrap, TlsContextOptions tlsContextOptions, SocketOptions socketOptions, String region, int maxConnections, HttpProxyOptions proxyOptions) {
        this.bootstrap = bootstrap;
        this.tlsContext = new TlsContext(tlsContextOptions);
        this.socketOptions = socketOptions;
        this.region = region;
        this.maxConnections = maxConnections;
        this.proxyOptions = proxyOptions;
        this.ggServerName = "";
        this.discoveryExecutor = null;
    }

    public DiscoveryClientConfig(TlsContextOptions tlsContextOptions, SocketOptions socketOptions, String region, int maxConnections, HttpProxyOptions proxyOptions) {
        this(ClientBootstrap.getOrCreateStaticDefault(), tlsContextOptions, socketOptions, region, maxConnections, proxyOptions);
    }

    public DiscoveryClientConfig(ClientBootstrap bootstrap, TlsContextOptions tlsContextOptions, SocketOptions socketOptions, int maxConnections, HttpProxyOptions proxyOptions, String ggServerName) {
        this.bootstrap = bootstrap;
        this.tlsContext = new TlsContext(tlsContextOptions);
        this.socketOptions = socketOptions;
        this.region = "";
        this.maxConnections = maxConnections;
        this.proxyOptions = proxyOptions;
        this.ggServerName = ggServerName;
        this.discoveryExecutor = null;
    }

    public DiscoveryClientConfig(TlsContextOptions tlsContextOptions, SocketOptions socketOptions, int maxConnections, HttpProxyOptions proxyOptions, String ggServerName) {
        this(ClientBootstrap.getOrCreateStaticDefault(), tlsContextOptions, socketOptions, maxConnections, proxyOptions, ggServerName);
    }

    public ClientBootstrap getBootstrap() {
        return this.bootstrap;
    }

    public TlsContext getTlsContext() {
        return this.tlsContext;
    }

    public SocketOptions getSocketOptions() {
        return this.socketOptions;
    }

    public String getRegion() {
        return this.region;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public HttpProxyOptions getProxyOptions() {
        return this.proxyOptions;
    }

    public String getGGServerName() {
        return this.ggServerName;
    }

    public ExecutorService getDiscoveryExecutor() {
        return this.discoveryExecutor;
    }

    public DiscoveryClientConfig setDiscoveryExecutor(ExecutorService override) {
        this.discoveryExecutor = override;
        return this;
    }

    @Override
    public void close() {
        if (this.tlsContext != null) {
            this.tlsContext.close();
        }
    }
}

