/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.iot.iotjobs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.iot.MqttRequestResponse;
import software.amazon.awssdk.crt.iot.MqttRequestResponseClient;
import software.amazon.awssdk.crt.iot.MqttRequestResponseClientOptions;
import software.amazon.awssdk.crt.iot.RequestResponseOperation;
import software.amazon.awssdk.crt.iot.ResponsePath;
import software.amazon.awssdk.crt.iot.StreamingOperation;
import software.amazon.awssdk.crt.iot.StreamingOperationOptions;
import software.amazon.awssdk.crt.mqtt.MqttClientConnection;
import software.amazon.awssdk.crt.mqtt5.Mqtt5Client;
import software.amazon.awssdk.iot.EnumSerializer;
import software.amazon.awssdk.iot.Timestamp;
import software.amazon.awssdk.iot.V2ClientFuture;
import software.amazon.awssdk.iot.V2ClientStreamOptions;
import software.amazon.awssdk.iot.V2DeserializationFailureEvent;
import software.amazon.awssdk.iot.iotjobs.model.DescribeJobExecutionRequest;
import software.amazon.awssdk.iot.iotjobs.model.DescribeJobExecutionResponse;
import software.amazon.awssdk.iot.iotjobs.model.GetPendingJobExecutionsRequest;
import software.amazon.awssdk.iot.iotjobs.model.GetPendingJobExecutionsResponse;
import software.amazon.awssdk.iot.iotjobs.model.JobExecutionsChangedEvent;
import software.amazon.awssdk.iot.iotjobs.model.JobExecutionsChangedSubscriptionRequest;
import software.amazon.awssdk.iot.iotjobs.model.JobStatus;
import software.amazon.awssdk.iot.iotjobs.model.NextJobExecutionChangedEvent;
import software.amazon.awssdk.iot.iotjobs.model.NextJobExecutionChangedSubscriptionRequest;
import software.amazon.awssdk.iot.iotjobs.model.RejectedErrorCode;
import software.amazon.awssdk.iot.iotjobs.model.StartNextJobExecutionResponse;
import software.amazon.awssdk.iot.iotjobs.model.StartNextPendingJobExecutionRequest;
import software.amazon.awssdk.iot.iotjobs.model.UpdateJobExecutionRequest;
import software.amazon.awssdk.iot.iotjobs.model.UpdateJobExecutionResponse;
import software.amazon.awssdk.iot.iotjobs.model.V2ErrorResponse;
import software.amazon.awssdk.iot.iotjobs.model.V2ErrorResponseException;

public class IotJobsV2Client
implements AutoCloseable {
    private MqttRequestResponseClient rrClient;
    private final Gson gson;

    private Gson createGson() {
        GsonBuilder gson = new GsonBuilder();
        gson.disableHtmlEscaping();
        gson.registerTypeAdapter(Timestamp.class, (Object)new Timestamp.Serializer());
        gson.registerTypeAdapter(Timestamp.class, (Object)new Timestamp.Deserializer());
        this.addTypeAdapters(gson);
        return gson.create();
    }

    private void addTypeAdapters(GsonBuilder gson) {
        gson.registerTypeAdapter(JobStatus.class, new EnumSerializer());
        gson.registerTypeAdapter(RejectedErrorCode.class, new EnumSerializer());
    }

    private IotJobsV2Client(MqttRequestResponseClient rrClient) {
        this.rrClient = rrClient;
        this.gson = this.createGson();
    }

    public static IotJobsV2Client newFromMqtt5(Mqtt5Client protocolClient, MqttRequestResponseClientOptions options) {
        MqttRequestResponseClient rrClient = new MqttRequestResponseClient(protocolClient, options);
        return new IotJobsV2Client(rrClient);
    }

    public static IotJobsV2Client newFromMqtt311(MqttClientConnection protocolClient, MqttRequestResponseClientOptions options) {
        MqttRequestResponseClient rrClient = new MqttRequestResponseClient(protocolClient, options);
        return new IotJobsV2Client(rrClient);
    }

    @Override
    public void close() {
        this.rrClient.decRef();
        this.rrClient = null;
    }

    public CompletableFuture<DescribeJobExecutionResponse> describeJobExecution(DescribeJobExecutionRequest request) {
        V2ClientFuture<DescribeJobExecutionResponse> responseFuture = new V2ClientFuture<DescribeJobExecutionResponse>();
        try {
            String correlationToken;
            if (request.thingName == null) {
                throw new CrtRuntimeException("DescribeJobExecutionRequest.thingName cannot be null");
            }
            if (request.jobId == null) {
                throw new CrtRuntimeException("DescribeJobExecutionRequest.jobId cannot be null");
            }
            RequestResponseOperation.RequestResponseOperationBuilder builder = RequestResponseOperation.builder();
            request.clientToken = correlationToken = UUID.randomUUID().toString();
            builder.withCorrelationToken(correlationToken);
            String publishTopic = "$aws/things/{thingName}/jobs/{jobId}/get";
            publishTopic = publishTopic.replace("{thingName}", request.thingName);
            publishTopic = publishTopic.replace("{jobId}", request.jobId);
            builder.withPublishTopic(publishTopic);
            String payloadJson = this.gson.toJson((Object)request);
            builder.withPayload(payloadJson.getBytes(StandardCharsets.UTF_8));
            String subscription0 = "$aws/things/{thingName}/jobs/{jobId}/get/+";
            subscription0 = subscription0.replace("{thingName}", request.thingName);
            subscription0 = subscription0.replace("{jobId}", request.jobId);
            builder.withSubscription(subscription0);
            ResponsePath.ResponsePathBuilder pathBuilder1 = ResponsePath.builder();
            String responseTopic1 = publishTopic + "/accepted";
            pathBuilder1.withResponseTopic(publishTopic + "/accepted");
            pathBuilder1.withCorrelationTokenJsonPath("clientToken");
            builder.withResponsePath(pathBuilder1.build());
            ResponsePath.ResponsePathBuilder pathBuilder2 = ResponsePath.builder();
            String responseTopic2 = publishTopic + "/rejected";
            pathBuilder2.withResponseTopic(publishTopic + "/rejected");
            pathBuilder2.withCorrelationTokenJsonPath("clientToken");
            builder.withResponsePath(pathBuilder2.build());
            this.submitOperation(responseFuture, builder.build(), responseTopic1, DescribeJobExecutionResponse.class, responseTopic2, V2ErrorResponse.class, IotJobsV2Client::createV2ErrorResponseException);
        }
        catch (Exception e) {
            responseFuture.completeExceptionally(IotJobsV2Client.createV2ErrorResponseException(e.getMessage(), null));
        }
        return responseFuture;
    }

    public CompletableFuture<GetPendingJobExecutionsResponse> getPendingJobExecutions(GetPendingJobExecutionsRequest request) {
        V2ClientFuture<GetPendingJobExecutionsResponse> responseFuture = new V2ClientFuture<GetPendingJobExecutionsResponse>();
        try {
            String correlationToken;
            if (request.thingName == null) {
                throw new CrtRuntimeException("GetPendingJobExecutionsRequest.thingName cannot be null");
            }
            RequestResponseOperation.RequestResponseOperationBuilder builder = RequestResponseOperation.builder();
            request.clientToken = correlationToken = UUID.randomUUID().toString();
            builder.withCorrelationToken(correlationToken);
            String publishTopic = "$aws/things/{thingName}/jobs/get";
            publishTopic = publishTopic.replace("{thingName}", request.thingName);
            builder.withPublishTopic(publishTopic);
            String payloadJson = this.gson.toJson((Object)request);
            builder.withPayload(payloadJson.getBytes(StandardCharsets.UTF_8));
            String subscription0 = "$aws/things/{thingName}/jobs/get/+";
            subscription0 = subscription0.replace("{thingName}", request.thingName);
            builder.withSubscription(subscription0);
            ResponsePath.ResponsePathBuilder pathBuilder1 = ResponsePath.builder();
            String responseTopic1 = publishTopic + "/accepted";
            pathBuilder1.withResponseTopic(publishTopic + "/accepted");
            pathBuilder1.withCorrelationTokenJsonPath("clientToken");
            builder.withResponsePath(pathBuilder1.build());
            ResponsePath.ResponsePathBuilder pathBuilder2 = ResponsePath.builder();
            String responseTopic2 = publishTopic + "/rejected";
            pathBuilder2.withResponseTopic(publishTopic + "/rejected");
            pathBuilder2.withCorrelationTokenJsonPath("clientToken");
            builder.withResponsePath(pathBuilder2.build());
            this.submitOperation(responseFuture, builder.build(), responseTopic1, GetPendingJobExecutionsResponse.class, responseTopic2, V2ErrorResponse.class, IotJobsV2Client::createV2ErrorResponseException);
        }
        catch (Exception e) {
            responseFuture.completeExceptionally(IotJobsV2Client.createV2ErrorResponseException(e.getMessage(), null));
        }
        return responseFuture;
    }

    public CompletableFuture<StartNextJobExecutionResponse> startNextPendingJobExecution(StartNextPendingJobExecutionRequest request) {
        V2ClientFuture<StartNextJobExecutionResponse> responseFuture = new V2ClientFuture<StartNextJobExecutionResponse>();
        try {
            String correlationToken;
            if (request.thingName == null) {
                throw new CrtRuntimeException("StartNextPendingJobExecutionRequest.thingName cannot be null");
            }
            RequestResponseOperation.RequestResponseOperationBuilder builder = RequestResponseOperation.builder();
            request.clientToken = correlationToken = UUID.randomUUID().toString();
            builder.withCorrelationToken(correlationToken);
            String publishTopic = "$aws/things/{thingName}/jobs/start-next";
            publishTopic = publishTopic.replace("{thingName}", request.thingName);
            builder.withPublishTopic(publishTopic);
            String payloadJson = this.gson.toJson((Object)request);
            builder.withPayload(payloadJson.getBytes(StandardCharsets.UTF_8));
            String subscription0 = "$aws/things/{thingName}/jobs/start-next/+";
            subscription0 = subscription0.replace("{thingName}", request.thingName);
            builder.withSubscription(subscription0);
            ResponsePath.ResponsePathBuilder pathBuilder1 = ResponsePath.builder();
            String responseTopic1 = publishTopic + "/accepted";
            pathBuilder1.withResponseTopic(publishTopic + "/accepted");
            pathBuilder1.withCorrelationTokenJsonPath("clientToken");
            builder.withResponsePath(pathBuilder1.build());
            ResponsePath.ResponsePathBuilder pathBuilder2 = ResponsePath.builder();
            String responseTopic2 = publishTopic + "/rejected";
            pathBuilder2.withResponseTopic(publishTopic + "/rejected");
            pathBuilder2.withCorrelationTokenJsonPath("clientToken");
            builder.withResponsePath(pathBuilder2.build());
            this.submitOperation(responseFuture, builder.build(), responseTopic1, StartNextJobExecutionResponse.class, responseTopic2, V2ErrorResponse.class, IotJobsV2Client::createV2ErrorResponseException);
        }
        catch (Exception e) {
            responseFuture.completeExceptionally(IotJobsV2Client.createV2ErrorResponseException(e.getMessage(), null));
        }
        return responseFuture;
    }

    public CompletableFuture<UpdateJobExecutionResponse> updateJobExecution(UpdateJobExecutionRequest request) {
        V2ClientFuture<UpdateJobExecutionResponse> responseFuture = new V2ClientFuture<UpdateJobExecutionResponse>();
        try {
            String correlationToken;
            if (request.thingName == null) {
                throw new CrtRuntimeException("UpdateJobExecutionRequest.thingName cannot be null");
            }
            if (request.jobId == null) {
                throw new CrtRuntimeException("UpdateJobExecutionRequest.jobId cannot be null");
            }
            RequestResponseOperation.RequestResponseOperationBuilder builder = RequestResponseOperation.builder();
            request.clientToken = correlationToken = UUID.randomUUID().toString();
            builder.withCorrelationToken(correlationToken);
            String publishTopic = "$aws/things/{thingName}/jobs/{jobId}/update";
            publishTopic = publishTopic.replace("{thingName}", request.thingName);
            publishTopic = publishTopic.replace("{jobId}", request.jobId);
            builder.withPublishTopic(publishTopic);
            String payloadJson = this.gson.toJson((Object)request);
            builder.withPayload(payloadJson.getBytes(StandardCharsets.UTF_8));
            String subscription0 = "$aws/things/{thingName}/jobs/{jobId}/update/+";
            subscription0 = subscription0.replace("{thingName}", request.thingName);
            subscription0 = subscription0.replace("{jobId}", request.jobId);
            builder.withSubscription(subscription0);
            ResponsePath.ResponsePathBuilder pathBuilder1 = ResponsePath.builder();
            String responseTopic1 = publishTopic + "/accepted";
            pathBuilder1.withResponseTopic(publishTopic + "/accepted");
            pathBuilder1.withCorrelationTokenJsonPath("clientToken");
            builder.withResponsePath(pathBuilder1.build());
            ResponsePath.ResponsePathBuilder pathBuilder2 = ResponsePath.builder();
            String responseTopic2 = publishTopic + "/rejected";
            pathBuilder2.withResponseTopic(publishTopic + "/rejected");
            pathBuilder2.withCorrelationTokenJsonPath("clientToken");
            builder.withResponsePath(pathBuilder2.build());
            this.submitOperation(responseFuture, builder.build(), responseTopic1, UpdateJobExecutionResponse.class, responseTopic2, V2ErrorResponse.class, IotJobsV2Client::createV2ErrorResponseException);
        }
        catch (Exception e) {
            responseFuture.completeExceptionally(IotJobsV2Client.createV2ErrorResponseException(e.getMessage(), null));
        }
        return responseFuture;
    }

    public StreamingOperation createJobExecutionsChangedStream(JobExecutionsChangedSubscriptionRequest request, V2ClientStreamOptions<JobExecutionsChangedEvent> options) {
        String topic = "$aws/things/{thingName}/jobs/notify";
        if (request.thingName == null) {
            throw new CrtRuntimeException("JobExecutionsChangedSubscriptionRequest.thingName cannot be null");
        }
        topic = topic.replace("{thingName}", request.thingName);
        StreamingOperationOptions innerOptions = StreamingOperationOptions.builder().withTopic(topic).withSubscriptionStatusEventCallback(options.subscriptionEventHandler()).withIncomingPublishEventCallback(event -> {
            try {
                String payload = new String(event.getPayload(), StandardCharsets.UTF_8);
                JobExecutionsChangedEvent response = (JobExecutionsChangedEvent)this.gson.fromJson(payload, JobExecutionsChangedEvent.class);
                options.streamEventHandler().accept(response);
            }
            catch (Exception e) {
                V2DeserializationFailureEvent failureEvent = V2DeserializationFailureEvent.builder().withCause(e).withPayload(event.getPayload()).withTopic(event.getTopic()).build();
                options.deserializationFailureHandler().accept(failureEvent);
            }
        }).build();
        return this.rrClient.createStream(innerOptions);
    }

    public StreamingOperation createNextJobExecutionChangedStream(NextJobExecutionChangedSubscriptionRequest request, V2ClientStreamOptions<NextJobExecutionChangedEvent> options) {
        String topic = "$aws/things/{thingName}/jobs/notify-next";
        if (request.thingName == null) {
            throw new CrtRuntimeException("NextJobExecutionChangedSubscriptionRequest.thingName cannot be null");
        }
        topic = topic.replace("{thingName}", request.thingName);
        StreamingOperationOptions innerOptions = StreamingOperationOptions.builder().withTopic(topic).withSubscriptionStatusEventCallback(options.subscriptionEventHandler()).withIncomingPublishEventCallback(event -> {
            try {
                String payload = new String(event.getPayload(), StandardCharsets.UTF_8);
                NextJobExecutionChangedEvent response = (NextJobExecutionChangedEvent)this.gson.fromJson(payload, NextJobExecutionChangedEvent.class);
                options.streamEventHandler().accept(response);
            }
            catch (Exception e) {
                V2DeserializationFailureEvent failureEvent = V2DeserializationFailureEvent.builder().withCause(e).withPayload(event.getPayload()).withTopic(event.getTopic()).build();
                options.deserializationFailureHandler().accept(failureEvent);
            }
        }).build();
        return this.rrClient.createStream(innerOptions);
    }

    private static Throwable createV2ErrorResponseException(String message, V2ErrorResponse errorResponse) {
        return new V2ErrorResponseException(message, errorResponse);
    }

    private <T, E> void submitOperation(V2ClientFuture<T> finalFuture, RequestResponseOperation operation, String responseTopic, Class<T> responseClass, String errorTopic, Class<E> errorClass, BiFunction<String, E, Throwable> exceptionFactory) {
        try {
            CompletableFuture responseFuture = this.rrClient.submitRequest(operation);
            CompletionStage compositeFuture = responseFuture.whenComplete((res, ex) -> {
                if (ex != null) {
                    finalFuture.completeExceptionally((Throwable)exceptionFactory.apply(ex.getMessage(), null));
                } else if (res.getTopic().equals(responseTopic)) {
                    try {
                        String payload = new String(res.getPayload(), StandardCharsets.UTF_8);
                        Object response = this.gson.fromJson(payload, responseClass);
                        finalFuture.complete(response);
                    }
                    catch (Exception e) {
                        finalFuture.completeExceptionally((Throwable)exceptionFactory.apply(e.getMessage(), null));
                    }
                } else if (res.getTopic().equals(errorTopic)) {
                    try {
                        String payload = new String(res.getPayload(), StandardCharsets.UTF_8);
                        Object error = this.gson.fromJson(payload, errorClass);
                        finalFuture.completeExceptionally((Throwable)exceptionFactory.apply("Request-response operation failure", error));
                    }
                    catch (Exception e) {
                        finalFuture.completeExceptionally((Throwable)exceptionFactory.apply(e.getMessage(), null));
                    }
                } else {
                    finalFuture.completeExceptionally((Throwable)exceptionFactory.apply("Request-response operation completed on unknown topic: " + res.getTopic(), null));
                }
            });
            finalFuture.setTriggeringFuture((CompletableFuture<MqttRequestResponse>)compositeFuture);
        }
        catch (Exception ex2) {
            finalFuture.completeExceptionally(exceptionFactory.apply(ex2.getMessage(), null));
        }
    }
}

