/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.iot.iotshadow;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.iot.MqttRequestResponse;
import software.amazon.awssdk.crt.iot.MqttRequestResponseClient;
import software.amazon.awssdk.crt.iot.MqttRequestResponseClientOptions;
import software.amazon.awssdk.crt.iot.RequestResponseOperation;
import software.amazon.awssdk.crt.iot.ResponsePath;
import software.amazon.awssdk.crt.iot.StreamingOperation;
import software.amazon.awssdk.crt.iot.StreamingOperationOptions;
import software.amazon.awssdk.crt.mqtt.MqttClientConnection;
import software.amazon.awssdk.crt.mqtt5.Mqtt5Client;
import software.amazon.awssdk.iot.ShadowStateFactory;
import software.amazon.awssdk.iot.Timestamp;
import software.amazon.awssdk.iot.V2ClientFuture;
import software.amazon.awssdk.iot.V2ClientStreamOptions;
import software.amazon.awssdk.iot.V2DeserializationFailureEvent;
import software.amazon.awssdk.iot.iotshadow.model.DeleteNamedShadowRequest;
import software.amazon.awssdk.iot.iotshadow.model.DeleteShadowRequest;
import software.amazon.awssdk.iot.iotshadow.model.DeleteShadowResponse;
import software.amazon.awssdk.iot.iotshadow.model.GetNamedShadowRequest;
import software.amazon.awssdk.iot.iotshadow.model.GetShadowRequest;
import software.amazon.awssdk.iot.iotshadow.model.GetShadowResponse;
import software.amazon.awssdk.iot.iotshadow.model.NamedShadowDeltaUpdatedSubscriptionRequest;
import software.amazon.awssdk.iot.iotshadow.model.NamedShadowUpdatedSubscriptionRequest;
import software.amazon.awssdk.iot.iotshadow.model.ShadowDeltaUpdatedEvent;
import software.amazon.awssdk.iot.iotshadow.model.ShadowDeltaUpdatedSubscriptionRequest;
import software.amazon.awssdk.iot.iotshadow.model.ShadowUpdatedEvent;
import software.amazon.awssdk.iot.iotshadow.model.ShadowUpdatedSubscriptionRequest;
import software.amazon.awssdk.iot.iotshadow.model.UpdateNamedShadowRequest;
import software.amazon.awssdk.iot.iotshadow.model.UpdateShadowRequest;
import software.amazon.awssdk.iot.iotshadow.model.UpdateShadowResponse;
import software.amazon.awssdk.iot.iotshadow.model.V2ErrorResponse;
import software.amazon.awssdk.iot.iotshadow.model.V2ErrorResponseException;

public class IotShadowV2Client
implements AutoCloseable {
    private MqttRequestResponseClient rrClient;
    private final Gson gson;

    private Gson createGson() {
        GsonBuilder gson = new GsonBuilder();
        gson.disableHtmlEscaping();
        gson.registerTypeAdapter(Timestamp.class, (Object)new Timestamp.Serializer());
        gson.registerTypeAdapter(Timestamp.class, (Object)new Timestamp.Deserializer());
        this.addTypeAdapters(gson);
        return gson.create();
    }

    private void addTypeAdapters(GsonBuilder gson) {
        ShadowStateFactory shadowStateFactory = new ShadowStateFactory();
        gson.registerTypeAdapterFactory((TypeAdapterFactory)shadowStateFactory);
    }

    private IotShadowV2Client(MqttRequestResponseClient rrClient) {
        this.rrClient = rrClient;
        this.gson = this.createGson();
    }

    public static IotShadowV2Client newFromMqtt5(Mqtt5Client protocolClient, MqttRequestResponseClientOptions options) {
        MqttRequestResponseClient rrClient = new MqttRequestResponseClient(protocolClient, options);
        return new IotShadowV2Client(rrClient);
    }

    public static IotShadowV2Client newFromMqtt311(MqttClientConnection protocolClient, MqttRequestResponseClientOptions options) {
        MqttRequestResponseClient rrClient = new MqttRequestResponseClient(protocolClient, options);
        return new IotShadowV2Client(rrClient);
    }

    @Override
    public void close() {
        this.rrClient.decRef();
        this.rrClient = null;
    }

    public CompletableFuture<DeleteShadowResponse> deleteNamedShadow(DeleteNamedShadowRequest request) {
        V2ClientFuture<DeleteShadowResponse> responseFuture = new V2ClientFuture<DeleteShadowResponse>();
        try {
            String correlationToken;
            if (request.thingName == null) {
                throw new CrtRuntimeException("DeleteNamedShadowRequest.thingName cannot be null");
            }
            if (request.shadowName == null) {
                throw new CrtRuntimeException("DeleteNamedShadowRequest.shadowName cannot be null");
            }
            RequestResponseOperation.RequestResponseOperationBuilder builder = RequestResponseOperation.builder();
            request.clientToken = correlationToken = UUID.randomUUID().toString();
            builder.withCorrelationToken(correlationToken);
            String publishTopic = "$aws/things/{thingName}/shadow/name/{shadowName}/delete";
            publishTopic = publishTopic.replace("{thingName}", request.thingName);
            publishTopic = publishTopic.replace("{shadowName}", request.shadowName);
            builder.withPublishTopic(publishTopic);
            String payloadJson = this.gson.toJson((Object)request);
            builder.withPayload(payloadJson.getBytes(StandardCharsets.UTF_8));
            String subscription0 = "$aws/things/{thingName}/shadow/name/{shadowName}/delete/+";
            subscription0 = subscription0.replace("{thingName}", request.thingName);
            subscription0 = subscription0.replace("{shadowName}", request.shadowName);
            builder.withSubscription(subscription0);
            ResponsePath.ResponsePathBuilder pathBuilder1 = ResponsePath.builder();
            String responseTopic1 = publishTopic + "/accepted";
            pathBuilder1.withResponseTopic(publishTopic + "/accepted");
            pathBuilder1.withCorrelationTokenJsonPath("clientToken");
            builder.withResponsePath(pathBuilder1.build());
            ResponsePath.ResponsePathBuilder pathBuilder2 = ResponsePath.builder();
            String responseTopic2 = publishTopic + "/rejected";
            pathBuilder2.withResponseTopic(publishTopic + "/rejected");
            pathBuilder2.withCorrelationTokenJsonPath("clientToken");
            builder.withResponsePath(pathBuilder2.build());
            this.submitOperation(responseFuture, builder.build(), responseTopic1, DeleteShadowResponse.class, responseTopic2, V2ErrorResponse.class, IotShadowV2Client::createV2ErrorResponseException);
        }
        catch (Exception e) {
            responseFuture.completeExceptionally(IotShadowV2Client.createV2ErrorResponseException(e.getMessage(), null));
        }
        return responseFuture;
    }

    public CompletableFuture<DeleteShadowResponse> deleteShadow(DeleteShadowRequest request) {
        V2ClientFuture<DeleteShadowResponse> responseFuture = new V2ClientFuture<DeleteShadowResponse>();
        try {
            String correlationToken;
            if (request.thingName == null) {
                throw new CrtRuntimeException("DeleteShadowRequest.thingName cannot be null");
            }
            RequestResponseOperation.RequestResponseOperationBuilder builder = RequestResponseOperation.builder();
            request.clientToken = correlationToken = UUID.randomUUID().toString();
            builder.withCorrelationToken(correlationToken);
            String publishTopic = "$aws/things/{thingName}/shadow/delete";
            publishTopic = publishTopic.replace("{thingName}", request.thingName);
            builder.withPublishTopic(publishTopic);
            String payloadJson = this.gson.toJson((Object)request);
            builder.withPayload(payloadJson.getBytes(StandardCharsets.UTF_8));
            String subscription0 = "$aws/things/{thingName}/shadow/delete/+";
            subscription0 = subscription0.replace("{thingName}", request.thingName);
            builder.withSubscription(subscription0);
            ResponsePath.ResponsePathBuilder pathBuilder1 = ResponsePath.builder();
            String responseTopic1 = publishTopic + "/accepted";
            pathBuilder1.withResponseTopic(publishTopic + "/accepted");
            pathBuilder1.withCorrelationTokenJsonPath("clientToken");
            builder.withResponsePath(pathBuilder1.build());
            ResponsePath.ResponsePathBuilder pathBuilder2 = ResponsePath.builder();
            String responseTopic2 = publishTopic + "/rejected";
            pathBuilder2.withResponseTopic(publishTopic + "/rejected");
            pathBuilder2.withCorrelationTokenJsonPath("clientToken");
            builder.withResponsePath(pathBuilder2.build());
            this.submitOperation(responseFuture, builder.build(), responseTopic1, DeleteShadowResponse.class, responseTopic2, V2ErrorResponse.class, IotShadowV2Client::createV2ErrorResponseException);
        }
        catch (Exception e) {
            responseFuture.completeExceptionally(IotShadowV2Client.createV2ErrorResponseException(e.getMessage(), null));
        }
        return responseFuture;
    }

    public CompletableFuture<GetShadowResponse> getNamedShadow(GetNamedShadowRequest request) {
        V2ClientFuture<GetShadowResponse> responseFuture = new V2ClientFuture<GetShadowResponse>();
        try {
            String correlationToken;
            if (request.thingName == null) {
                throw new CrtRuntimeException("GetNamedShadowRequest.thingName cannot be null");
            }
            if (request.shadowName == null) {
                throw new CrtRuntimeException("GetNamedShadowRequest.shadowName cannot be null");
            }
            RequestResponseOperation.RequestResponseOperationBuilder builder = RequestResponseOperation.builder();
            request.clientToken = correlationToken = UUID.randomUUID().toString();
            builder.withCorrelationToken(correlationToken);
            String publishTopic = "$aws/things/{thingName}/shadow/name/{shadowName}/get";
            publishTopic = publishTopic.replace("{thingName}", request.thingName);
            publishTopic = publishTopic.replace("{shadowName}", request.shadowName);
            builder.withPublishTopic(publishTopic);
            String payloadJson = this.gson.toJson((Object)request);
            builder.withPayload(payloadJson.getBytes(StandardCharsets.UTF_8));
            String subscription0 = "$aws/things/{thingName}/shadow/name/{shadowName}/get/+";
            subscription0 = subscription0.replace("{thingName}", request.thingName);
            subscription0 = subscription0.replace("{shadowName}", request.shadowName);
            builder.withSubscription(subscription0);
            ResponsePath.ResponsePathBuilder pathBuilder1 = ResponsePath.builder();
            String responseTopic1 = publishTopic + "/accepted";
            pathBuilder1.withResponseTopic(publishTopic + "/accepted");
            pathBuilder1.withCorrelationTokenJsonPath("clientToken");
            builder.withResponsePath(pathBuilder1.build());
            ResponsePath.ResponsePathBuilder pathBuilder2 = ResponsePath.builder();
            String responseTopic2 = publishTopic + "/rejected";
            pathBuilder2.withResponseTopic(publishTopic + "/rejected");
            pathBuilder2.withCorrelationTokenJsonPath("clientToken");
            builder.withResponsePath(pathBuilder2.build());
            this.submitOperation(responseFuture, builder.build(), responseTopic1, GetShadowResponse.class, responseTopic2, V2ErrorResponse.class, IotShadowV2Client::createV2ErrorResponseException);
        }
        catch (Exception e) {
            responseFuture.completeExceptionally(IotShadowV2Client.createV2ErrorResponseException(e.getMessage(), null));
        }
        return responseFuture;
    }

    public CompletableFuture<GetShadowResponse> getShadow(GetShadowRequest request) {
        V2ClientFuture<GetShadowResponse> responseFuture = new V2ClientFuture<GetShadowResponse>();
        try {
            String correlationToken;
            if (request.thingName == null) {
                throw new CrtRuntimeException("GetShadowRequest.thingName cannot be null");
            }
            RequestResponseOperation.RequestResponseOperationBuilder builder = RequestResponseOperation.builder();
            request.clientToken = correlationToken = UUID.randomUUID().toString();
            builder.withCorrelationToken(correlationToken);
            String publishTopic = "$aws/things/{thingName}/shadow/get";
            publishTopic = publishTopic.replace("{thingName}", request.thingName);
            builder.withPublishTopic(publishTopic);
            String payloadJson = this.gson.toJson((Object)request);
            builder.withPayload(payloadJson.getBytes(StandardCharsets.UTF_8));
            String subscription0 = "$aws/things/{thingName}/shadow/get/+";
            subscription0 = subscription0.replace("{thingName}", request.thingName);
            builder.withSubscription(subscription0);
            ResponsePath.ResponsePathBuilder pathBuilder1 = ResponsePath.builder();
            String responseTopic1 = publishTopic + "/accepted";
            pathBuilder1.withResponseTopic(publishTopic + "/accepted");
            pathBuilder1.withCorrelationTokenJsonPath("clientToken");
            builder.withResponsePath(pathBuilder1.build());
            ResponsePath.ResponsePathBuilder pathBuilder2 = ResponsePath.builder();
            String responseTopic2 = publishTopic + "/rejected";
            pathBuilder2.withResponseTopic(publishTopic + "/rejected");
            pathBuilder2.withCorrelationTokenJsonPath("clientToken");
            builder.withResponsePath(pathBuilder2.build());
            this.submitOperation(responseFuture, builder.build(), responseTopic1, GetShadowResponse.class, responseTopic2, V2ErrorResponse.class, IotShadowV2Client::createV2ErrorResponseException);
        }
        catch (Exception e) {
            responseFuture.completeExceptionally(IotShadowV2Client.createV2ErrorResponseException(e.getMessage(), null));
        }
        return responseFuture;
    }

    public CompletableFuture<UpdateShadowResponse> updateNamedShadow(UpdateNamedShadowRequest request) {
        V2ClientFuture<UpdateShadowResponse> responseFuture = new V2ClientFuture<UpdateShadowResponse>();
        try {
            String correlationToken;
            if (request.thingName == null) {
                throw new CrtRuntimeException("UpdateNamedShadowRequest.thingName cannot be null");
            }
            if (request.shadowName == null) {
                throw new CrtRuntimeException("UpdateNamedShadowRequest.shadowName cannot be null");
            }
            RequestResponseOperation.RequestResponseOperationBuilder builder = RequestResponseOperation.builder();
            request.clientToken = correlationToken = UUID.randomUUID().toString();
            builder.withCorrelationToken(correlationToken);
            String publishTopic = "$aws/things/{thingName}/shadow/name/{shadowName}/update";
            publishTopic = publishTopic.replace("{thingName}", request.thingName);
            publishTopic = publishTopic.replace("{shadowName}", request.shadowName);
            builder.withPublishTopic(publishTopic);
            String payloadJson = this.gson.toJson((Object)request);
            builder.withPayload(payloadJson.getBytes(StandardCharsets.UTF_8));
            String subscription0 = "$aws/things/{thingName}/shadow/name/{shadowName}/update/accepted";
            subscription0 = subscription0.replace("{thingName}", request.thingName);
            subscription0 = subscription0.replace("{shadowName}", request.shadowName);
            builder.withSubscription(subscription0);
            String subscription1 = "$aws/things/{thingName}/shadow/name/{shadowName}/update/rejected";
            subscription1 = subscription1.replace("{thingName}", request.thingName);
            subscription1 = subscription1.replace("{shadowName}", request.shadowName);
            builder.withSubscription(subscription1);
            ResponsePath.ResponsePathBuilder pathBuilder1 = ResponsePath.builder();
            String responseTopic1 = publishTopic + "/accepted";
            pathBuilder1.withResponseTopic(publishTopic + "/accepted");
            pathBuilder1.withCorrelationTokenJsonPath("clientToken");
            builder.withResponsePath(pathBuilder1.build());
            ResponsePath.ResponsePathBuilder pathBuilder2 = ResponsePath.builder();
            String responseTopic2 = publishTopic + "/rejected";
            pathBuilder2.withResponseTopic(publishTopic + "/rejected");
            pathBuilder2.withCorrelationTokenJsonPath("clientToken");
            builder.withResponsePath(pathBuilder2.build());
            this.submitOperation(responseFuture, builder.build(), responseTopic1, UpdateShadowResponse.class, responseTopic2, V2ErrorResponse.class, IotShadowV2Client::createV2ErrorResponseException);
        }
        catch (Exception e) {
            responseFuture.completeExceptionally(IotShadowV2Client.createV2ErrorResponseException(e.getMessage(), null));
        }
        return responseFuture;
    }

    public CompletableFuture<UpdateShadowResponse> updateShadow(UpdateShadowRequest request) {
        V2ClientFuture<UpdateShadowResponse> responseFuture = new V2ClientFuture<UpdateShadowResponse>();
        try {
            String correlationToken;
            if (request.thingName == null) {
                throw new CrtRuntimeException("UpdateShadowRequest.thingName cannot be null");
            }
            RequestResponseOperation.RequestResponseOperationBuilder builder = RequestResponseOperation.builder();
            request.clientToken = correlationToken = UUID.randomUUID().toString();
            builder.withCorrelationToken(correlationToken);
            String publishTopic = "$aws/things/{thingName}/shadow/update";
            publishTopic = publishTopic.replace("{thingName}", request.thingName);
            builder.withPublishTopic(publishTopic);
            String payloadJson = this.gson.toJson((Object)request);
            builder.withPayload(payloadJson.getBytes(StandardCharsets.UTF_8));
            String subscription0 = "$aws/things/{thingName}/shadow/update/accepted";
            subscription0 = subscription0.replace("{thingName}", request.thingName);
            builder.withSubscription(subscription0);
            String subscription1 = "$aws/things/{thingName}/shadow/update/rejected";
            subscription1 = subscription1.replace("{thingName}", request.thingName);
            builder.withSubscription(subscription1);
            ResponsePath.ResponsePathBuilder pathBuilder1 = ResponsePath.builder();
            String responseTopic1 = publishTopic + "/accepted";
            pathBuilder1.withResponseTopic(publishTopic + "/accepted");
            pathBuilder1.withCorrelationTokenJsonPath("clientToken");
            builder.withResponsePath(pathBuilder1.build());
            ResponsePath.ResponsePathBuilder pathBuilder2 = ResponsePath.builder();
            String responseTopic2 = publishTopic + "/rejected";
            pathBuilder2.withResponseTopic(publishTopic + "/rejected");
            pathBuilder2.withCorrelationTokenJsonPath("clientToken");
            builder.withResponsePath(pathBuilder2.build());
            this.submitOperation(responseFuture, builder.build(), responseTopic1, UpdateShadowResponse.class, responseTopic2, V2ErrorResponse.class, IotShadowV2Client::createV2ErrorResponseException);
        }
        catch (Exception e) {
            responseFuture.completeExceptionally(IotShadowV2Client.createV2ErrorResponseException(e.getMessage(), null));
        }
        return responseFuture;
    }

    public StreamingOperation createNamedShadowDeltaUpdatedStream(NamedShadowDeltaUpdatedSubscriptionRequest request, V2ClientStreamOptions<ShadowDeltaUpdatedEvent> options) {
        String topic = "$aws/things/{thingName}/shadow/name/{shadowName}/update/delta";
        if (request.thingName == null) {
            throw new CrtRuntimeException("NamedShadowDeltaUpdatedSubscriptionRequest.thingName cannot be null");
        }
        topic = topic.replace("{thingName}", request.thingName);
        if (request.shadowName == null) {
            throw new CrtRuntimeException("NamedShadowDeltaUpdatedSubscriptionRequest.shadowName cannot be null");
        }
        topic = topic.replace("{shadowName}", request.shadowName);
        StreamingOperationOptions innerOptions = StreamingOperationOptions.builder().withTopic(topic).withSubscriptionStatusEventCallback(options.subscriptionEventHandler()).withIncomingPublishEventCallback(event -> {
            try {
                String payload = new String(event.getPayload(), StandardCharsets.UTF_8);
                ShadowDeltaUpdatedEvent response = (ShadowDeltaUpdatedEvent)this.gson.fromJson(payload, ShadowDeltaUpdatedEvent.class);
                options.streamEventHandler().accept(response);
            }
            catch (Exception e) {
                V2DeserializationFailureEvent failureEvent = V2DeserializationFailureEvent.builder().withCause(e).withPayload(event.getPayload()).withTopic(event.getTopic()).build();
                options.deserializationFailureHandler().accept(failureEvent);
            }
        }).build();
        return this.rrClient.createStream(innerOptions);
    }

    public StreamingOperation createNamedShadowUpdatedStream(NamedShadowUpdatedSubscriptionRequest request, V2ClientStreamOptions<ShadowUpdatedEvent> options) {
        String topic = "$aws/things/{thingName}/shadow/name/{shadowName}/update/documents";
        if (request.thingName == null) {
            throw new CrtRuntimeException("NamedShadowUpdatedSubscriptionRequest.thingName cannot be null");
        }
        topic = topic.replace("{thingName}", request.thingName);
        if (request.shadowName == null) {
            throw new CrtRuntimeException("NamedShadowUpdatedSubscriptionRequest.shadowName cannot be null");
        }
        topic = topic.replace("{shadowName}", request.shadowName);
        StreamingOperationOptions innerOptions = StreamingOperationOptions.builder().withTopic(topic).withSubscriptionStatusEventCallback(options.subscriptionEventHandler()).withIncomingPublishEventCallback(event -> {
            try {
                String payload = new String(event.getPayload(), StandardCharsets.UTF_8);
                ShadowUpdatedEvent response = (ShadowUpdatedEvent)this.gson.fromJson(payload, ShadowUpdatedEvent.class);
                options.streamEventHandler().accept(response);
            }
            catch (Exception e) {
                V2DeserializationFailureEvent failureEvent = V2DeserializationFailureEvent.builder().withCause(e).withPayload(event.getPayload()).withTopic(event.getTopic()).build();
                options.deserializationFailureHandler().accept(failureEvent);
            }
        }).build();
        return this.rrClient.createStream(innerOptions);
    }

    public StreamingOperation createShadowDeltaUpdatedStream(ShadowDeltaUpdatedSubscriptionRequest request, V2ClientStreamOptions<ShadowDeltaUpdatedEvent> options) {
        String topic = "$aws/things/{thingName}/shadow/update/delta";
        if (request.thingName == null) {
            throw new CrtRuntimeException("ShadowDeltaUpdatedSubscriptionRequest.thingName cannot be null");
        }
        topic = topic.replace("{thingName}", request.thingName);
        StreamingOperationOptions innerOptions = StreamingOperationOptions.builder().withTopic(topic).withSubscriptionStatusEventCallback(options.subscriptionEventHandler()).withIncomingPublishEventCallback(event -> {
            try {
                String payload = new String(event.getPayload(), StandardCharsets.UTF_8);
                ShadowDeltaUpdatedEvent response = (ShadowDeltaUpdatedEvent)this.gson.fromJson(payload, ShadowDeltaUpdatedEvent.class);
                options.streamEventHandler().accept(response);
            }
            catch (Exception e) {
                V2DeserializationFailureEvent failureEvent = V2DeserializationFailureEvent.builder().withCause(e).withPayload(event.getPayload()).withTopic(event.getTopic()).build();
                options.deserializationFailureHandler().accept(failureEvent);
            }
        }).build();
        return this.rrClient.createStream(innerOptions);
    }

    public StreamingOperation createShadowUpdatedStream(ShadowUpdatedSubscriptionRequest request, V2ClientStreamOptions<ShadowUpdatedEvent> options) {
        String topic = "$aws/things/{thingName}/shadow/update/documents";
        if (request.thingName == null) {
            throw new CrtRuntimeException("ShadowUpdatedSubscriptionRequest.thingName cannot be null");
        }
        topic = topic.replace("{thingName}", request.thingName);
        StreamingOperationOptions innerOptions = StreamingOperationOptions.builder().withTopic(topic).withSubscriptionStatusEventCallback(options.subscriptionEventHandler()).withIncomingPublishEventCallback(event -> {
            try {
                String payload = new String(event.getPayload(), StandardCharsets.UTF_8);
                ShadowUpdatedEvent response = (ShadowUpdatedEvent)this.gson.fromJson(payload, ShadowUpdatedEvent.class);
                options.streamEventHandler().accept(response);
            }
            catch (Exception e) {
                V2DeserializationFailureEvent failureEvent = V2DeserializationFailureEvent.builder().withCause(e).withPayload(event.getPayload()).withTopic(event.getTopic()).build();
                options.deserializationFailureHandler().accept(failureEvent);
            }
        }).build();
        return this.rrClient.createStream(innerOptions);
    }

    private static Throwable createV2ErrorResponseException(String message, V2ErrorResponse errorResponse) {
        return new V2ErrorResponseException(message, errorResponse);
    }

    private <T, E> void submitOperation(V2ClientFuture<T> finalFuture, RequestResponseOperation operation, String responseTopic, Class<T> responseClass, String errorTopic, Class<E> errorClass, BiFunction<String, E, Throwable> exceptionFactory) {
        try {
            CompletableFuture responseFuture = this.rrClient.submitRequest(operation);
            CompletionStage compositeFuture = responseFuture.whenComplete((res, ex) -> {
                if (ex != null) {
                    finalFuture.completeExceptionally((Throwable)exceptionFactory.apply(ex.getMessage(), null));
                } else if (res.getTopic().equals(responseTopic)) {
                    try {
                        String payload = new String(res.getPayload(), StandardCharsets.UTF_8);
                        Object response = this.gson.fromJson(payload, responseClass);
                        finalFuture.complete(response);
                    }
                    catch (Exception e) {
                        finalFuture.completeExceptionally((Throwable)exceptionFactory.apply(e.getMessage(), null));
                    }
                } else if (res.getTopic().equals(errorTopic)) {
                    try {
                        String payload = new String(res.getPayload(), StandardCharsets.UTF_8);
                        Object error = this.gson.fromJson(payload, errorClass);
                        finalFuture.completeExceptionally((Throwable)exceptionFactory.apply("Request-response operation failure", error));
                    }
                    catch (Exception e) {
                        finalFuture.completeExceptionally((Throwable)exceptionFactory.apply(e.getMessage(), null));
                    }
                } else {
                    finalFuture.completeExceptionally((Throwable)exceptionFactory.apply("Request-response operation completed on unknown topic: " + res.getTopic(), null));
                }
            });
            finalFuture.setTriggeringFuture((CompletableFuture<MqttRequestResponse>)compositeFuture);
        }
        catch (Exception ex2) {
            finalFuture.completeExceptionally(exceptionFactory.apply(ex2.getMessage(), null));
        }
    }
}

