/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * Disassociates sasl scram secrets to cluster.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDisassociateScramSecretRequest extends KafkaRequest implements
        ToCopyableBuilder<BatchDisassociateScramSecretRequest.Builder, BatchDisassociateScramSecretRequest> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterArn").getter(getter(BatchDisassociateScramSecretRequest::clusterArn))
            .setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("clusterArn").build()).build();

    private static final SdkField<List<String>> SECRET_ARN_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecretArnList")
            .getter(getter(BatchDisassociateScramSecretRequest::secretArnList))
            .setter(setter(Builder::secretArnList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretArnList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD,
            SECRET_ARN_LIST_FIELD));

    private final String clusterArn;

    private final List<String> secretArnList;

    private BatchDisassociateScramSecretRequest(BuilderImpl builder) {
        super(builder);
        this.clusterArn = builder.clusterArn;
        this.secretArnList = builder.secretArnList;
    }

    /**
     *
     * <p>
     * The Amazon Resource Name (ARN) of the cluster to be updated.
     * </p>
     * 
     * @return <p>
     *         The Amazon Resource Name (ARN) of the cluster to be updated.
     *         </p>
     */
    public String clusterArn() {
        return clusterArn;
    }

    /**
     * Returns true if the SecretArnList property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSecretArnList() {
        return secretArnList != null && !(secretArnList instanceof SdkAutoConstructList);
    }

    /**
     *
     * <p>
     * List of AWS Secrets Manager secret ARNs.
     * </p>
     * 
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecretArnList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return <p>
     *         List of AWS Secrets Manager secret ARNs.
     *         </p>
     */
    public List<String> secretArnList() {
        return secretArnList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(secretArnList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDisassociateScramSecretRequest)) {
            return false;
        }
        BatchDisassociateScramSecretRequest other = (BatchDisassociateScramSecretRequest) obj;
        return Objects.equals(clusterArn(), other.clusterArn()) && Objects.equals(secretArnList(), other.secretArnList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchDisassociateScramSecretRequest").add("ClusterArn", clusterArn())
                .add("SecretArnList", secretArnList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "SecretArnList":
            return Optional.ofNullable(clazz.cast(secretArnList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDisassociateScramSecretRequest, T> g) {
        return obj -> g.apply((BatchDisassociateScramSecretRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchDisassociateScramSecretRequest> {
        /**
         *
         * <p>
         * The Amazon Resource Name (ARN) of the cluster to be updated.
         * </p>
         * 
         * @param clusterArn
         *        <p>
         *        The Amazon Resource Name (ARN) of the cluster to be updated.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         *
         * <p>
         * List of AWS Secrets Manager secret ARNs.
         * </p>
         * 
         * @param secretArnList
         *        <p>
         *        List of AWS Secrets Manager secret ARNs.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArnList(Collection<String> secretArnList);

        /**
         *
         * <p>
         * List of AWS Secrets Manager secret ARNs.
         * </p>
         * 
         * @param secretArnList
         *        <p>
         *        List of AWS Secrets Manager secret ARNs.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArnList(String... secretArnList);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KafkaRequest.BuilderImpl implements Builder {
        private String clusterArn;

        private List<String> secretArnList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDisassociateScramSecretRequest model) {
            super(model);
            clusterArn(model.clusterArn);
            secretArnList(model.secretArnList);
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        public final Collection<String> getSecretArnList() {
            return secretArnList;
        }

        @Override
        public final Builder secretArnList(Collection<String> secretArnList) {
            this.secretArnList = ___listOf__stringCopier.copy(secretArnList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secretArnList(String... secretArnList) {
            secretArnList(Arrays.asList(secretArnList));
            return this;
        }

        public final void setSecretArnList(Collection<String> secretArnList) {
            this.secretArnList = ___listOf__stringCopier.copy(secretArnList);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDisassociateScramSecretRequest build() {
            return new BatchDisassociateScramSecretRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
