/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * Specifies the EBS volume upgrade information. The broker identifier must be set to the keyword ALL. This means the
 * changes apply to all the brokers in the cluster.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
public final class BrokerEBSVolumeInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<BrokerEBSVolumeInfo.Builder, BrokerEBSVolumeInfo> {
    private static final SdkField<String> KAFKA_BROKER_NODE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KafkaBrokerNodeId").getter(getter(BrokerEBSVolumeInfo::kafkaBrokerNodeId))
            .setter(setter(Builder::kafkaBrokerNodeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kafkaBrokerNodeId").build()).build();

    private static final SdkField<Integer> VOLUME_SIZE_GB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("VolumeSizeGB").getter(getter(BrokerEBSVolumeInfo::volumeSizeGB)).setter(setter(Builder::volumeSizeGB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeSizeGB").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KAFKA_BROKER_NODE_ID_FIELD,
            VOLUME_SIZE_GB_FIELD));

    private static final long serialVersionUID = 1L;

    private final String kafkaBrokerNodeId;

    private final Integer volumeSizeGB;

    private BrokerEBSVolumeInfo(BuilderImpl builder) {
        this.kafkaBrokerNodeId = builder.kafkaBrokerNodeId;
        this.volumeSizeGB = builder.volumeSizeGB;
    }

    /**
     *
     * <p>
     * The ID of the broker to update.
     * </p>
     * 
     * @return <p>
     *         The ID of the broker to update.
     *         </p>
     */
    public String kafkaBrokerNodeId() {
        return kafkaBrokerNodeId;
    }

    /**
     *
     * <p>
     * Size of the EBS volume to update.
     * </p>
     * 
     * @return <p>
     *         Size of the EBS volume to update.
     *         </p>
     */
    public Integer volumeSizeGB() {
        return volumeSizeGB;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kafkaBrokerNodeId());
        hashCode = 31 * hashCode + Objects.hashCode(volumeSizeGB());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrokerEBSVolumeInfo)) {
            return false;
        }
        BrokerEBSVolumeInfo other = (BrokerEBSVolumeInfo) obj;
        return Objects.equals(kafkaBrokerNodeId(), other.kafkaBrokerNodeId())
                && Objects.equals(volumeSizeGB(), other.volumeSizeGB());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BrokerEBSVolumeInfo").add("KafkaBrokerNodeId", kafkaBrokerNodeId())
                .add("VolumeSizeGB", volumeSizeGB()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KafkaBrokerNodeId":
            return Optional.ofNullable(clazz.cast(kafkaBrokerNodeId()));
        case "VolumeSizeGB":
            return Optional.ofNullable(clazz.cast(volumeSizeGB()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BrokerEBSVolumeInfo, T> g) {
        return obj -> g.apply((BrokerEBSVolumeInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BrokerEBSVolumeInfo> {
        /**
         *
         * <p>
         * The ID of the broker to update.
         * </p>
         * 
         * @param kafkaBrokerNodeId
         *        <p>
         *        The ID of the broker to update.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kafkaBrokerNodeId(String kafkaBrokerNodeId);

        /**
         *
         * <p>
         * Size of the EBS volume to update.
         * </p>
         * 
         * @param volumeSizeGB
         *        <p>
         *        Size of the EBS volume to update.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeSizeGB(Integer volumeSizeGB);
    }

    static final class BuilderImpl implements Builder {
        private String kafkaBrokerNodeId;

        private Integer volumeSizeGB;

        private BuilderImpl() {
        }

        private BuilderImpl(BrokerEBSVolumeInfo model) {
            kafkaBrokerNodeId(model.kafkaBrokerNodeId);
            volumeSizeGB(model.volumeSizeGB);
        }

        public final String getKafkaBrokerNodeId() {
            return kafkaBrokerNodeId;
        }

        @Override
        public final Builder kafkaBrokerNodeId(String kafkaBrokerNodeId) {
            this.kafkaBrokerNodeId = kafkaBrokerNodeId;
            return this;
        }

        public final void setKafkaBrokerNodeId(String kafkaBrokerNodeId) {
            this.kafkaBrokerNodeId = kafkaBrokerNodeId;
        }

        public final Integer getVolumeSizeGB() {
            return volumeSizeGB;
        }

        @Override
        public final Builder volumeSizeGB(Integer volumeSizeGB) {
            this.volumeSizeGB = volumeSizeGB;
            return this;
        }

        public final void setVolumeSizeGB(Integer volumeSizeGB) {
            this.volumeSizeGB = volumeSizeGB;
        }

        @Override
        public BrokerEBSVolumeInfo build() {
            return new BrokerEBSVolumeInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
