/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * BrokerNodeInfo
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
public final class BrokerNodeInfo implements SdkPojo, Serializable, ToCopyableBuilder<BrokerNodeInfo.Builder, BrokerNodeInfo> {
    private static final SdkField<String> ATTACHED_ENI_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttachedENIId").getter(getter(BrokerNodeInfo::attachedENIId)).setter(setter(Builder::attachedENIId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachedENIId").build()).build();

    private static final SdkField<Double> BROKER_ID_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("BrokerId").getter(getter(BrokerNodeInfo::brokerId)).setter(setter(Builder::brokerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerId").build()).build();

    private static final SdkField<String> CLIENT_SUBNET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientSubnet").getter(getter(BrokerNodeInfo::clientSubnet)).setter(setter(Builder::clientSubnet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientSubnet").build()).build();

    private static final SdkField<String> CLIENT_VPC_IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientVpcIpAddress").getter(getter(BrokerNodeInfo::clientVpcIpAddress))
            .setter(setter(Builder::clientVpcIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientVpcIpAddress").build())
            .build();

    private static final SdkField<BrokerSoftwareInfo> CURRENT_BROKER_SOFTWARE_INFO_FIELD = SdkField
            .<BrokerSoftwareInfo> builder(MarshallingType.SDK_POJO).memberName("CurrentBrokerSoftwareInfo")
            .getter(getter(BrokerNodeInfo::currentBrokerSoftwareInfo)).setter(setter(Builder::currentBrokerSoftwareInfo))
            .constructor(BrokerSoftwareInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentBrokerSoftwareInfo").build())
            .build();

    private static final SdkField<List<String>> ENDPOINTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Endpoints")
            .getter(getter(BrokerNodeInfo::endpoints))
            .setter(setter(Builder::endpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHED_ENI_ID_FIELD,
            BROKER_ID_FIELD, CLIENT_SUBNET_FIELD, CLIENT_VPC_IP_ADDRESS_FIELD, CURRENT_BROKER_SOFTWARE_INFO_FIELD,
            ENDPOINTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String attachedENIId;

    private final Double brokerId;

    private final String clientSubnet;

    private final String clientVpcIpAddress;

    private final BrokerSoftwareInfo currentBrokerSoftwareInfo;

    private final List<String> endpoints;

    private BrokerNodeInfo(BuilderImpl builder) {
        this.attachedENIId = builder.attachedENIId;
        this.brokerId = builder.brokerId;
        this.clientSubnet = builder.clientSubnet;
        this.clientVpcIpAddress = builder.clientVpcIpAddress;
        this.currentBrokerSoftwareInfo = builder.currentBrokerSoftwareInfo;
        this.endpoints = builder.endpoints;
    }

    /**
     *
     * <p>
     * The attached elastic network interface of the broker.
     * </p>
     * 
     * @return <p>
     *         The attached elastic network interface of the broker.
     *         </p>
     */
    public String attachedENIId() {
        return attachedENIId;
    }

    /**
     *
     * <p>
     * The ID of the broker.
     * </p>
     * 
     * @return <p>
     *         The ID of the broker.
     *         </p>
     */
    public Double brokerId() {
        return brokerId;
    }

    /**
     *
     * <p>
     * The client subnet to which this broker node belongs.
     * </p>
     * 
     * @return <p>
     *         The client subnet to which this broker node belongs.
     *         </p>
     */
    public String clientSubnet() {
        return clientSubnet;
    }

    /**
     *
     * <p>
     * The virtual private cloud (VPC) of the client.
     * </p>
     * 
     * @return <p>
     *         The virtual private cloud (VPC) of the client.
     *         </p>
     */
    public String clientVpcIpAddress() {
        return clientVpcIpAddress;
    }

    /**
     *
     * <p>
     * Information about the version of software currently deployed on the Kafka brokers in the cluster.
     * </p>
     * 
     * @return <p>
     *         Information about the version of software currently deployed on the Kafka brokers in the cluster.
     *         </p>
     */
    public BrokerSoftwareInfo currentBrokerSoftwareInfo() {
        return currentBrokerSoftwareInfo;
    }

    /**
     * Returns true if the Endpoints property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEndpoints() {
        return endpoints != null && !(endpoints instanceof SdkAutoConstructList);
    }

    /**
     *
     * <p>
     * Endpoints for accessing the broker.
     * </p>
     * 
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEndpoints()} to see if a value was sent in this field.
     * </p>
     * 
     * @return <p>
     *         Endpoints for accessing the broker.
     *         </p>
     */
    public List<String> endpoints() {
        return endpoints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attachedENIId());
        hashCode = 31 * hashCode + Objects.hashCode(brokerId());
        hashCode = 31 * hashCode + Objects.hashCode(clientSubnet());
        hashCode = 31 * hashCode + Objects.hashCode(clientVpcIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(currentBrokerSoftwareInfo());
        hashCode = 31 * hashCode + Objects.hashCode(endpoints());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrokerNodeInfo)) {
            return false;
        }
        BrokerNodeInfo other = (BrokerNodeInfo) obj;
        return Objects.equals(attachedENIId(), other.attachedENIId()) && Objects.equals(brokerId(), other.brokerId())
                && Objects.equals(clientSubnet(), other.clientSubnet())
                && Objects.equals(clientVpcIpAddress(), other.clientVpcIpAddress())
                && Objects.equals(currentBrokerSoftwareInfo(), other.currentBrokerSoftwareInfo())
                && Objects.equals(endpoints(), other.endpoints());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BrokerNodeInfo").add("AttachedENIId", attachedENIId()).add("BrokerId", brokerId())
                .add("ClientSubnet", clientSubnet()).add("ClientVpcIpAddress", clientVpcIpAddress())
                .add("CurrentBrokerSoftwareInfo", currentBrokerSoftwareInfo()).add("Endpoints", endpoints()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttachedENIId":
            return Optional.ofNullable(clazz.cast(attachedENIId()));
        case "BrokerId":
            return Optional.ofNullable(clazz.cast(brokerId()));
        case "ClientSubnet":
            return Optional.ofNullable(clazz.cast(clientSubnet()));
        case "ClientVpcIpAddress":
            return Optional.ofNullable(clazz.cast(clientVpcIpAddress()));
        case "CurrentBrokerSoftwareInfo":
            return Optional.ofNullable(clazz.cast(currentBrokerSoftwareInfo()));
        case "Endpoints":
            return Optional.ofNullable(clazz.cast(endpoints()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BrokerNodeInfo, T> g) {
        return obj -> g.apply((BrokerNodeInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BrokerNodeInfo> {
        /**
         *
         * <p>
         * The attached elastic network interface of the broker.
         * </p>
         * 
         * @param attachedENIId
         *        <p>
         *        The attached elastic network interface of the broker.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachedENIId(String attachedENIId);

        /**
         *
         * <p>
         * The ID of the broker.
         * </p>
         * 
         * @param brokerId
         *        <p>
         *        The ID of the broker.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brokerId(Double brokerId);

        /**
         *
         * <p>
         * The client subnet to which this broker node belongs.
         * </p>
         * 
         * @param clientSubnet
         *        <p>
         *        The client subnet to which this broker node belongs.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientSubnet(String clientSubnet);

        /**
         *
         * <p>
         * The virtual private cloud (VPC) of the client.
         * </p>
         * 
         * @param clientVpcIpAddress
         *        <p>
         *        The virtual private cloud (VPC) of the client.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientVpcIpAddress(String clientVpcIpAddress);

        /**
         *
         * <p>
         * Information about the version of software currently deployed on the Kafka brokers in the cluster.
         * </p>
         * 
         * @param currentBrokerSoftwareInfo
         *        <p>
         *        Information about the version of software currently deployed on the Kafka brokers in the cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentBrokerSoftwareInfo(BrokerSoftwareInfo currentBrokerSoftwareInfo);

        /**
         *
         * <p>
         * Information about the version of software currently deployed on the Kafka brokers in the cluster.
         * </p>
         * 
         * This is a convenience that creates an instance of the {@link BrokerSoftwareInfo.Builder} avoiding the need to
         * create one manually via {@link BrokerSoftwareInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link BrokerSoftwareInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #currentBrokerSoftwareInfo(BrokerSoftwareInfo)}.
         * 
         * @param currentBrokerSoftwareInfo
         *        a consumer that will call methods on {@link BrokerSoftwareInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #currentBrokerSoftwareInfo(BrokerSoftwareInfo)
         */
        default Builder currentBrokerSoftwareInfo(Consumer<BrokerSoftwareInfo.Builder> currentBrokerSoftwareInfo) {
            return currentBrokerSoftwareInfo(BrokerSoftwareInfo.builder().applyMutation(currentBrokerSoftwareInfo).build());
        }

        /**
         *
         * <p>
         * Endpoints for accessing the broker.
         * </p>
         * 
         * @param endpoints
         *        <p>
         *        Endpoints for accessing the broker.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoints(Collection<String> endpoints);

        /**
         *
         * <p>
         * Endpoints for accessing the broker.
         * </p>
         * 
         * @param endpoints
         *        <p>
         *        Endpoints for accessing the broker.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoints(String... endpoints);
    }

    static final class BuilderImpl implements Builder {
        private String attachedENIId;

        private Double brokerId;

        private String clientSubnet;

        private String clientVpcIpAddress;

        private BrokerSoftwareInfo currentBrokerSoftwareInfo;

        private List<String> endpoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BrokerNodeInfo model) {
            attachedENIId(model.attachedENIId);
            brokerId(model.brokerId);
            clientSubnet(model.clientSubnet);
            clientVpcIpAddress(model.clientVpcIpAddress);
            currentBrokerSoftwareInfo(model.currentBrokerSoftwareInfo);
            endpoints(model.endpoints);
        }

        public final String getAttachedENIId() {
            return attachedENIId;
        }

        @Override
        public final Builder attachedENIId(String attachedENIId) {
            this.attachedENIId = attachedENIId;
            return this;
        }

        public final void setAttachedENIId(String attachedENIId) {
            this.attachedENIId = attachedENIId;
        }

        public final Double getBrokerId() {
            return brokerId;
        }

        @Override
        public final Builder brokerId(Double brokerId) {
            this.brokerId = brokerId;
            return this;
        }

        public final void setBrokerId(Double brokerId) {
            this.brokerId = brokerId;
        }

        public final String getClientSubnet() {
            return clientSubnet;
        }

        @Override
        public final Builder clientSubnet(String clientSubnet) {
            this.clientSubnet = clientSubnet;
            return this;
        }

        public final void setClientSubnet(String clientSubnet) {
            this.clientSubnet = clientSubnet;
        }

        public final String getClientVpcIpAddress() {
            return clientVpcIpAddress;
        }

        @Override
        public final Builder clientVpcIpAddress(String clientVpcIpAddress) {
            this.clientVpcIpAddress = clientVpcIpAddress;
            return this;
        }

        public final void setClientVpcIpAddress(String clientVpcIpAddress) {
            this.clientVpcIpAddress = clientVpcIpAddress;
        }

        public final BrokerSoftwareInfo.Builder getCurrentBrokerSoftwareInfo() {
            return currentBrokerSoftwareInfo != null ? currentBrokerSoftwareInfo.toBuilder() : null;
        }

        @Override
        public final Builder currentBrokerSoftwareInfo(BrokerSoftwareInfo currentBrokerSoftwareInfo) {
            this.currentBrokerSoftwareInfo = currentBrokerSoftwareInfo;
            return this;
        }

        public final void setCurrentBrokerSoftwareInfo(BrokerSoftwareInfo.BuilderImpl currentBrokerSoftwareInfo) {
            this.currentBrokerSoftwareInfo = currentBrokerSoftwareInfo != null ? currentBrokerSoftwareInfo.build() : null;
        }

        public final Collection<String> getEndpoints() {
            return endpoints;
        }

        @Override
        public final Builder endpoints(Collection<String> endpoints) {
            this.endpoints = ___listOf__stringCopier.copy(endpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(String... endpoints) {
            endpoints(Arrays.asList(endpoints));
            return this;
        }

        public final void setEndpoints(Collection<String> endpoints) {
            this.endpoints = ___listOf__stringCopier.copy(endpoints);
        }

        @Override
        public BrokerNodeInfo build() {
            return new BrokerNodeInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
