/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * State information about the operation step.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterOperationStepInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<ClusterOperationStepInfo.Builder, ClusterOperationStepInfo> {
    private static final SdkField<String> STEP_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StepStatus").getter(getter(ClusterOperationStepInfo::stepStatus)).setter(setter(Builder::stepStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String stepStatus;

    private ClusterOperationStepInfo(BuilderImpl builder) {
        this.stepStatus = builder.stepStatus;
    }

    /**
     *
     * <p>
     * The steps current status.
     * </p>
     * 
     * @return <p>
     *         The steps current status.
     *         </p>
     */
    public String stepStatus() {
        return stepStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stepStatus());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterOperationStepInfo)) {
            return false;
        }
        ClusterOperationStepInfo other = (ClusterOperationStepInfo) obj;
        return Objects.equals(stepStatus(), other.stepStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ClusterOperationStepInfo").add("StepStatus", stepStatus()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StepStatus":
            return Optional.ofNullable(clazz.cast(stepStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClusterOperationStepInfo, T> g) {
        return obj -> g.apply((ClusterOperationStepInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterOperationStepInfo> {
        /**
         *
         * <p>
         * The steps current status.
         * </p>
         * 
         * @param stepStatus
         *        <p>
         *        The steps current status.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepStatus(String stepStatus);
    }

    static final class BuilderImpl implements Builder {
        private String stepStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterOperationStepInfo model) {
            stepStatus(model.stepStatus);
        }

        public final String getStepStatus() {
            return stepStatus;
        }

        @Override
        public final Builder stepStatus(String stepStatus) {
            this.stepStatus = stepStatus;
            return this;
        }

        public final void setStepStatus(String stepStatus) {
            this.stepStatus = stepStatus;
        }

        @Override
        public ClusterOperationStepInfo build() {
            return new ClusterOperationStepInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
