/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Reboots a node.
 */
@Generated("software.amazon.awssdk:codegen")
public final class RebootBrokerRequest extends KafkaRequest implements
        ToCopyableBuilder<RebootBrokerRequest.Builder, RebootBrokerRequest> {
    private static final SdkField<List<String>> BROKER_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("BrokerIds")
            .getter(getter(RebootBrokerRequest::brokerIds))
            .setter(setter(Builder::brokerIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterArn").getter(getter(RebootBrokerRequest::clusterArn)).setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("clusterArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROKER_IDS_FIELD,
            CLUSTER_ARN_FIELD));

    private final List<String> brokerIds;

    private final String clusterArn;

    private RebootBrokerRequest(BuilderImpl builder) {
        super(builder);
        this.brokerIds = builder.brokerIds;
        this.clusterArn = builder.clusterArn;
    }

    /**
     * Returns true if the BrokerIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasBrokerIds() {
        return brokerIds != null && !(brokerIds instanceof SdkAutoConstructList);
    }

    /**
     *
     * <p>
     * The list of broker IDs to be rebooted. The reboot-broker operation supports rebooting one broker at a time.
     * </p>
     * 
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBrokerIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return <p>
     *         The list of broker IDs to be rebooted. The reboot-broker operation supports rebooting one broker at a
     *         time.
     *         </p>
     */
    public List<String> brokerIds() {
        return brokerIds;
    }

    /**
     *
     * <p>
     * The Amazon Resource Name (ARN) of the cluster to be updated.
     * </p>
     * 
     * @return <p>
     *         The Amazon Resource Name (ARN) of the cluster to be updated.
     *         </p>
     */
    public String clusterArn() {
        return clusterArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(brokerIds());
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RebootBrokerRequest)) {
            return false;
        }
        RebootBrokerRequest other = (RebootBrokerRequest) obj;
        return Objects.equals(brokerIds(), other.brokerIds()) && Objects.equals(clusterArn(), other.clusterArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RebootBrokerRequest").add("BrokerIds", brokerIds()).add("ClusterArn", clusterArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BrokerIds":
            return Optional.ofNullable(clazz.cast(brokerIds()));
        case "ClusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RebootBrokerRequest, T> g) {
        return obj -> g.apply((RebootBrokerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaRequest.Builder, SdkPojo, CopyableBuilder<Builder, RebootBrokerRequest> {
        /**
         *
         * <p>
         * The list of broker IDs to be rebooted. The reboot-broker operation supports rebooting one broker at a time.
         * </p>
         * 
         * @param brokerIds
         *        <p>
         *        The list of broker IDs to be rebooted. The reboot-broker operation supports rebooting one broker at a
         *        time.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brokerIds(Collection<String> brokerIds);

        /**
         *
         * <p>
         * The list of broker IDs to be rebooted. The reboot-broker operation supports rebooting one broker at a time.
         * </p>
         * 
         * @param brokerIds
         *        <p>
         *        The list of broker IDs to be rebooted. The reboot-broker operation supports rebooting one broker at a
         *        time.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brokerIds(String... brokerIds);

        /**
         *
         * <p>
         * The Amazon Resource Name (ARN) of the cluster to be updated.
         * </p>
         * 
         * @param clusterArn
         *        <p>
         *        The Amazon Resource Name (ARN) of the cluster to be updated.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KafkaRequest.BuilderImpl implements Builder {
        private List<String> brokerIds = DefaultSdkAutoConstructList.getInstance();

        private String clusterArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RebootBrokerRequest model) {
            super(model);
            brokerIds(model.brokerIds);
            clusterArn(model.clusterArn);
        }

        public final Collection<String> getBrokerIds() {
            return brokerIds;
        }

        @Override
        public final Builder brokerIds(Collection<String> brokerIds) {
            this.brokerIds = ___listOf__stringCopier.copy(brokerIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder brokerIds(String... brokerIds) {
            brokerIds(Arrays.asList(brokerIds));
            return this;
        }

        public final void setBrokerIds(Collection<String> brokerIds) {
            this.brokerIds = ___listOf__stringCopier.copy(brokerIds);
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RebootBrokerRequest build() {
            return new RebootBrokerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
