/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBrokerCountRequest extends KafkaRequest implements
        ToCopyableBuilder<UpdateBrokerCountRequest.Builder, UpdateBrokerCountRequest> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterArn").getter(getter(UpdateBrokerCountRequest::clusterArn)).setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("clusterArn").build()).build();

    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentVersion").getter(getter(UpdateBrokerCountRequest::currentVersion))
            .setter(setter(Builder::currentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentVersion").build()).build();

    private static final SdkField<Integer> TARGET_NUMBER_OF_BROKER_NODES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("TargetNumberOfBrokerNodes")
            .getter(getter(UpdateBrokerCountRequest::targetNumberOfBrokerNodes))
            .setter(setter(Builder::targetNumberOfBrokerNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetNumberOfBrokerNodes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD,
            CURRENT_VERSION_FIELD, TARGET_NUMBER_OF_BROKER_NODES_FIELD));

    private final String clusterArn;

    private final String currentVersion;

    private final Integer targetNumberOfBrokerNodes;

    private UpdateBrokerCountRequest(BuilderImpl builder) {
        super(builder);
        this.clusterArn = builder.clusterArn;
        this.currentVersion = builder.currentVersion;
        this.targetNumberOfBrokerNodes = builder.targetNumberOfBrokerNodes;
    }

    /**
     *
     * <p>
     * The Amazon Resource Name (ARN) that uniquely identifies the cluster.
     * </p>
     * 
     * @return <p>
     *         The Amazon Resource Name (ARN) that uniquely identifies the cluster.
     *         </p>
     */
    public String clusterArn() {
        return clusterArn;
    }

    /**
     *
     * <p>
     * The version of cluster to update from. A successful operation will then generate a new version.
     * </p>
     * 
     * @return <p>
     *         The version of cluster to update from. A successful operation will then generate a new version.
     *         </p>
     */
    public String currentVersion() {
        return currentVersion;
    }

    /**
     *
     * <p>
     * The number of broker nodes that you want the cluster to have after this operation completes successfully.
     * </p>
     * 
     * @return <p>
     *         The number of broker nodes that you want the cluster to have after this operation completes successfully.
     *         </p>
     */
    public Integer targetNumberOfBrokerNodes() {
        return targetNumberOfBrokerNodes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(targetNumberOfBrokerNodes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBrokerCountRequest)) {
            return false;
        }
        UpdateBrokerCountRequest other = (UpdateBrokerCountRequest) obj;
        return Objects.equals(clusterArn(), other.clusterArn()) && Objects.equals(currentVersion(), other.currentVersion())
                && Objects.equals(targetNumberOfBrokerNodes(), other.targetNumberOfBrokerNodes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateBrokerCountRequest").add("ClusterArn", clusterArn())
                .add("CurrentVersion", currentVersion()).add("TargetNumberOfBrokerNodes", targetNumberOfBrokerNodes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "CurrentVersion":
            return Optional.ofNullable(clazz.cast(currentVersion()));
        case "TargetNumberOfBrokerNodes":
            return Optional.ofNullable(clazz.cast(targetNumberOfBrokerNodes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBrokerCountRequest, T> g) {
        return obj -> g.apply((UpdateBrokerCountRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateBrokerCountRequest> {
        /**
         *
         * <p>
         * The Amazon Resource Name (ARN) that uniquely identifies the cluster.
         * </p>
         * 
         * @param clusterArn
         *        <p>
         *        The Amazon Resource Name (ARN) that uniquely identifies the cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         *
         * <p>
         * The version of cluster to update from. A successful operation will then generate a new version.
         * </p>
         * 
         * @param currentVersion
         *        <p>
         *        The version of cluster to update from. A successful operation will then generate a new version.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentVersion(String currentVersion);

        /**
         *
         * <p>
         * The number of broker nodes that you want the cluster to have after this operation completes successfully.
         * </p>
         * 
         * @param targetNumberOfBrokerNodes
         *        <p>
         *        The number of broker nodes that you want the cluster to have after this operation completes
         *        successfully.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetNumberOfBrokerNodes(Integer targetNumberOfBrokerNodes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KafkaRequest.BuilderImpl implements Builder {
        private String clusterArn;

        private String currentVersion;

        private Integer targetNumberOfBrokerNodes;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBrokerCountRequest model) {
            super(model);
            clusterArn(model.clusterArn);
            currentVersion(model.currentVersion);
            targetNumberOfBrokerNodes(model.targetNumberOfBrokerNodes);
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        public final String getCurrentVersion() {
            return currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        public final Integer getTargetNumberOfBrokerNodes() {
            return targetNumberOfBrokerNodes;
        }

        @Override
        public final Builder targetNumberOfBrokerNodes(Integer targetNumberOfBrokerNodes) {
            this.targetNumberOfBrokerNodes = targetNumberOfBrokerNodes;
            return this;
        }

        public final void setTargetNumberOfBrokerNodes(Integer targetNumberOfBrokerNodes) {
            this.targetNumberOfBrokerNodes = targetNumberOfBrokerNodes;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBrokerCountRequest build() {
            return new UpdateBrokerCountRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
