/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConfigurationResponse extends KafkaResponse implements
        ToCopyableBuilder<UpdateConfigurationResponse.Builder, UpdateConfigurationResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(UpdateConfigurationResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<ConfigurationRevision> LATEST_REVISION_FIELD = SdkField
            .<ConfigurationRevision> builder(MarshallingType.SDK_POJO).memberName("LatestRevision")
            .getter(getter(UpdateConfigurationResponse::latestRevision)).setter(setter(Builder::latestRevision))
            .constructor(ConfigurationRevision::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestRevision").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            LATEST_REVISION_FIELD));

    private final String arn;

    private final ConfigurationRevision latestRevision;

    private UpdateConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.latestRevision = builder.latestRevision;
    }

    /**
     *
     * <p>
     * The Amazon Resource Name (ARN) of the configuration.
     * </p>
     * 
     * @return <p>
     *         The Amazon Resource Name (ARN) of the configuration.
     *         </p>
     */
    public String arn() {
        return arn;
    }

    /**
     *
     * <p>
     * Latest revision of the configuration.
     * </p>
     * 
     * @return <p>
     *         Latest revision of the configuration.
     *         </p>
     */
    public ConfigurationRevision latestRevision() {
        return latestRevision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(latestRevision());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConfigurationResponse)) {
            return false;
        }
        UpdateConfigurationResponse other = (UpdateConfigurationResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(latestRevision(), other.latestRevision());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateConfigurationResponse").add("Arn", arn()).add("LatestRevision", latestRevision()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "LatestRevision":
            return Optional.ofNullable(clazz.cast(latestRevision()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateConfigurationResponse, T> g) {
        return obj -> g.apply((UpdateConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateConfigurationResponse> {
        /**
         *
         * <p>
         * The Amazon Resource Name (ARN) of the configuration.
         * </p>
         * 
         * @param arn
         *        <p>
         *        The Amazon Resource Name (ARN) of the configuration.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         *
         * <p>
         * Latest revision of the configuration.
         * </p>
         * 
         * @param latestRevision
         *        <p>
         *        Latest revision of the configuration.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestRevision(ConfigurationRevision latestRevision);

        /**
         *
         * <p>
         * Latest revision of the configuration.
         * </p>
         * 
         * This is a convenience that creates an instance of the {@link ConfigurationRevision.Builder} avoiding the need
         * to create one manually via {@link ConfigurationRevision#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConfigurationRevision.Builder#build()} is called immediately and
         * its result is passed to {@link #latestRevision(ConfigurationRevision)}.
         * 
         * @param latestRevision
         *        a consumer that will call methods on {@link ConfigurationRevision.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #latestRevision(ConfigurationRevision)
         */
        default Builder latestRevision(Consumer<ConfigurationRevision.Builder> latestRevision) {
            return latestRevision(ConfigurationRevision.builder().applyMutation(latestRevision).build());
        }
    }

    static final class BuilderImpl extends KafkaResponse.BuilderImpl implements Builder {
        private String arn;

        private ConfigurationRevision latestRevision;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConfigurationResponse model) {
            super(model);
            arn(model.arn);
            latestRevision(model.latestRevision);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final ConfigurationRevision.Builder getLatestRevision() {
            return latestRevision != null ? latestRevision.toBuilder() : null;
        }

        @Override
        public final Builder latestRevision(ConfigurationRevision latestRevision) {
            this.latestRevision = latestRevision;
            return this;
        }

        public final void setLatestRevision(ConfigurationRevision.BuilderImpl latestRevision) {
            this.latestRevision = latestRevision != null ? latestRevision.build() : null;
        }

        @Override
        public UpdateConfigurationResponse build() {
            return new UpdateConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
