/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSignalingChannelRequest extends KinesisVideoRequest implements
        ToCopyableBuilder<CreateSignalingChannelRequest.Builder, CreateSignalingChannelRequest> {
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelName").getter(getter(CreateSignalingChannelRequest::channelName))
            .setter(setter(Builder::channelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelName").build()).build();

    private static final SdkField<String> CHANNEL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelType").getter(getter(CreateSignalingChannelRequest::channelTypeAsString))
            .setter(setter(Builder::channelType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelType").build()).build();

    private static final SdkField<SingleMasterConfiguration> SINGLE_MASTER_CONFIGURATION_FIELD = SdkField
            .<SingleMasterConfiguration> builder(MarshallingType.SDK_POJO).memberName("SingleMasterConfiguration")
            .getter(getter(CreateSignalingChannelRequest::singleMasterConfiguration))
            .setter(setter(Builder::singleMasterConfiguration)).constructor(SingleMasterConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleMasterConfiguration").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateSignalingChannelRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_NAME_FIELD,
            CHANNEL_TYPE_FIELD, SINGLE_MASTER_CONFIGURATION_FIELD, TAGS_FIELD));

    private final String channelName;

    private final String channelType;

    private final SingleMasterConfiguration singleMasterConfiguration;

    private final List<Tag> tags;

    private CreateSignalingChannelRequest(BuilderImpl builder) {
        super(builder);
        this.channelName = builder.channelName;
        this.channelType = builder.channelType;
        this.singleMasterConfiguration = builder.singleMasterConfiguration;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A name for the signaling channel that you are creating. It must be unique for each AWS account and AWS Region.
     * </p>
     * 
     * @return A name for the signaling channel that you are creating. It must be unique for each AWS account and AWS
     *         Region.
     */
    public String channelName() {
        return channelName;
    }

    /**
     * <p>
     * A type of the signaling channel that you are creating. Currently, <code>SINGLE_MASTER</code> is the only
     * supported channel type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channelType} will
     * return {@link ChannelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelTypeAsString}.
     * </p>
     * 
     * @return A type of the signaling channel that you are creating. Currently, <code>SINGLE_MASTER</code> is the only
     *         supported channel type.
     * @see ChannelType
     */
    public ChannelType channelType() {
        return ChannelType.fromValue(channelType);
    }

    /**
     * <p>
     * A type of the signaling channel that you are creating. Currently, <code>SINGLE_MASTER</code> is the only
     * supported channel type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channelType} will
     * return {@link ChannelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelTypeAsString}.
     * </p>
     * 
     * @return A type of the signaling channel that you are creating. Currently, <code>SINGLE_MASTER</code> is the only
     *         supported channel type.
     * @see ChannelType
     */
    public String channelTypeAsString() {
        return channelType;
    }

    /**
     * <p>
     * A structure containing the configuration for the <code>SINGLE_MASTER</code> channel type.
     * </p>
     * 
     * @return A structure containing the configuration for the <code>SINGLE_MASTER</code> channel type.
     */
    public SingleMasterConfiguration singleMasterConfiguration() {
        return singleMasterConfiguration;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A set of tags (key-value pairs) that you want to associate with this channel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A set of tags (key-value pairs) that you want to associate with this channel.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelName());
        hashCode = 31 * hashCode + Objects.hashCode(channelTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(singleMasterConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSignalingChannelRequest)) {
            return false;
        }
        CreateSignalingChannelRequest other = (CreateSignalingChannelRequest) obj;
        return Objects.equals(channelName(), other.channelName())
                && Objects.equals(channelTypeAsString(), other.channelTypeAsString())
                && Objects.equals(singleMasterConfiguration(), other.singleMasterConfiguration())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateSignalingChannelRequest").add("ChannelName", channelName())
                .add("ChannelType", channelTypeAsString()).add("SingleMasterConfiguration", singleMasterConfiguration())
                .add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelName":
            return Optional.ofNullable(clazz.cast(channelName()));
        case "ChannelType":
            return Optional.ofNullable(clazz.cast(channelTypeAsString()));
        case "SingleMasterConfiguration":
            return Optional.ofNullable(clazz.cast(singleMasterConfiguration()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSignalingChannelRequest, T> g) {
        return obj -> g.apply((CreateSignalingChannelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisVideoRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateSignalingChannelRequest> {
        /**
         * <p>
         * A name for the signaling channel that you are creating. It must be unique for each AWS account and AWS
         * Region.
         * </p>
         * 
         * @param channelName
         *        A name for the signaling channel that you are creating. It must be unique for each AWS account and AWS
         *        Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelName(String channelName);

        /**
         * <p>
         * A type of the signaling channel that you are creating. Currently, <code>SINGLE_MASTER</code> is the only
         * supported channel type.
         * </p>
         * 
         * @param channelType
         *        A type of the signaling channel that you are creating. Currently, <code>SINGLE_MASTER</code> is the
         *        only supported channel type.
         * @see ChannelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelType
         */
        Builder channelType(String channelType);

        /**
         * <p>
         * A type of the signaling channel that you are creating. Currently, <code>SINGLE_MASTER</code> is the only
         * supported channel type.
         * </p>
         * 
         * @param channelType
         *        A type of the signaling channel that you are creating. Currently, <code>SINGLE_MASTER</code> is the
         *        only supported channel type.
         * @see ChannelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelType
         */
        Builder channelType(ChannelType channelType);

        /**
         * <p>
         * A structure containing the configuration for the <code>SINGLE_MASTER</code> channel type.
         * </p>
         * 
         * @param singleMasterConfiguration
         *        A structure containing the configuration for the <code>SINGLE_MASTER</code> channel type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder singleMasterConfiguration(SingleMasterConfiguration singleMasterConfiguration);

        /**
         * <p>
         * A structure containing the configuration for the <code>SINGLE_MASTER</code> channel type.
         * </p>
         * This is a convenience that creates an instance of the {@link SingleMasterConfiguration.Builder} avoiding the
         * need to create one manually via {@link SingleMasterConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link SingleMasterConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #singleMasterConfiguration(SingleMasterConfiguration)}.
         * 
         * @param singleMasterConfiguration
         *        a consumer that will call methods on {@link SingleMasterConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #singleMasterConfiguration(SingleMasterConfiguration)
         */
        default Builder singleMasterConfiguration(Consumer<SingleMasterConfiguration.Builder> singleMasterConfiguration) {
            return singleMasterConfiguration(SingleMasterConfiguration.builder().applyMutation(singleMasterConfiguration).build());
        }

        /**
         * <p>
         * A set of tags (key-value pairs) that you want to associate with this channel.
         * </p>
         * 
         * @param tags
         *        A set of tags (key-value pairs) that you want to associate with this channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A set of tags (key-value pairs) that you want to associate with this channel.
         * </p>
         * 
         * @param tags
         *        A set of tags (key-value pairs) that you want to associate with this channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A set of tags (key-value pairs) that you want to associate with this channel.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisVideoRequest.BuilderImpl implements Builder {
        private String channelName;

        private String channelType;

        private SingleMasterConfiguration singleMasterConfiguration;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSignalingChannelRequest model) {
            super(model);
            channelName(model.channelName);
            channelType(model.channelType);
            singleMasterConfiguration(model.singleMasterConfiguration);
            tags(model.tags);
        }

        public final String getChannelName() {
            return channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        public final String getChannelType() {
            return channelType;
        }

        @Override
        public final Builder channelType(String channelType) {
            this.channelType = channelType;
            return this;
        }

        @Override
        public final Builder channelType(ChannelType channelType) {
            this.channelType(channelType == null ? null : channelType.toString());
            return this;
        }

        public final void setChannelType(String channelType) {
            this.channelType = channelType;
        }

        public final SingleMasterConfiguration.Builder getSingleMasterConfiguration() {
            return singleMasterConfiguration != null ? singleMasterConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder singleMasterConfiguration(SingleMasterConfiguration singleMasterConfiguration) {
            this.singleMasterConfiguration = singleMasterConfiguration;
            return this;
        }

        public final void setSingleMasterConfiguration(SingleMasterConfiguration.BuilderImpl singleMasterConfiguration) {
            this.singleMasterConfiguration = singleMasterConfiguration != null ? singleMasterConfiguration.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagOnCreateListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagOnCreateListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSignalingChannelRequest build() {
            return new CreateSignalingChannelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
