/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteStreamRequest extends KinesisVideoRequest implements
        ToCopyableBuilder<DeleteStreamRequest.Builder, DeleteStreamRequest> {
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamARN").getter(getter(DeleteStreamRequest::streamARN)).setter(setter(Builder::streamARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()).build();

    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentVersion").getter(getter(DeleteStreamRequest::currentVersion))
            .setter(setter(Builder::currentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ARN_FIELD,
            CURRENT_VERSION_FIELD));

    private final String streamARN;

    private final String currentVersion;

    private DeleteStreamRequest(BuilderImpl builder) {
        super(builder);
        this.streamARN = builder.streamARN;
        this.currentVersion = builder.currentVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the stream that you want to delete.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the stream that you want to delete.
     */
    public String streamARN() {
        return streamARN;
    }

    /**
     * <p>
     * Optional: The version of the stream that you want to delete.
     * </p>
     * <p>
     * Specify the version as a safeguard to ensure that your are deleting the correct stream. To get the stream
     * version, use the <code>DescribeStream</code> API.
     * </p>
     * <p>
     * If not specified, only the <code>CreationTime</code> is checked before deleting the stream.
     * </p>
     * 
     * @return Optional: The version of the stream that you want to delete. </p>
     *         <p>
     *         Specify the version as a safeguard to ensure that your are deleting the correct stream. To get the stream
     *         version, use the <code>DescribeStream</code> API.
     *         </p>
     *         <p>
     *         If not specified, only the <code>CreationTime</code> is checked before deleting the stream.
     */
    public String currentVersion() {
        return currentVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(currentVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteStreamRequest)) {
            return false;
        }
        DeleteStreamRequest other = (DeleteStreamRequest) obj;
        return Objects.equals(streamARN(), other.streamARN()) && Objects.equals(currentVersion(), other.currentVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteStreamRequest").add("StreamARN", streamARN()).add("CurrentVersion", currentVersion())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamARN":
            return Optional.ofNullable(clazz.cast(streamARN()));
        case "CurrentVersion":
            return Optional.ofNullable(clazz.cast(currentVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteStreamRequest, T> g) {
        return obj -> g.apply((DeleteStreamRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisVideoRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteStreamRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the stream that you want to delete.
         * </p>
         * 
         * @param streamARN
         *        The Amazon Resource Name (ARN) of the stream that you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamARN(String streamARN);

        /**
         * <p>
         * Optional: The version of the stream that you want to delete.
         * </p>
         * <p>
         * Specify the version as a safeguard to ensure that your are deleting the correct stream. To get the stream
         * version, use the <code>DescribeStream</code> API.
         * </p>
         * <p>
         * If not specified, only the <code>CreationTime</code> is checked before deleting the stream.
         * </p>
         * 
         * @param currentVersion
         *        Optional: The version of the stream that you want to delete. </p>
         *        <p>
         *        Specify the version as a safeguard to ensure that your are deleting the correct stream. To get the
         *        stream version, use the <code>DescribeStream</code> API.
         *        </p>
         *        <p>
         *        If not specified, only the <code>CreationTime</code> is checked before deleting the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentVersion(String currentVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisVideoRequest.BuilderImpl implements Builder {
        private String streamARN;

        private String currentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteStreamRequest model) {
            super(model);
            streamARN(model.streamARN);
            currentVersion(model.currentVersion);
        }

        public final String getStreamARN() {
            return streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        public final String getCurrentVersion() {
            return currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteStreamRequest build() {
            return new DeleteStreamRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
