/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDataEndpointRequest extends KinesisVideoRequest implements
        ToCopyableBuilder<GetDataEndpointRequest.Builder, GetDataEndpointRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamName").getter(getter(GetDataEndpointRequest::streamName)).setter(setter(Builder::streamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()).build();

    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamARN").getter(getter(GetDataEndpointRequest::streamARN)).setter(setter(Builder::streamARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()).build();

    private static final SdkField<String> API_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("APIName").getter(getter(GetDataEndpointRequest::apiNameAsString)).setter(setter(Builder::apiName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("APIName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD,
            STREAM_ARN_FIELD, API_NAME_FIELD));

    private final String streamName;

    private final String streamARN;

    private final String apiName;

    private GetDataEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.streamARN = builder.streamARN;
        this.apiName = builder.apiName;
    }

    /**
     * <p>
     * The name of the stream that you want to get the endpoint for. You must specify either this parameter or a
     * <code>StreamARN</code> in the request.
     * </p>
     * 
     * @return The name of the stream that you want to get the endpoint for. You must specify either this parameter or a
     *         <code>StreamARN</code> in the request.
     */
    public String streamName() {
        return streamName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the stream that you want to get the endpoint for. You must specify either this
     * parameter or a <code>StreamName</code> in the request.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the stream that you want to get the endpoint for. You must specify
     *         either this parameter or a <code>StreamName</code> in the request.
     */
    public String streamARN() {
        return streamARN;
    }

    /**
     * <p>
     * The name of the API action for which to get an endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #apiName} will
     * return {@link APIName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #apiNameAsString}.
     * </p>
     * 
     * @return The name of the API action for which to get an endpoint.
     * @see APIName
     */
    public APIName apiName() {
        return APIName.fromValue(apiName);
    }

    /**
     * <p>
     * The name of the API action for which to get an endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #apiName} will
     * return {@link APIName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #apiNameAsString}.
     * </p>
     * 
     * @return The name of the API action for which to get an endpoint.
     * @see APIName
     */
    public String apiNameAsString() {
        return apiName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(apiNameAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataEndpointRequest)) {
            return false;
        }
        GetDataEndpointRequest other = (GetDataEndpointRequest) obj;
        return Objects.equals(streamName(), other.streamName()) && Objects.equals(streamARN(), other.streamARN())
                && Objects.equals(apiNameAsString(), other.apiNameAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetDataEndpointRequest").add("StreamName", streamName()).add("StreamARN", streamARN())
                .add("APIName", apiNameAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        case "StreamARN":
            return Optional.ofNullable(clazz.cast(streamARN()));
        case "APIName":
            return Optional.ofNullable(clazz.cast(apiNameAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDataEndpointRequest, T> g) {
        return obj -> g.apply((GetDataEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisVideoRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetDataEndpointRequest> {
        /**
         * <p>
         * The name of the stream that you want to get the endpoint for. You must specify either this parameter or a
         * <code>StreamARN</code> in the request.
         * </p>
         * 
         * @param streamName
         *        The name of the stream that you want to get the endpoint for. You must specify either this parameter
         *        or a <code>StreamARN</code> in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the stream that you want to get the endpoint for. You must specify either
         * this parameter or a <code>StreamName</code> in the request.
         * </p>
         * 
         * @param streamARN
         *        The Amazon Resource Name (ARN) of the stream that you want to get the endpoint for. You must specify
         *        either this parameter or a <code>StreamName</code> in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamARN(String streamARN);

        /**
         * <p>
         * The name of the API action for which to get an endpoint.
         * </p>
         * 
         * @param apiName
         *        The name of the API action for which to get an endpoint.
         * @see APIName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see APIName
         */
        Builder apiName(String apiName);

        /**
         * <p>
         * The name of the API action for which to get an endpoint.
         * </p>
         * 
         * @param apiName
         *        The name of the API action for which to get an endpoint.
         * @see APIName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see APIName
         */
        Builder apiName(APIName apiName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisVideoRequest.BuilderImpl implements Builder {
        private String streamName;

        private String streamARN;

        private String apiName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataEndpointRequest model) {
            super(model);
            streamName(model.streamName);
            streamARN(model.streamARN);
            apiName(model.apiName);
        }

        public final String getStreamName() {
            return streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getStreamARN() {
            return streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        public final String getApiName() {
            return apiName;
        }

        @Override
        public final Builder apiName(String apiName) {
            this.apiName = apiName;
            return this;
        }

        @Override
        public final Builder apiName(APIName apiName) {
            this.apiName(apiName == null ? null : apiName.toString());
            return this;
        }

        public final void setApiName(String apiName) {
            this.apiName = apiName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDataEndpointRequest build() {
            return new GetDataEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
