/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSignalingChannelEndpointResponse extends KinesisVideoResponse implements
        ToCopyableBuilder<GetSignalingChannelEndpointResponse.Builder, GetSignalingChannelEndpointResponse> {
    private static final SdkField<List<ResourceEndpointListItem>> RESOURCE_ENDPOINT_LIST_FIELD = SdkField
            .<List<ResourceEndpointListItem>> builder(MarshallingType.LIST)
            .memberName("ResourceEndpointList")
            .getter(getter(GetSignalingChannelEndpointResponse::resourceEndpointList))
            .setter(setter(Builder::resourceEndpointList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceEndpointList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceEndpointListItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceEndpointListItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ENDPOINT_LIST_FIELD));

    private final List<ResourceEndpointListItem> resourceEndpointList;

    private GetSignalingChannelEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.resourceEndpointList = builder.resourceEndpointList;
    }

    /**
     * Returns true if the ResourceEndpointList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasResourceEndpointList() {
        return resourceEndpointList != null && !(resourceEndpointList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of endpoints for the specified signaling channel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceEndpointList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of endpoints for the specified signaling channel.
     */
    public List<ResourceEndpointListItem> resourceEndpointList() {
        return resourceEndpointList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceEndpointList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSignalingChannelEndpointResponse)) {
            return false;
        }
        GetSignalingChannelEndpointResponse other = (GetSignalingChannelEndpointResponse) obj;
        return Objects.equals(resourceEndpointList(), other.resourceEndpointList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetSignalingChannelEndpointResponse").add("ResourceEndpointList", resourceEndpointList())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceEndpointList":
            return Optional.ofNullable(clazz.cast(resourceEndpointList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSignalingChannelEndpointResponse, T> g) {
        return obj -> g.apply((GetSignalingChannelEndpointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisVideoResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetSignalingChannelEndpointResponse> {
        /**
         * <p>
         * A list of endpoints for the specified signaling channel.
         * </p>
         * 
         * @param resourceEndpointList
         *        A list of endpoints for the specified signaling channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceEndpointList(Collection<ResourceEndpointListItem> resourceEndpointList);

        /**
         * <p>
         * A list of endpoints for the specified signaling channel.
         * </p>
         * 
         * @param resourceEndpointList
         *        A list of endpoints for the specified signaling channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceEndpointList(ResourceEndpointListItem... resourceEndpointList);

        /**
         * <p>
         * A list of endpoints for the specified signaling channel.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResourceEndpointListItem>.Builder} avoiding
         * the need to create one manually via {@link List<ResourceEndpointListItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourceEndpointListItem>.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceEndpointList(List<ResourceEndpointListItem>)}.
         * 
         * @param resourceEndpointList
         *        a consumer that will call methods on {@link List<ResourceEndpointListItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceEndpointList(List<ResourceEndpointListItem>)
         */
        Builder resourceEndpointList(Consumer<ResourceEndpointListItem.Builder>... resourceEndpointList);
    }

    static final class BuilderImpl extends KinesisVideoResponse.BuilderImpl implements Builder {
        private List<ResourceEndpointListItem> resourceEndpointList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSignalingChannelEndpointResponse model) {
            super(model);
            resourceEndpointList(model.resourceEndpointList);
        }

        public final Collection<ResourceEndpointListItem.Builder> getResourceEndpointList() {
            return resourceEndpointList != null ? resourceEndpointList.stream().map(ResourceEndpointListItem::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceEndpointList(Collection<ResourceEndpointListItem> resourceEndpointList) {
            this.resourceEndpointList = ResourceEndpointListCopier.copy(resourceEndpointList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceEndpointList(ResourceEndpointListItem... resourceEndpointList) {
            resourceEndpointList(Arrays.asList(resourceEndpointList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceEndpointList(Consumer<ResourceEndpointListItem.Builder>... resourceEndpointList) {
            resourceEndpointList(Stream.of(resourceEndpointList)
                    .map(c -> ResourceEndpointListItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceEndpointList(Collection<ResourceEndpointListItem.BuilderImpl> resourceEndpointList) {
            this.resourceEndpointList = ResourceEndpointListCopier.copyFromBuilder(resourceEndpointList);
        }

        @Override
        public GetSignalingChannelEndpointResponse build() {
            return new GetSignalingChannelEndpointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
