/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSignalingChannelsRequest extends KinesisVideoRequest implements
        ToCopyableBuilder<ListSignalingChannelsRequest.Builder, ListSignalingChannelsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListSignalingChannelsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListSignalingChannelsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<ChannelNameCondition> CHANNEL_NAME_CONDITION_FIELD = SdkField
            .<ChannelNameCondition> builder(MarshallingType.SDK_POJO).memberName("ChannelNameCondition")
            .getter(getter(ListSignalingChannelsRequest::channelNameCondition)).setter(setter(Builder::channelNameCondition))
            .constructor(ChannelNameCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelNameCondition").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, CHANNEL_NAME_CONDITION_FIELD));

    private final Integer maxResults;

    private final String nextToken;

    private final ChannelNameCondition channelNameCondition;

    private ListSignalingChannelsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.channelNameCondition = builder.channelNameCondition;
    }

    /**
     * <p>
     * The maximum number of channels to return in the response. The default is 500.
     * </p>
     * 
     * @return The maximum number of channels to return in the response. The default is 500.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If you specify this parameter, when the result of a <code>ListSignalingChannels</code> operation is truncated,
     * the call returns the <code>NextToken</code> in the response. To get another batch of channels, provide this token
     * in your next request.
     * </p>
     * 
     * @return If you specify this parameter, when the result of a <code>ListSignalingChannels</code> operation is
     *         truncated, the call returns the <code>NextToken</code> in the response. To get another batch of channels,
     *         provide this token in your next request.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Optional: Returns only the channels that satisfy a specific condition.
     * </p>
     * 
     * @return Optional: Returns only the channels that satisfy a specific condition.
     */
    public ChannelNameCondition channelNameCondition() {
        return channelNameCondition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(channelNameCondition());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSignalingChannelsRequest)) {
            return false;
        }
        ListSignalingChannelsRequest other = (ListSignalingChannelsRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(channelNameCondition(), other.channelNameCondition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListSignalingChannelsRequest").add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("ChannelNameCondition", channelNameCondition()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ChannelNameCondition":
            return Optional.ofNullable(clazz.cast(channelNameCondition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSignalingChannelsRequest, T> g) {
        return obj -> g.apply((ListSignalingChannelsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisVideoRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListSignalingChannelsRequest> {
        /**
         * <p>
         * The maximum number of channels to return in the response. The default is 500.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of channels to return in the response. The default is 500.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If you specify this parameter, when the result of a <code>ListSignalingChannels</code> operation is
         * truncated, the call returns the <code>NextToken</code> in the response. To get another batch of channels,
         * provide this token in your next request.
         * </p>
         * 
         * @param nextToken
         *        If you specify this parameter, when the result of a <code>ListSignalingChannels</code> operation is
         *        truncated, the call returns the <code>NextToken</code> in the response. To get another batch of
         *        channels, provide this token in your next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Optional: Returns only the channels that satisfy a specific condition.
         * </p>
         * 
         * @param channelNameCondition
         *        Optional: Returns only the channels that satisfy a specific condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelNameCondition(ChannelNameCondition channelNameCondition);

        /**
         * <p>
         * Optional: Returns only the channels that satisfy a specific condition.
         * </p>
         * This is a convenience that creates an instance of the {@link ChannelNameCondition.Builder} avoiding the need
         * to create one manually via {@link ChannelNameCondition#builder()}.
         *
         * When the {@link Consumer} completes, {@link ChannelNameCondition.Builder#build()} is called immediately and
         * its result is passed to {@link #channelNameCondition(ChannelNameCondition)}.
         * 
         * @param channelNameCondition
         *        a consumer that will call methods on {@link ChannelNameCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channelNameCondition(ChannelNameCondition)
         */
        default Builder channelNameCondition(Consumer<ChannelNameCondition.Builder> channelNameCondition) {
            return channelNameCondition(ChannelNameCondition.builder().applyMutation(channelNameCondition).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisVideoRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private ChannelNameCondition channelNameCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSignalingChannelsRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            channelNameCondition(model.channelNameCondition);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final ChannelNameCondition.Builder getChannelNameCondition() {
            return channelNameCondition != null ? channelNameCondition.toBuilder() : null;
        }

        @Override
        public final Builder channelNameCondition(ChannelNameCondition channelNameCondition) {
            this.channelNameCondition = channelNameCondition;
            return this;
        }

        public final void setChannelNameCondition(ChannelNameCondition.BuilderImpl channelNameCondition) {
            this.channelNameCondition = channelNameCondition != null ? channelNameCondition.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSignalingChannelsRequest build() {
            return new ListSignalingChannelsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
