/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateStreamRequest extends KinesisVideoRequest implements
        ToCopyableBuilder<UpdateStreamRequest.Builder, UpdateStreamRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamName").getter(getter(UpdateStreamRequest::streamName)).setter(setter(Builder::streamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()).build();

    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamARN").getter(getter(UpdateStreamRequest::streamARN)).setter(setter(Builder::streamARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()).build();

    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentVersion").getter(getter(UpdateStreamRequest::currentVersion))
            .setter(setter(Builder::currentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentVersion").build()).build();

    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceName").getter(getter(UpdateStreamRequest::deviceName)).setter(setter(Builder::deviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName").build()).build();

    private static final SdkField<String> MEDIA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MediaType").getter(getter(UpdateStreamRequest::mediaType)).setter(setter(Builder::mediaType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD,
            STREAM_ARN_FIELD, CURRENT_VERSION_FIELD, DEVICE_NAME_FIELD, MEDIA_TYPE_FIELD));

    private final String streamName;

    private final String streamARN;

    private final String currentVersion;

    private final String deviceName;

    private final String mediaType;

    private UpdateStreamRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.streamARN = builder.streamARN;
        this.currentVersion = builder.currentVersion;
        this.deviceName = builder.deviceName;
        this.mediaType = builder.mediaType;
    }

    /**
     * <p>
     * The name of the stream whose metadata you want to update.
     * </p>
     * <p>
     * The stream name is an identifier for the stream, and must be unique for each account and region.
     * </p>
     * 
     * @return The name of the stream whose metadata you want to update.</p>
     *         <p>
     *         The stream name is an identifier for the stream, and must be unique for each account and region.
     */
    public String streamName() {
        return streamName;
    }

    /**
     * <p>
     * The ARN of the stream whose metadata you want to update.
     * </p>
     * 
     * @return The ARN of the stream whose metadata you want to update.
     */
    public String streamARN() {
        return streamARN;
    }

    /**
     * <p>
     * The version of the stream whose metadata you want to update.
     * </p>
     * 
     * @return The version of the stream whose metadata you want to update.
     */
    public String currentVersion() {
        return currentVersion;
    }

    /**
     * <p>
     * The name of the device that is writing to the stream.
     * </p>
     * <note>
     * <p>
     * In the current implementation, Kinesis Video Streams does not use this name.
     * </p>
     * </note>
     * 
     * @return The name of the device that is writing to the stream. </p> <note>
     *         <p>
     *         In the current implementation, Kinesis Video Streams does not use this name.
     *         </p>
     */
    public String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * The stream's media type. Use <code>MediaType</code> to specify the type of content that the stream contains to
     * the consumers of the stream. For more information about media types, see <a
     * href="http://www.iana.org/assignments/media-types/media-types.xhtml">Media Types</a>. If you choose to specify
     * the <code>MediaType</code>, see <a href="https://tools.ietf.org/html/rfc6838#section-4.2">Naming
     * Requirements</a>.
     * </p>
     * <p>
     * To play video on the console, you must specify the correct video type. For example, if the video in the stream is
     * H.264, specify <code>video/h264</code> as the <code>MediaType</code>.
     * </p>
     * 
     * @return The stream's media type. Use <code>MediaType</code> to specify the type of content that the stream
     *         contains to the consumers of the stream. For more information about media types, see <a
     *         href="http://www.iana.org/assignments/media-types/media-types.xhtml">Media Types</a>. If you choose to
     *         specify the <code>MediaType</code>, see <a href="https://tools.ietf.org/html/rfc6838#section-4.2">Naming
     *         Requirements</a>.</p>
     *         <p>
     *         To play video on the console, you must specify the correct video type. For example, if the video in the
     *         stream is H.264, specify <code>video/h264</code> as the <code>MediaType</code>.
     */
    public String mediaType() {
        return mediaType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(mediaType());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStreamRequest)) {
            return false;
        }
        UpdateStreamRequest other = (UpdateStreamRequest) obj;
        return Objects.equals(streamName(), other.streamName()) && Objects.equals(streamARN(), other.streamARN())
                && Objects.equals(currentVersion(), other.currentVersion()) && Objects.equals(deviceName(), other.deviceName())
                && Objects.equals(mediaType(), other.mediaType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateStreamRequest").add("StreamName", streamName()).add("StreamARN", streamARN())
                .add("CurrentVersion", currentVersion()).add("DeviceName", deviceName()).add("MediaType", mediaType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        case "StreamARN":
            return Optional.ofNullable(clazz.cast(streamARN()));
        case "CurrentVersion":
            return Optional.ofNullable(clazz.cast(currentVersion()));
        case "DeviceName":
            return Optional.ofNullable(clazz.cast(deviceName()));
        case "MediaType":
            return Optional.ofNullable(clazz.cast(mediaType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateStreamRequest, T> g) {
        return obj -> g.apply((UpdateStreamRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisVideoRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateStreamRequest> {
        /**
         * <p>
         * The name of the stream whose metadata you want to update.
         * </p>
         * <p>
         * The stream name is an identifier for the stream, and must be unique for each account and region.
         * </p>
         * 
         * @param streamName
         *        The name of the stream whose metadata you want to update.</p>
         *        <p>
         *        The stream name is an identifier for the stream, and must be unique for each account and region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * The ARN of the stream whose metadata you want to update.
         * </p>
         * 
         * @param streamARN
         *        The ARN of the stream whose metadata you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamARN(String streamARN);

        /**
         * <p>
         * The version of the stream whose metadata you want to update.
         * </p>
         * 
         * @param currentVersion
         *        The version of the stream whose metadata you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentVersion(String currentVersion);

        /**
         * <p>
         * The name of the device that is writing to the stream.
         * </p>
         * <note>
         * <p>
         * In the current implementation, Kinesis Video Streams does not use this name.
         * </p>
         * </note>
         * 
         * @param deviceName
         *        The name of the device that is writing to the stream. </p> <note>
         *        <p>
         *        In the current implementation, Kinesis Video Streams does not use this name.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * The stream's media type. Use <code>MediaType</code> to specify the type of content that the stream contains
         * to the consumers of the stream. For more information about media types, see <a
         * href="http://www.iana.org/assignments/media-types/media-types.xhtml">Media Types</a>. If you choose to
         * specify the <code>MediaType</code>, see <a href="https://tools.ietf.org/html/rfc6838#section-4.2">Naming
         * Requirements</a>.
         * </p>
         * <p>
         * To play video on the console, you must specify the correct video type. For example, if the video in the
         * stream is H.264, specify <code>video/h264</code> as the <code>MediaType</code>.
         * </p>
         * 
         * @param mediaType
         *        The stream's media type. Use <code>MediaType</code> to specify the type of content that the stream
         *        contains to the consumers of the stream. For more information about media types, see <a
         *        href="http://www.iana.org/assignments/media-types/media-types.xhtml">Media Types</a>. If you choose to
         *        specify the <code>MediaType</code>, see <a
         *        href="https://tools.ietf.org/html/rfc6838#section-4.2">Naming Requirements</a>.</p>
         *        <p>
         *        To play video on the console, you must specify the correct video type. For example, if the video in
         *        the stream is H.264, specify <code>video/h264</code> as the <code>MediaType</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaType(String mediaType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisVideoRequest.BuilderImpl implements Builder {
        private String streamName;

        private String streamARN;

        private String currentVersion;

        private String deviceName;

        private String mediaType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStreamRequest model) {
            super(model);
            streamName(model.streamName);
            streamARN(model.streamARN);
            currentVersion(model.currentVersion);
            deviceName(model.deviceName);
            mediaType(model.mediaType);
        }

        public final String getStreamName() {
            return streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getStreamARN() {
            return streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        public final String getCurrentVersion() {
            return currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        public final String getDeviceName() {
            return deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public final String getMediaType() {
            return mediaType;
        }

        @Override
        public final Builder mediaType(String mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        public final void setMediaType(String mediaType) {
            this.mediaType = mediaType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStreamRequest build() {
            return new UpdateStreamRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
