/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure describes the filtering of columns in a table based on a filter condition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FilterCondition implements SdkPojo, Serializable, ToCopyableBuilder<FilterCondition.Builder, FilterCondition> {
    private static final SdkField<String> FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Field")
            .getter(getter(FilterCondition::fieldAsString)).setter(setter(Builder::field))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Field").build()).build();

    private static final SdkField<String> COMPARISON_OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComparisonOperator").getter(getter(FilterCondition::comparisonOperatorAsString))
            .setter(setter(Builder::comparisonOperator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonOperator").build())
            .build();

    private static final SdkField<List<String>> STRING_VALUE_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("StringValueList")
            .getter(getter(FilterCondition::stringValueList))
            .setter(setter(Builder::stringValueList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringValueList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_FIELD,
            COMPARISON_OPERATOR_FIELD, STRING_VALUE_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String field;

    private final String comparisonOperator;

    private final List<String> stringValueList;

    private FilterCondition(BuilderImpl builder) {
        this.field = builder.field;
        this.comparisonOperator = builder.comparisonOperator;
        this.stringValueList = builder.stringValueList;
    }

    /**
     * <p>
     * The field to filter in the filter condition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #field} will return
     * {@link FieldNameString#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fieldAsString}.
     * </p>
     * 
     * @return The field to filter in the filter condition.
     * @see FieldNameString
     */
    public FieldNameString field() {
        return FieldNameString.fromValue(field);
    }

    /**
     * <p>
     * The field to filter in the filter condition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #field} will return
     * {@link FieldNameString#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fieldAsString}.
     * </p>
     * 
     * @return The field to filter in the filter condition.
     * @see FieldNameString
     */
    public String fieldAsString() {
        return field;
    }

    /**
     * <p>
     * The comparison operator used in the filter condition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #comparisonOperator} will return {@link ComparisonOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #comparisonOperatorAsString}.
     * </p>
     * 
     * @return The comparison operator used in the filter condition.
     * @see ComparisonOperator
     */
    public ComparisonOperator comparisonOperator() {
        return ComparisonOperator.fromValue(comparisonOperator);
    }

    /**
     * <p>
     * The comparison operator used in the filter condition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #comparisonOperator} will return {@link ComparisonOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #comparisonOperatorAsString}.
     * </p>
     * 
     * @return The comparison operator used in the filter condition.
     * @see ComparisonOperator
     */
    public String comparisonOperatorAsString() {
        return comparisonOperator;
    }

    /**
     * Returns true if the StringValueList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasStringValueList() {
        return stringValueList != null && !(stringValueList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A string with values used in evaluating the filter condition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStringValueList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A string with values used in evaluating the filter condition.
     */
    public List<String> stringValueList() {
        return stringValueList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldAsString());
        hashCode = 31 * hashCode + Objects.hashCode(comparisonOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stringValueList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterCondition)) {
            return false;
        }
        FilterCondition other = (FilterCondition) obj;
        return Objects.equals(fieldAsString(), other.fieldAsString())
                && Objects.equals(comparisonOperatorAsString(), other.comparisonOperatorAsString())
                && Objects.equals(stringValueList(), other.stringValueList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("FilterCondition").add("Field", fieldAsString())
                .add("ComparisonOperator", comparisonOperatorAsString()).add("StringValueList", stringValueList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Field":
            return Optional.ofNullable(clazz.cast(fieldAsString()));
        case "ComparisonOperator":
            return Optional.ofNullable(clazz.cast(comparisonOperatorAsString()));
        case "StringValueList":
            return Optional.ofNullable(clazz.cast(stringValueList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FilterCondition, T> g) {
        return obj -> g.apply((FilterCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FilterCondition> {
        /**
         * <p>
         * The field to filter in the filter condition.
         * </p>
         * 
         * @param field
         *        The field to filter in the filter condition.
         * @see FieldNameString
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FieldNameString
         */
        Builder field(String field);

        /**
         * <p>
         * The field to filter in the filter condition.
         * </p>
         * 
         * @param field
         *        The field to filter in the filter condition.
         * @see FieldNameString
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FieldNameString
         */
        Builder field(FieldNameString field);

        /**
         * <p>
         * The comparison operator used in the filter condition.
         * </p>
         * 
         * @param comparisonOperator
         *        The comparison operator used in the filter condition.
         * @see ComparisonOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComparisonOperator
         */
        Builder comparisonOperator(String comparisonOperator);

        /**
         * <p>
         * The comparison operator used in the filter condition.
         * </p>
         * 
         * @param comparisonOperator
         *        The comparison operator used in the filter condition.
         * @see ComparisonOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComparisonOperator
         */
        Builder comparisonOperator(ComparisonOperator comparisonOperator);

        /**
         * <p>
         * A string with values used in evaluating the filter condition.
         * </p>
         * 
         * @param stringValueList
         *        A string with values used in evaluating the filter condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValueList(Collection<String> stringValueList);

        /**
         * <p>
         * A string with values used in evaluating the filter condition.
         * </p>
         * 
         * @param stringValueList
         *        A string with values used in evaluating the filter condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValueList(String... stringValueList);
    }

    static final class BuilderImpl implements Builder {
        private String field;

        private String comparisonOperator;

        private List<String> stringValueList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FilterCondition model) {
            field(model.field);
            comparisonOperator(model.comparisonOperator);
            stringValueList(model.stringValueList);
        }

        public final String getField() {
            return field;
        }

        @Override
        public final Builder field(String field) {
            this.field = field;
            return this;
        }

        @Override
        public final Builder field(FieldNameString field) {
            this.field(field == null ? null : field.toString());
            return this;
        }

        public final void setField(String field) {
            this.field = field;
        }

        public final String getComparisonOperator() {
            return comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator == null ? null : comparisonOperator.toString());
            return this;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        public final Collection<String> getStringValueList() {
            return stringValueList;
        }

        @Override
        public final Builder stringValueList(Collection<String> stringValueList) {
            this.stringValueList = StringValueListCopier.copy(stringValueList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringValueList(String... stringValueList) {
            stringValueList(Arrays.asList(stringValueList));
            return this;
        }

        public final void setStringValueList(Collection<String> stringValueList) {
            this.stringValueList = StringValueListCopier.copy(stringValueList);
        }

        @Override
        public FilterCondition build() {
            return new FilterCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
